!!! info "Last Revised Date"

    This notice was last updated on May 04, 2024.

# Privacy Notice

This privacy notice for DanLing Team (also known as DanLing) ('we', 'us', or 'our'), describes how and why we might collect, store, use, and/or share ('process') your information when you use our services ('Services'), such as when you:

- Visit our website at [chanfig.danling.org](https://chanfig.danling.org), or any website of ours that links to this privacy notice

You can change your privacy settings at any time by clicking the button below:

[Privacy Control](#__consent){ .md-button }

**Questions or concerns?**
Reading this privacy notice will help you understand your privacy rights and choices.
If you do not agree with our policies and practices, please do not use our Services.
If you still have any questions or concerns, please contact us at [privacy@danling.org](mailto:privacy@danling.org).

## 0. Summary of Key Points

This summary provides key points from our privacy notice, but you can find out more details about any of these topics by clicking the link following each key point or by using our table of contents below to find the section you are looking for.

<div class="grid cards" markdown>

!!! question "What personal information do we process?"

    When you visit, use, or navigate our Services, we may process personal information depending on how you interact with us and the Services, the choices you make, and the products and features you use.

    [:octicons-arrow-right-24: What information do we collect?](#1-what-information-do-we-collect)

!!! question "How do we process your information?"

    We process your information to provide, improve, and administer our Services, communicate with you, for security and fraud prevention, and to comply with law.
    We may also process your information for other purposes with your consent.
    We process your information only when we have a valid legal reason to do so.

    [:octicons-arrow-right-24: How do we process your information?](#2-how-do-we-process-your-information)

!!! question "Do we process any sensitive personal information?"

    We do not process any sensitive personal information.

!!! question "Do we collect any information from third parties?"

    We do not collect any information from third parties.

!!! question "In what situations and with which parties do we share personal information?"

    We may share information in specific situations and with specific third parties.

    [:octicons-arrow-right-24: When and with whom we share your personal information?](#4-when-and-with-whom-do-we-share-your-personal-information)

!!! question "How do we keep your information safe?"

    We have organisational and technical processes and procedures in place to protect your personal information.

    [:octicons-arrow-right-24: How do we keep your information safe?](#7-how-do-we-keep-your-information-safe)

!!! question "What are your rights?"

    Depending on where you are located geographically, the applicable privacy law may mean you have certain rights regarding your personal information.

    [:octicons-arrow-right-24: What are your privacy rights?](#8-what-are-your-privacy-rights)

!!! question "How do you exercise your rights?"

    The easiest way to exercise your rights is by contacting the relevant data protection authority in your jurisdiction.

    [:octicons-arrow-right-24: How to exercise your rights](#how-to-exercise-your-rights)

</div>

## 1. What information do we collect?

### Personal information you disclose to us

!!! tip "In Short"

    We collect personal information that you provide to us.

We collect personal information that you voluntarily provide to us when you express an interest in obtaining information about us or our products and Services, when you participate in activities on the Services, or otherwise when you contact us.

!!! danger "Sensitive Personal Information"

    We do not collect any sensitive personal information from you.

### Information automatically collected

!!! tip "In Short"

    Some information — such as IP address and/or browser and device characteristics — is collected automatically when you visit our Services.

We automatically collect certain information when you visit, use, or navigate our Services.
This information does not reveal your specific identity (like your name or contact information) but may include device and usage information, such as your IP address, browser and device characteristics, operating system, language preferences, referring URLs, device name, country, location, information about how and when you use our Services, and other technical information.
This information is primarily needed to maintain the security and operation of our Services, and for our internal analytics and reporting purposes.

Like many businesses, we also collect information through cookies and similar technologies.

The information we collect includes:

- **Identifiers.**
    Identifier is a device and browser-specific unique random string that we generate when you use our Service.
    This identifier is stored in a cookie on your device, allowing us to identify you across multiple sessions and when you return to our Service.
  You can delete this cookie at any time by clearing your browser's cache.
- **Log and Usage Data.**
    Log and usage data is service-related, diagnostic, usage, and performance information our servers automatically collect when you access or use our Services and which we record in log files.
    Depending on how you interact with us, this log data may include your IP address, device information, browser type, and settings, and information about your activity in the Services (such as the date/time stamps associated with your usage, pages and files viewed, searches and other actions you take such as which features you use), device event information (such as system activity, error reports (sometimes called 'crash dumps') and hardware settings).
- **Device Data.**
    We collect device data such as information about your computer, phone, tablet, or other devices you use to access the Services.
    Depending on the device used, this device data may include information such as your IP address (or proxy server), device and application identification numbers, location, browser type, hardware model, Internet Service Provider and/or mobile carrier, operating system, and system configuration information.
- **Location Data.**
    We collect location data such as information about your device's location, which can be either precise or imprecise.
    How much information we collect depends on the type and settings of the device you use to access the Services.
    For example, we may use GPS and other technologies to collect geolocation data that tells us your current location (based on your IP address).
    You can opt out of allowing us to collect this information either by refusing access to the information or by disabling your location settings on your device.

### Categories of Personal Information We Collect

We have collected the following categories of personal information in the past twelve (12) months:

| Category                                                                      | Examples                                                                                                                                                                                                 | Collected |
| ----------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------- |
| A. Identifiers                                                                | Contact details, such as real name, alias, postal address, telephone or mobile contact number, unique personal identifier, online identifier, Internet Protocol address, email address, and account name | YES       |
| B. Personal information as defined in the California Customer Records statute | Name, contact information, education, employment, employment history, and financial information                                                                                                          | NO        |
| C. Protected classification characteristics under state or federal law        | Gender, age, date of birth, race and ethnicity, national origin, marital status, and other demographic data                                                                                              | NO        |
| D. Commercial information                                                     | Transaction information, purchase history, financial details, and payment information                                                                                                                    | NO        |
| E. Biometric information                                                      | Fingerprints and voiceprints                                                                                                                                                                             | NO        |
| F. Internet or other similar network activity                                 | Browsing history, search history, online behaviour, interest data, and interactions with our and other websites, applications, systems, and advertisements                                               | YES       |
| G. Geolocation data                                                           | Device location                                                                                                                                                                                          | YES       |
| H. Audio, electronic, sensory, or similar information                         | Images and audio, video or call recordings created in connection with our business activities                                                                                                            | NO        |
| I. Professional or employment-related information                             | Business contact details in order to provide you our Services at a business level or job title, work history, and professional qualifications if you apply for a job with us                             | NO        |
| J. Education Information                                                      | Student records and directory information                                                                                                                                                                | NO        |
| K. Inferences drawn from collected personal information                       | Inferences drawn from any of the collected personal information listed above to create a profile or summary about, for example, an individual’s preferences and characteristics                          | YES       |
| L. Sensitive personal Information                                             |                                                                                                                                                                                                          | NO        |

We may also collect other personal information outside of these categories through instances where you interact with us in person, online, or by phone or mail in the context of:

- Receiving help through our customer support channels;
- Participation in customer surveys or contests; and
- Facilitation in the delivery of our Services and to respond to your inquiries.

We will use and retain the collected personal information as needed to provide you with our Services and as necessary to comply with our legal obligations, resolve disputes, and enforce our agreement for the following period:

- Category A: Indefinitely
- Category F: Indefinitely
- Category G: Indefinitely
- Category K: Indefinitely

## 2. How do we process your information?

!!! tip "In Short"

    We process your information to provide, improve, and administer our Services, communicate with you, for security and fraud prevention, and to comply with law.
    We may also process your information for other purposes with your consent.

We process your personal information for a variety of reasons, depending on how you interact with our Services, including:

- **To protect our Services.**
    We may process your information as part of our efforts to keep our Services safe and secure, including fraud monitoring and prevention.
- **To identify user trends.**
    We may process information about how you use our Services to better understand how they are being used so we can improve them.
- **To save or protect an individual's vital interest.**
    We may process your information when necessary to save or protect an individual’s vital interest, such as to prevent harm.

## 3. What legal basis do we have for processing your information?

!!! tip "In Short"

    We only process your personal information when we believe it is necessary and we have a valid legal reason (i.e. legal basis) to do so under applicable law, like with your consent, to comply with laws, to provide you with services to enter into or fulfil our contractual obligations, to protect your rights, or to fulfil our legitimate business interests.

The General Data Protection Regulation (GDPR) and UK GDPR require us to explain the valid legal bases we rely on in order to process your personal information.
As such, we may rely on the following legal bases to process your personal information:

- **Consent.**
    We may process your personal information if you have given us specific consent to use your personal information for a specific purpose.
    You have the right to withdraw your consent at any time.
    Learn more about [withdrawing your consents]().
- **Legitimate Interests.**
    We may process your information when we believe it is reasonably necessary to achieve our legitimate business interests and those interests do not outweigh your interests and fundamental rights and freedoms.
    For example, we may process your personal information for some of the purposes described in order to:
    - Analyse how our Services are used so we can improve them to engage and retain users
    - Diagnose problems and/or prevent fraudulent activities
- **Legal Obligations.**
    We may process your information where we believe it is necessary for compliance with our legal obligations, such as to cooperate with a law enforcement body or regulatory agency, exercise or defend our legal rights, or disclose your information as evidence in litigation in which we are involved.
- **Vital Interests.**
    We may process your information where we believe it is necessary to protect your vital interests or the vital interests of a third party, such as situations involving potential threats to the safety of any person.

!!! info "Consent to Processing in Canada"

    If you are located in Canada, we may be legally permitted under applicable law to process your information without your consent in some exceptional cases, including, for example:

    - If collection is clearly in the interests of an individual and consent cannot be obtained in a timely way
    - For investigations and fraud detection and prevention
    - For business transactions provided certain conditions are met
    - If it is contained in a witness statement and the collection is necessary to assess, process, or settle an insurance claim
    - For identifying injured, ill, or deceased persons and communicating with next of kin
    - If we have reasonable grounds to believe an individual has been, is, or may be victim of financial abuse
    - If it is reasonable to expect collection and use with consent would compromise the availability or the accuracy of the information and the collection is reasonable for purposes related to investigating a breach of an agreement or a contravention of the laws of Canada or a province
    - If disclosure is required to comply with a subpoena, warrant, court order, or rules of the court relating to the production of records
    - If it was produced by an individual in the course of their employment, business, or profession and the collection is consistent with the purposes for which the information was produced
    - If the collection is solely for journalistic, artistic, or literary purposes
    - If the information is publicly available and is specified by the regulations

## 4. When and with whom do we share your personal information?

!!! tip "In Short"

    We may share information in specific situations described in this section and/or with the following third parties.

We may use your personal information for our business purposes, such as for undertaking internal research for technological development and demonstration.
This is not considered to be 'selling' of your personal information.

**Vendors, Consultants, and Other Third-Party Service Providers.**
We may share your data with third-party vendors, service providers, contractors, or agents ('third parties') who perform services for us or on our behalf and require access to such information to do that work.
We have contracts in place with our third parties, which are designed to help safeguard your personal information.
This means that they cannot do anything with your personal information unless we have instructed them to do it.
They will also not share your personal information with any organisation apart from us.
They also commit to protect the data they hold on our behalf and to retain it for the period we instruct.

The third parties we may share personal information with are as follows:

- **Advertising, Direct Marketing, and Lead Generation**
    - Google AdSense
- **Cloud Computing Services**
    - Microsoft Azure
    - Amazon Web Services (AWS)
    - Google Cloud Platform (GCP)
- **Communications and Content Delivery Network (CDN) Services**
    - Cloudflare
- **Content Optimisation**
    - Google Site Search
    - Google Fonts
- **Functionality and Infrastructure Optimisation**
    - GitHub Pages
- **User Commenting and Forums**
    - Disqus
    - GitHub Issues
    - GitHub Discussions
- **Web and Mobile Analytics**
    - Google Analytics

We also may need to share your personal information in the following situations:

- **Business Transfers.**
    We may share or transfer your information in connection with, or during negotiations of, any merger, sale of company assets, financing, or acquisition of all or a portion of our business to another company.

!!! info "We have disclosed the following categories of personal information for a business purpose in the past twelve (12) months:"

    Nill

!!! info "The categories of third parties to whom we sold personal information in the past twelve (12) months:"

    Nill

!!! info "The categories of third parties to whom we shared personal information with in the past twelve (12) months:"

    - **Web and Mobile Analytics**
        - Google Analytics

## 5. Do we use cookies and other tracking technologies?

!!! tip "In Short"

    We may use cookies and other tracking technologies to collect and store your information.

We also permit third parties and service providers to use online tracking technologies on our Services for analytics and advertising, including to help manage and display advertisements, to tailor advertisements to your interests, or to send abandoned shopping cart reminders (depending on your communication preferences).
The third parties and service providers use their technology to provide advertising about products and services tailored to your interests which may appear either on our Services or on other websites.

To the extent these online tracking technologies are deemed to be a 'sale'/'sharing' (which includes targeted advertising, as defined under the applicable laws) under applicable US state laws, you can opt out of these online tracking technologies by clicking the button on the top of this page or the button below:

[Privacy Control](#__consent){ .md-button }

<!-- Specific information about how we use such technologies and how you can refuse certain cookies is set out in our Cookie Notice: chanfig.danling.org/about/cookie. -->

### Google Analytics

We may share your information with Google Analytics to track and analyse the use of the Services.
The Google Analytics Advertising Features that we may use include:

- Remarketing with Google Analytics
- Google Display Network Impressions Reporting
- Google Analytics Demographics and Interests Reporting

To opt out of being tracked by Google Analytics across the Services, visit [https://tools.google.com/dlpage/gaoptout](https://tools.google.com/dlpage/gaoptout).
You can opt out of Google Analytics Advertising Features through [Ads Settings](https://adssettings.google.com) and Ad Settings for mobile apps.

Other opt out means include [http://optout.networkadvertising.org/](http://optout.networkadvertising.org/) and [http://www.networkadvertising.org/mobile-choice](http://www.networkadvertising.org/mobile-choice).

For more information on the privacy practices of Google, please visit the [Google Privacy & Terms](https://policies.google.com/privacy).

## 6. How long do we keep your information?

!!! tip "In Short"

    We keep your information for as long as necessary to fulfil the purposes outlined in this privacy notice unless otherwise required by law.

We will only keep your personal information for as long as it is necessary for the purposes set out in this privacy notice, unless a longer retention period is required or permitted by law (such as tax, accounting, or other legal requirements).

When we have no ongoing legitimate business need to process your personal information, we will either delete or anonymise it, or, if this is not possible (for example, because your personal information has been stored in backup archives), then we will securely store your personal information and isolate it from any further processing until deletion is possible.

## 7. How do we keep your information safe?

!!! tip "In Short"

    We aim to protect your personal information through a system of organisational and technical security measures.

We have implemented appropriate technical and organisational security measures designed to protect the security of any personal information we process.
However, despite our safeguards and efforts to secure your information, no electronic transmission over the internet or information storage technology can be guaranteed to be 100% secure, so we cannot promise or guarantee that hackers, cybercriminals, or other unauthorised third parties will not be able to defeat our security and improperly collect, access, steal, or modify your information.
Although we will do our best to protect your personal information, the transmission of personal information to and from our Services is at your own risk.
You should only access the Services within a secure environment.

## 8. What are your privacy rights?

!!! tip "In Short"

    We strive to protect your privacy rights and choices to the best possible extent under the law.

You have rights under certain data protection laws.
However, these rights are not absolute, and in certain cases, we may decline your request as permitted by law.
These rights include:

- **Right to know**
    whether or not we are processing your personal data
- **Right to access**
    your personal data
- **Right to correct**
    inaccuracies in your personal data
- **Right to request**
    the deletion of your personal data
- **Right to obtain a copy**
    of the personal data you previously shared with us
- **Right to non-discrimination**
    against you for exercising your rights
- **Right to opt-out**
    - of the processing of your personal data if it is used for targeted advertising (or sharing as defined under applicable laws), the sale of personal data, or profiling in furtherance of decisions that produce legal or similarly significant effects ('profiling') concerning you
    - of the collection of sensitive data and personal data collected through the operation of a voice or facial recognition feature
- **Right to obtain**
    - a list of the categories of third parties to which we have disclosed personal data
    - a list of specific third parties to which we have disclosed personal data
- **Right to limit**
    use and disclosure of sensitive personal data

### How to exercise your rights

It is very unlikely that you will be able to exercise the above rights as we do not collect any identifiable personal data from you.

We are unable to reply to and act on data subject access request as we do not save any identifiable information about you, and we will not be able to verify your identity.

If you believe we are unlawfully processing your personal information, you can contact the relevant data protection regulator, state attorney general, or other competent authority in your jurisdiction.

| Residency                       | Authority                                                                                                                            |
| ------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------ |
| European Economic Area          | [Member State's data protection supervisory authority](https://edpb.europa.eu/about-edpb/board/members_en)                           |
| United Kingdom                  | [Information Commissioner's Office](https://ico.org.uk/make-a-complaint/)                                                            |
| Australia                       | [Office of the Australian Information Commissioner](https://www.oaic.gov.au/privacy/privacy-complaints/)                             |
| New Zealand                     | [Office of New Zealand Privacy Commissioner](https://www.privacy.org.nz/your-rights/making-a-complaint-to-the-privacy-commissioner/) |
| Canada                          | [Office of the Privacy Commissioner of Canada](https://www.priv.gc.ca/en/)                                                           |
| California of the United States | [California Privacy Protection Agency](https://cppa.ca.gov/webapplications/complaint/)                                               |
| Switzerland                     | [Federal Data Protection and Information Commissioner](https://www.edoeb.admin.ch/edoeb/en/home/the-fdpic/contact.html)              |
| South Africa                    | [Information Regulator](https://inforegulator.org.za/training/wp/complaints/)                                                        |

#### Withdraw your consent

If we are relying on your consent to process your personal information, which may be express and/or implied consent depending on the applicable law, you have the right to withdraw your consent at any time.
You can withdraw your consent at any time by clicking the button on the top of this page or the button below:

[Privacy Control](#__consent){ .md-button }

However, please note that this will not affect the lawfulness of the processing before its withdrawal nor, when applicable law allows, will it affect the processing of your personal information conducted in reliance on lawful processing grounds other than consent.

#### Cookies and similar technologies

Most web browsers are set to accept cookies by default.
If you prefer, you can usually choose to set your browser to remove or reject browser cookies.
Please note that if you choose to remove or reject cookies, this will NOT affect the availability and functionality of our Services.

## 9. Controls for Do-Not-Track features

Most web browsers and some mobile operating systems and mobile applications include a Do-Not-Track ('DNT') feature or setting you can activate to signal your privacy preference not to have data about your online browsing activities monitored and collected.
At this stage, no uniform technology standard for recognising and implementing DNT signals has been finalised.
Although we cannot promise to honour every DNT signal, we strive to honour all such requests where technically feasible.

California law requires us to let you know how we respond to web browser DNT signals.
Because we cannot guarantee to recognise and houour all DNT signals, we do not respond to them at this time.

## 10. Do residents in certain jurisdiction have specific privacy rights?

NO.

All men and women are created equal.

We provide the same privacy rights to all individuals, regardless of their location.

Be assured that we will treat you with the same respect and dignity as we would want to be treated.

## 11. How can you review, update, or delete the data we collect from you?

It is very unlikely that you will be able to review, update, or delete the data we collect from you as we do not collect any identifiable personal data from you, and we will not be able to identify which data belongs to you.

## 12. Do we make updates to this notice?

!!! tip "In Short"

    Yes, we will update this notice as necessary to stay compliant with relevant laws.

We may update this privacy notice from time to time.
The updated version will be indicated by an updated 'Last Revised Date' at the top of this privacy notice.
If we make any material changes, we will notify you by posting the new privacy notice on this page.
We are unable to notify you directly as we do not collect any contact information from you.
We encourage you to review this privacy notice frequently to stay informed of how we are protecting your information.
