### 1D FES

# sigma for KDE           
sigma1=0.04580471404269052
sigma2=0.02571518152324776     
sigma3=0.005566211035181452
sigma4=0.01343144893811585
#sigma5=0.153255918044041
#sigma6=0.06403330139706526

# CV name
cv1=tica0
cv2=tica1
cv3=e2e
cv4=alpha
#cv5=e2e
#cv6=hbond

# Temperature
temp=310   

# For specific CVs, only evaluate error bars of free energy below BARRIER
#max1=2.388264
#max2=1.059054
#min1=-0.879370
#min2=-0.962466

# COLVAR file suffix
k=1
# FES printing stride := n_sim * intended_stride
stride=320000000000                     # Set this to very large to obtain final FES only

##### NB: For Multiple Walkers trajectories we use sorted COLVAR file

# block analysis  
for i in 2 5 10 25 50 100 200 400 600 800 1000
do
    python3 FES_from_Reweighting.py --colvar COLVAR_$k --outfile fes-$j.dat --sigma $sigma1 --temp $temp --cv $cv1 --block $i #--max $max1 --min $min1
    rm fes*
   python3 FES_from_Reweighting.py --colvar COLVAR_$k --outfile fes-$j.dat --sigma $sigma2 --temp $temp --cv $cv2 --block $i #--max $max2 --min $min2
    rm fes*
    python3 FES_from_Reweighting.py --colvar COLVAR_$k --outfile fes-$j.dat --sigma $sigma3 --temp $temp --cv $cv3 --block $i
    rm fes*
    python3 FES_from_Reweighting.py --colvar COLVAR_$k --outfile fes-$j.dat --sigma $sigma4 --temp $temp --cv $cv4 --block $i
    rm fes*
    #python3 FES_from_Reweighting.py --colvar COLVAR_$k --outfile fes-$j.dat --sigma $sigma5 --temp $temp --cv $cv5 --block $i
    #rm fes*
    #python3 FES_from_Reweighting.py --colvar COLVAR_$k --outfile fes-$j.dat --sigma $sigma6 --temp $temp --cv $cv6 --block $i
    #rm fes*
done

mkdir ${k}_error
mv err* ${k}_error

mv log$cv1 log${cv1}_${k}
mv log$cv2 log${cv2}_${k}
mv log$cv3 log${cv3}_${k}
mv log$cv4 log${cv4}_${k}
#mv log$cv5 log${cv5}_${k}
#mv log$cv6 log${cv6}_${k}

# Print FES

#python3 FES_from_Reweighting.py --colvar COLVAR_${k} --outfile fes-$cv1.dat --sigma $sigma1 --temp $temp --cv $cv1 --stride $stride #--max $max1 --min $min1
#python3 FES_from_Reweighting.py --colvar COLVAR_${k} --outfile fes-$cv2.dat --sigma $sigma2 --temp $temp --cv $cv2 --stride $stride #--max $max2 --min $min2
#python3 FES_from_Reweighting.py --colvar COLVAR_${k} --outfile fes-$cv3.dat --sigma $sigma3 --temp $temp --cv $cv3 --stride $stride 
#python3 FES_from_Reweighting.py --colvar COLVAR_${k} --outfile fes-$cv4.dat --sigma $sigma4 --temp $temp --cv $cv4 --stride $stride
#python3 FES_from_Reweighting.py --colvar COLVAR_${k} --outfile fes-$cv5.dat --sigma $sigma5 --temp $temp --cv $cv5 --stride $stride
#python3 FES_from_Reweighting.py --colvar COLVAR_${k} --outfile fes-$cv6.dat --sigma $sigma6 --temp $temp --cv $cv6 --stride $stride

#python3 FES_from_Reweighting.py --colvar COLVAR_${k} --outfile fes-$cv3.dat --sigma $sigma3 --temp $temp --cv $cv3 --stride $stride 
#python3 FES_from_Reweighting.py --colvar COLVAR_${k} --outfile fes-$cv4.dat --sigma $sigma4 --temp $temp --cv $cv4 --stride $stride

#mkdir hist-fes$k
#mv fes* hist-fes$k/


