library(lme4)
library(lmerTest)
library(nlme)
library(car)
library(MuMIn)

pure_deprecation = read.csv("../inactive_task/deprecation_dataset/downstreams_deprecated_bros.csv")


pure_deprecation$repo <- sapply(strsplit(pure_deprecation$repo_name, "/"),'[',1)

pure_deprecation[is.na(pure_deprecation)] <- 0
pure_deprecation$deprecation_flag = as.logical(pure_deprecation$deprecation)
                                                                                  pure_deprecation$readme_or_issues==3)   

head(pure_deprecation)

# Model I
downstream.model <- lmer(
                        delta_of_downstream ~
                        deprecation_flag +
                        log(stars+1) +
                        log(last_commit_to_now+1)+
                        log(mixed_downstream+1)+
                        log(contributor_amount+1) +
                        log(release_amount+1) + 
                        log(age+1) +
                        (1|repo),
                        data = pure_deprecation,
                        REML = FALSE
                        )

vif(downstream.model)

summary(downstream.model)
r.squaredGLMM(downstream.model)

