# Artifact
This artifact includes the source code and data needed to reproduce the results of our paper.
## Files 
- `inactive_task`: This folder contains the dataset we collected, including:
    - A list of all packages in PyPI as of 2023.1.9 in `all_package.json`
    - A list of halted packages in `halted_packages.pkl`
    - A list of packages that haven't received any commit for a long time in `long_time_no_commit.json`
    - A list of inactive packages and their corresponding GitHub repositories in `inactive_pkg_repo_list.json`
    - A mapping of packages to their corresponding GitHub links in `pgk2url.json`
    - A dataset with details in `deprecation_dataset/`, which includes rationales, alternative solutions, and package characteristics (RQ1). Click [here](inactive_task/deprecation_dataset/README.md) for more details.
- `ghd_dataset`: This folder contains the dependency information for PyPI, which we used to build the dependency network. Please unzip the file before use. 
- `down_deps`: The folder contains scripts to process our data, including
    - `similar_brothers`: A script to find similar brother packages of deprecated packages.
    - `delta_of_downdeps.py`: A script that calculates the gain of downstream dependencies.
- `regression`: This folder contains scripts for the models that estimate the effect of deprecation announcements, which can be used to reproduce the results of RQ2.
- `questionnaire_data`: The folder includes the questionnaire prototype and responses (RQ3, 4). Click [here](./questionnaire_data/README.md) for more details.
