include "../../ext/cdefs.pxi"
include "../../libs/ntl/decl.pxi"

import sage.structure.element
cimport sage.structure.element
from sage.rings.integer cimport Integer
from sage.rings.polynomial.polynomial_element cimport Polynomial
from sage.structure.element cimport FieldElement, RingElement, ModuleElement
from sage.structure.parent_base cimport ParentWithBase
from sage.libs.ntl.ntl_ZZX cimport ntl_ZZX
from sage.libs.ntl.ntl_ZZ cimport ntl_ZZ

cdef class NumberFieldElement(FieldElement):
    cdef ZZX_c __numerator
    cdef ZZ_c __denominator
    # Pointers to the defining polynomial (with numerator) for the field.
    # I keep these as pointers for arithmetic speed.
    cdef ntl_ZZX __fld_numerator
    cdef ntl_ZZ __fld_denominator
    cdef object __multiplicative_order
    cdef object __pari
    cdef object __matrix

    cdef _new(self)

    cdef number_field(self)

    cdef void _ntl_coeff_as_mpz(self, mpz_t* z, long i)
    cdef void _ntl_denom_as_mpz(self, mpz_t* z)

    # _parent_poly_c_ is deprecated -- refer to doc-string
    cdef void _parent_poly_c_(self, ZZX_c *num, ZZ_c *den)
    cdef void _invert_c_(self, ZZX_c *num, ZZ_c *den)
    cdef void _reduce_c_(self)
    cdef ModuleElement _add_c_impl(self, ModuleElement right)
    cdef ModuleElement _sub_c_impl(self, ModuleElement right)
    cdef ModuleElement _neg_c_impl(self)

    cdef bint is_rational_c(self)


cdef class NumberFieldElement_absolute(NumberFieldElement):
    pass

cdef class NumberFieldElement_relative(NumberFieldElement):
    pass

# TODO: cyclotomic and/or quadratic classes? (Both for differing implementations and speed).

cdef class OrderElement_absolute(NumberFieldElement_absolute):
    cdef object _number_field

cdef class OrderElement_relative(NumberFieldElement_relative):
    cdef object _number_field
