from sqlalchemy import *

metadata = MetaData()

clients =  Table('clients', metadata,
    Column('id', Integer, primary_key=True),
    Column('username', String(20), unique=True),
    Column('public_key', Text),
    Column('creation_time', DateTime),
    Column('access_time', DateTime),
    Column('last_login', DateTime),
    Column('connected', Boolean),
    Column('enabled', Boolean, default=True),
)

workers =  Table('workers', metadata,
    Column('id', Integer, primary_key=True),
    Column('uuid', String(36), unique=True, nullable=False),
    Column('hostname', Text),
    Column('ip', Text),
    Column('workers', Integer, default=0),
    Column('sage_version', Text),
    Column('os', Text),
    Column('kernel_version', Text),
    Column('cpus', Integer),
    Column('cpu_speed', Integer),
    Column('cpu_model', Text),
    Column('mem_total', Integer),
    Column('mem_free', Integer),
    Column('connected', Boolean, default=False),
    Column('busy', Boolean, default=False),
    Column('anonymous', Boolean, default=False),
    Column('last_connection', DateTime),
    Column('username', Text),
    Column('authenticated', Boolean, default=False),
)

jobs = Table('jobs', metadata,
    Column('id', Integer, primary_key=True),
    Column('job_id', String(10), unique=True),
    Column('name', Text, default='Unamed'),
    Column('username', String(20), ForeignKey('clients.username')),
    Column('uuid', String(36), ForeignKey('workers.uuid')),
    Column('code', Text),
    Column('data', PickleType),
    Column('output', Text),
    Column('result', PickleType),
    Column('status', Text),
    Column('priority', Integer, default=5),
    Column('type', Text),
    Column('failures', Integer, default=0),
    Column('creation_time', DateTime()),
    Column('update_time', DateTime),
    Column('start_time', DateTime),
    Column('finish_time', DateTime),
    Column('cpu_time', Float),
    Column('wall_time', Interval),
    Column('verifiable', Boolean, default=False),
    Column('private', Boolean, default=False),
    Column('timeout', Integer, default=600),
    Column('killed', Boolean, default=False),
    Column('authenticated', Boolean),
)