from sage.structure.element cimport Element
from morphism cimport Morphism
from functor cimport Functor

cdef class Action(Functor):
    cdef G
    cdef S
    cdef bint _is_left
    cdef op
    cdef Element _call_c(self, a, b)
    cdef Element _call_c_impl(self, Element a, Element b)


cdef class InverseAction(Action):
    cdef Action _action
    cdef Morphism S_precomposition

cdef class PrecomposedAction(Action):
    cdef Action _action
    cdef Morphism left_precomposition
    cdef Morphism right_precomposition

cdef class ActionEndomorphism(Morphism):
    cdef Action _action
    cdef Element _g