/**
 * @file stdsage.c
 *
 * Some global C stuff that gets imported into pyrex modules.
 *
 */

/******************************************************************************
       Copyright (C) 2006 William Stein <wstein@gmail.com>
                     2006 David Harvey <dmharvey@math.harvard.edu>
                     2006 Martin Albrecht <malb@informatik.uni-bremen.de>

  Distributed under the terms of the GNU General Public License (GPL), Version 2.

  The full text of the GPL is available at:
                  http://www.gnu.org/licenses/

******************************************************************************/


#include "stdsage.h"
#include "interrupt.h"

PyObject* global_empty_tuple;

void init_global_empty_tuple(void) {
  _CALLED_ONLY_ONCE;

  global_empty_tuple = PyTuple_New(0);
}


/*
  This function gets called whenever NTL calls Error().
  s is the error message generated by NTL.
  We just copy the error message into a global buffer, and then abort() to run
  the usual interrupt machinery.
 */
void global_NTL_error_callback(const char* s, void* context)
{
   set_sage_signal_handler_message(s);
   abort();
}


void init_csage(void) {
  //_CALLED_ONLY_ONCE;

  init_global_empty_tuple();
  setup_signal_handler();
  setup_NTL_error_callback(global_NTL_error_callback, NULL);
}
