////////////////////////////////////////////////////////////////////////////////
//
// Measure the time like using a stop watch
//
// Burkhard Militzer                                     Livermore, 5-10-01
//       
////////////////////////////////////////////////////////////////////////////////

#include <unistd.h> 
#include <sys/times.h>
#include <math.h>

#include <iomanip>
using namespace std;

#include "Standard.h"
#include "Timer.h"

long Timer::GetHertz() const {
  return sysconf (_SC_CLK_TCK) ;
}

ostream& operator<<(ostream &os, Timer & t ) {
  if (t.m!=Timer::off) {
    int p=int(log10( (double)(t.GetHertz()) ))+1;
    double tt= max(0.0,t.Read());
    const ios::fmtflags current = os.flags();
    const streamsize ss = os.precision();
    os.precision(p);
    os.setf(ios::fixed,ios::floatfield);
    os << tt;
    os.setf(current);
    os.precision(ss);
  }
  return os;
}
