////////////////////////////////////////////////////////////////////////////////
//                                                                            //
// Standard definitions and functions that are used almost everywhere         //
//                                                                            //
// Burkhard Militzer                                        Urbana 4-9-99     //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

#ifndef _STANDARD_
#define _STANDARD_

#include <iostream>
#include <fstream>
#include <sstream>
#include <string>
#include <cstdlib>
using namespace std;

/////////////////////////////////////////////////////////////////////////////////

// Define RANGE_CHECKING for testing
#define RANGE_CHECKING

//For SLOW testing, define STANDARD_DEBUG
// #define STANDARD_DEBUG

///////////////////////// redefine cout to write to a file /////////////////////
// #ifndef NO_COUT
// #define cout COUT
// extern ofstream COUT;
// #endif // NO_COUT

////////////////////////////////////////////////////////////////////////////////

#include <math.h>

#ifndef pi
const double pi=3.1415926535897932385;
#endif

/*
inline double abs(double x) {  
   return fabs(x);  
} 
*/

inline double sign(double x) {
  return (x>0.0) ? 1.0 : ((x<0.0) ? -1.0 : 0.0);
}

inline int sign(int x) {
  return (x>0) ? 1 : ((x<0) ? -1 : 0);
}

inline double nint(const double x) {
  return int(x+0.5*sign(x));
}

inline double min(double x, double y) {
  return (x<=y) ? x : y;
}

inline double min(double x, double y, double z) {
  double m = min(x,y);
  return min(m,z);
}

inline double min(double w, double x, double y, double z) {
  double m = min(w,x);
  m = min(y,m);
  return min(m,z);
}

inline int min(int x, int y) {
  return (x<=y) ? x : y;
}

inline double max(double x, double y) {
  return (x>=y) ? x : y;
}

inline double max(double x, double y, double z) {
  double m = max(x,y);
  return max(m,z);
}

inline double max(double w, double x, double y, double z) {
  double m = max(w,x);
  m = max(m,y);
  return max(m,z);
}

inline int max(int x, int y) {
  return (x>=y) ? x : y;
}

inline double sqr(double x) {
  return (x*x);
}

inline int sqr(int x) {
  return (x*x);
}

inline double cube(double x) {
  return (x*x*x);
}

inline int cube(int x) {
  return (x*x*x);
}

template <class T> 
inline void Swap(T & a, T & b) {
  T c = a;
  a = b;
  b = c;
}

/*
inline double pow10(double x) {
  return pow(10.0,x);
}
*/

////////////////////////////////////////////////////////////////////////////////

// Write name of the variable and its value
#define write1(i)                    {cout << " "#i"= " << i; }
#define write2(i,j)                  {write1(i); write1(j);}
#define write3(i,j,k)                {write2(i,j); write1(k); }
#define write4(i,j,k,l)              {write3(i,j,k); write1(l); }
#define write5(i,j,k,l,m)            {write4(i,j,k,l); write1(m); }
#define write6(i,j,k,l,m,n)          {write5(i,j,k,l,m); write1(n); }
#define write7(i,j,k,l,m,n,o)        {write6(i,j,k,l,m,n); write1(o); }
#define write8(i,j,k,l,m,n,o,p)      {write7(i,j,k,l,m,n,o); write1(p); }
#define write9(i,j,k,l,m,n,o,p,q)    {write8(i,j,k,l,m,n,o,p); write1(q); }
#define write10(i,j,k,l,m,n,o,p,q,r) {write9(i,j,k,l,m,n,o,p,q); write1(r); }
#define write11(i,j,k,l,m,n,o,p,q,r,s) {write10(i,j,k,l,m,n,o,p,q,r); write1(s); }
#define write12(i,j,k,l,m,n,o,p,q,r,s,t) {write11(i,j,k,l,m,n,o,p,q,r,s); write1(t); }
#define write13(i,j,k,l,m,n,o,p,q,r,s,t,u) {write12(i,j,k,l,m,n,o,p,q,r,s,t); write1(u); }
#define write14(i,j,k,l,m,n,o,p,q,r,s,t,u,v) {write13(i,j,k,l,m,n,o,p,q,r,s,t,u); write1(v); }
#define write15(i,j,k,l,m,n,o,p,q,r,s,t,u,v,w) {write14(i,j,k,l,m,n,o,p,q,r,s,t,u,v); write1(w); }
#define write16(i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x) {write15(i,j,k,l,m,n,o,p,q,r,s,t,u,v,w); write1(x); }
#define write17(i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y) {write16(i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x); write1(y); }
#define write18(i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z) {write17(i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y); write1(z); }

#define Write(i)                     {write1(i); cout << endl;}
#define Write2(i,j)                  {write2(i,j); cout << endl;}
#define Write3(i,j,k)                {write3(i,j,k); cout << endl;}
#define Write4(i,j,k,l)              {write4(i,j,k,l); cout << endl;}
#define Write5(i,j,k,l,m)            {write5(i,j,k,l,m); cout << endl;}
#define Write6(i,j,k,l,m,n)          {write6(i,j,k,l,m,n); cout << endl;}
#define Write7(i,j,k,l,m,n,o)        {write7(i,j,k,l,m,n,o); cout << endl;}
#define Write8(i,j,k,l,m,n,o,p)      {write8(i,j,k,l,m,n,o,p); cout << endl;}
#define Write9(i,j,k,l,m,n,o,p,q)    {write9(i,j,k,l,m,n,o,p,q); cout << endl;}
#define Write10(i,j,k,l,m,n,o,p,q,r) {write10(i,j,k,l,m,n,o,p,q,r); cout << endl;}
#define Write11(i,j,k,l,m,n,o,p,q,r,s) {write11(i,j,k,l,m,n,o,p,q,r,s); cout << endl;}
#define Write12(i,j,k,l,m,n,o,p,q,r,s,t) {write12(i,j,k,l,m,n,o,p,q,r,s,t); cout << endl;}
#define Write13(i,j,k,l,m,n,o,p,q,r,s,t,u) {write13(i,j,k,l,m,n,o,p,q,r,s,t,u); cout << endl;}
#define Write14(i,j,k,l,m,n,o,p,q,r,s,t,u,v) {write14(i,j,k,l,m,n,o,p,q,r,s,t,u,v); cout << endl;}
#define Write15(i,j,k,l,m,n,o,p,q,r,s,t,u,v,w) {write15(i,j,k,l,m,n,o,p,q,r,s,t,u,v,w); cout << endl;}
#define Write16(i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x) {write16(i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x); cout << endl;}
#define Write17(i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y) {write17(i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,z); cout << endl;}
#define Write18(i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z) {write18(i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z); cout << endl;}

void Terminate();

inline void Quit(const string s="") {
  cout << endl;
  cout << "Quitting the program early" 
       << ((s.length()>0) ? ": " : ".") << s << endl;
  cout << endl;
  Terminate();
}

inline void WriteError(ostringstream & ss) {
  const string errorString = "Error   ";
  //  ss << ends;
  // cout is redirect into a file which might not yet be opened
  if (cout) {
    cout.precision(16);
    cout << errorString << ss.str() << endl;
  }
  cerr.precision(16);
  cerr << errorString << ss.str() << endl;
  Terminate();
}

inline void error(){
  ostringstream ss;
  ss << " - Program exited by calling error() function.";
  WriteError(ss);
}

inline void error(const string & m){
  ostringstream ss;
  ss << m;
  WriteError(ss);
}

template<class T> inline
void error(const string & m, const T& n){
  ostringstream ss;
  ss << m << " " << n;
  WriteError(ss);
}

template<class T, class U> inline
void error(const string & m, const T& t, const U& u){
  ostringstream ss;
  ss << m << " " << t << " " << u;
  WriteError(ss);
}

template<class T, class U, class V> inline
void error(const string & m, const T& t, const U& u, const V& v){
  ostringstream ss;
  ss << m << " " << t << " " << u << " " << v;
  WriteError(ss);
}

template<class T, class U, class V, class W> inline
void error(const string & m, const T& t, const U& u, const V& v, const W& w){
  ostringstream ss;
  ss << m << " " << t << " " << u << " " << v << " " << w;
  WriteError(ss);
}

template<class T, class U, class V, class W, class X> inline
void error(const string & m, const T& t, const U& u, const V& v, const W& w, const X& x){
  ostringstream ss;
  ss << m << " " << t << " " << u << " " << v << " " << w << " " << x;
  WriteError(ss);
}

template<class T, class U, class V, class W, class X, class Y> inline
void error(const string & m, const T& t, const U& u, const V& v, const W& w, const X& x, const Y& y){
  ostringstream ss;
  ss << m << " " << t << " " << u << " " << v << " " << w << " " << x << " " << y;
  WriteError(ss);
}

template<class T, class U, class V, class W, class X, class Y, class Z> inline
void error(const string & m, const T& t, const U& u, const V& v, const W& w, const X& x, const Y& y, const Z& z){
  ostringstream ss;
  ss << m << " " << t << " " << u << " " << v << " " << w << " " << x << " " << y << " " << z;
  WriteError(ss);
}

template<class T, class U, class V, class W, class X, class Y, class Z, class Z1> inline
void error(const string & m, const T& t, const U& u, const V& v, const W& w, const X& x, const Y& y, const Z& z, const Z1& z1){
  ostringstream ss;
  ss << m << " " << t << " " << u << " " << v << " " << w << " " << x << " " << y << " " << z << " " << z1;
  WriteError(ss);
}

template<class T, class U, class V, class W, class X, class Y, class Z, class Z1, class Z2> inline
void error(const string & m, const T& t, const U& u, const V& v, const W& w, const X& x, const Y& y, const Z& z, const Z1& z1, const Z2& z2){
  ostringstream ss;
  ss << m << " " << t << " " << u << " " << v << " " << w << " " << x << " " << y << " " << z << " " << z1 << " " << z2;
  WriteError(ss);
}

inline void WriteWarning(ostringstream & ss) {
  const string warningString = "WARNING   ";
  //  ss << ends;
#ifndef NO_COUT
  cout << warningString << ss.str() << endl;
#endif
  cerr << warningString << ss.str() << endl;
}

inline void warning() {
  ostringstream ss;
  ss << "...";
  WriteWarning(ss);
}

inline void warning(const string & m){
  ostringstream ss;
  ss << m;
  WriteWarning(ss);
}

template<class T> inline
void warning(const string & m, const T& t){
  ostringstream ss;
  ss << m << " " << t;
  WriteWarning(ss);
}

template<class T, class U> inline
void warning(const string & m, const T& t, const U& u){
  ostringstream ss;
  ss << m << " " << t << " " << u;
  WriteWarning(ss);
}

template<class T, class U, class V> inline
void warning(const string & m, const T& t, const U& u, const V& v){
  ostringstream ss;
  ss << m << " " << t << " " << u << " " << v;
  WriteWarning(ss);
}

template<class T, class U, class V, class W> inline
void warning(const string & m, const T& t, const U& u, const V& v, const W& w){
  ostringstream ss;
  ss << m << " " << t << " " << u << " " << v << " " << w;
  WriteWarning(ss);
}

template<class T, class U, class V, class W, class X> inline
void warning(const string & m, const T& t, const U& u, const V& v, const W& w, const X& x){
  ostringstream ss;
  ss << m << " " << t << " " << u << " " << v << " " << w << " " << x;
  WriteWarning(ss);
}

template<class T, class U, class V, class W, class X, class Y> inline
void warning(const string & m, const T& t, const U& u, const V& v, const W& w, const X& x, const Y& y){
  ostringstream ss;
  ss << m << " " << t << " " << u << " " << v << " " << w << " " << x << " " << y;
  WriteWarning(ss);
}

template<class T, class U, class V, class W, class X, class Y, class Z> inline
void warning(const string & m, const T& t, const U& u, const V& v, const W& w, const X& x, const Y& y, const Z& z){
  ostringstream ss;
  ss << m << " " << t << " " << u << " " << v << " " << w << " " << x << " " << y << " " << z;
  WriteWarning(ss);
}

///////////////////////// Functions for array bound checking ///////////////////

// Limits is an inline function that checks indices 
// ok is 0<= n < max
inline void Limits(const int n, const int max) {
#ifdef RANGE_CHECKING
  if ((n<0) || (n>=max)) {
    error("Array Index out of range ",n,max);
    cerr << "Array error: Index out of range:  0<= " 
	 << n << " < " << max << "\n" ;
    Terminate();
  }
#endif // RANGE_CHECKING
}

// Limits is an inline function that checks indices 
// ok is 0<= n <= max
inline void LimitsInclusive(const int n, const int max) {
#ifdef RANGE_CHECKING
  if ((n<0) || (n>max)) {
    //    error("Array Error: Index out of range ",n,max);
    cerr << "Array error: Upper limit for index out of range:  0<= " 
	 << n << " <= " << max << "\n" ;
    Terminate();
  }
#endif // RANGE_CHECKING
}

inline void EqualLimits(const int max1, const int max2) {
#ifdef RANGE_CHECKING
  if (max1!=max2) {
    cerr << "Array copy error: array sizes not equal:" 
	 << max1 << "," << max2 << endl;
    Terminate();
  }
#endif // RANGE_CHECKING
}

inline void BiggerLimit(const int lower, const int upper) {
#ifdef RANGE_CHECKING
  if (lower>=upper) {
    cerr << "Sub-array limits error: lower limit not lower " 
	 << lower << "," << upper << endl;
    Terminate();
  }
#endif // RANGE_CHECKING
}

////////////////////////////////////////////////////////////////////////////////

// Does this need "ss << ends" ???
inline string IntToString(const int i) {
  ostringstream ss;
  ss << i;
  return ss.str();
}

// default filler character is 0 for file name
// for printing to screen or into files, a space would be better
inline string IntToString(const int i, const int d, const char c = '0') {
  ostringstream ss;
  ss << i;
  string s;
  for(int j=0; j<d-int(ss.str().length()); j++) 
    s+=c;
  return s+ss.str();
}

inline string DoubleToString(const double d) {
  ostringstream ss;
  ss << d;
  return ss.str();
}

inline bool IsInt(const string & s) {
  const string intChars(" +-0123456789");
  string::size_type j=s.find_first_not_of(intChars);
  return (j == string::npos);
}

inline int StringToInt(const string & s) {
  if (!IsInt(s))
    error("Parser: Not an integer ",s);
 
  istringstream ss(s);
  int value;
  ss >> value;
  return value;
}

inline bool IsDouble(const string & s) {
  const string doubleChars(" +-0123456789.edDE");
  string::size_type j=s.find_first_not_of(doubleChars);
  return (j == string::npos);
}

inline double StringToDouble(const string & s) {
  if (!IsDouble(s))
    error("Parser: Not a double ",s);
  
  istringstream ss(s);
  double value;
  ss >> value;
  return value;
}

inline string UpperCase(const string & s) {
  string sl;
  for(string::const_iterator p=s.begin();p!=s.end();++p) {
    sl += toupper(*p);
  }
  return sl;
}
 
inline string LowerCase(const string & s) {
  string sl;
  for(string::const_iterator p=s.begin();p!=s.end();++p) {
    sl += tolower(*p);
  }
  return sl;
}

inline string Spaces(const int n, const char c=' ') {
  string s;
  for(int i=0; i<n; i++) {
    s += c;
  }
  return s;
}

inline int DigitsInt(const int i) { 
  return int(ceil(log10(double(i+1)))); 
}
inline string IntToStringMaxNumber(const int i, const int maxNumber, const char c = '0') {
  return IntToString(i,DigitsInt(maxNumber),c);
}

inline bool IsNumber(const string & s) {
  return IsInt(s) || IsDouble(s);
}
inline bool IsNotNumber(const string & s) {
  return !(IsNumber(s));
}

inline string FillLine(const string & l, const char c, const int n) {
  string line(l);
  line.append(n-line.length(),c);
  return line;
}

#ifdef __PGI // PG compiler bug
inline bool getline(istream & is, string & s) {
  s="";
  char c;
  while(is.get(c)) {
    if (c=='\n') return true;
    s += c;
  }
  return false;
}
inline bool getline(ifstream & is, string & s) {
  s="";
  char c;
  while(is.get(c)) {
    if (c=='\n') return true;
    s += c;
  }
  return false;
}
#endif

inline bool FileExists(const string & fn) {
  ifstream ifs(fn.c_str());
  return (ifs.is_open()==true);
}

#endif // _STANDARD_
