/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// Read text files                                                         // 
//                                                                         //
// Burkhard Militzer                                  Livermore 4-27-01    //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef _READINTABLE_
#define _READINTABLE_

#include "Parser.h"
#include "Array.h"


void ReadInTable(const string & fileName, 
		 const string & keyword,  // May be empty. Then all lines are read in.
		 const int kPos,          // May be -1. Then the keyward can be in any colum
		 const Array1<int> & nPos,
		 const int nVar,
		 int & n,
		 Array1 <Array1 <double> *> & x, 
		 const bool print=true);

void ReadInTable(const string & fileName,
		 const string & keyword,  // May be empty. Then all lines are read in.
		 const int kPos,          // May be -1. Then the keyward can be in any colum
		 const int ny,
		 int & n,
		 Array1 <double> & x,
		 const bool print=true);

void ReadInTable(const string & fileName,
		 const string & keyword,  // May be empty. Then all lines are read in.
		 const int kPos,          // May be -1. Then the keyward can be in any colum
		 const int nx,
		 const int ny,
		 int & n,
		 Array1 <double> & x,
		 Array1 <double> & y, 
		 const bool print=true);

void ReadInTable(const string & fileName,
		 const string & keyword,  // May be empty. Then all lines are read in.
		 const int kPos,          // May be -1. Then the keyward can be in any colum
		 const int nx,
		 const int ny,
		 const int nz,
		 int & n,
		 Array1 <double> & x,
		 Array1 <double> & y,
		 Array1 <double> & z, 
		 const bool print=true);

void ReadInTable(const string & fileName,
		 const string & keyword,  // May be empty. Then all lines are read in.
		 const int kPos,          // May be -1. Then the keyward can be in any colum
		 const int n1,
		 const int n2,
		 const int n3,
		 const int n4,
		 int & n,
		 Array1 <double> & x1,
		 Array1 <double> & x2,
		 Array1 <double> & x3, 
		 Array1 <double> & x4, 
		 const bool print=true);

void ReadInTable(const string & fileName,
		 const string & keyword,  // May be empty. Then all lines are read in.
		 const int kPos,          // May be -1. Then the keyward can be in any colum
		 const int n1,
		 const int n2,
		 const int n3,
		 const int n4,
		 const int n5,
		 int & n,
		 Array1 <double> & x1,
		 Array1 <double> & x2,
		 Array1 <double> & x3, 
		 Array1 <double> & x4,
		 Array1 <double> & x5, 
		 const bool print=true);

void ReadInTable(const string & fileName,
		 const string & keyword,  // May be empty. Then all lines are read in.
		 const int kPos,          // May be -1. Then the keyward can be in any colum
		 const int n1,
		 const int n2,
		 const int n3,
		 const int n4,
		 const int n5,
		 const int n6,
		 int & n,
		 Array1 <double> & x1,
		 Array1 <double> & x2,
		 Array1 <double> & x3, 
		 Array1 <double> & x4,
		 Array1 <double> & x5,
		 Array1 <double> & x6, 
		 const bool print=true);

void ReadInTable(const string & fileName,
		 const string & keyword,  // May be empty. Then all lines are read in.
		 const int kPos,          // May be -1. Then the keyward can be in any colum
		 const int n1,
		 const int n2,
		 const int n3,
		 const int n4,
		 const int n5,
		 const int n6,
		 const int n7,
		 int & n,
		 Array1 <double> & x1,
		 Array1 <double> & x2,
		 Array1 <double> & x3, 
		 Array1 <double> & x4,
		 Array1 <double> & x5,
		 Array1 <double> & x6,
		 Array1 <double> & x7, 
		 const bool print=true);

void ReadInTable(const string & fileName,
		 const string & keyword,  // May be empty. Then all lines are read in.
		 const int kPos,          // May be -1. Then the keyward can be in any colum
		 const int n1,
		 const int n2,
		 const int n3,
		 const int n4,
		 const int n5,
		 const int n6,
		 const int n7,
		 const int n8,
		 int & n,
		 Array1 <double> & x1,
		 Array1 <double> & x2,
		 Array1 <double> & x3, 
		 Array1 <double> & x4,
		 Array1 <double> & x5,
		 Array1 <double> & x6,
		 Array1 <double> & x7,
		 Array1 <double> & x8, 
		 const bool print=true);

void ReadInTable(const string & fileName,
		 const string & keyword,  // May be empty. Then all lines are read in.
		 const int kPos,          // May be -1. Then the keyward can be in any colum
		 const int n1,
		 const int n2,
		 const int n3,
		 const int n4,
		 const int n5,
		 const int n6,
		 const int n7,
		 const int n8,
		 const int n9,
		 int & n,
		 Array1 <double> & x1,
		 Array1 <double> & x2,
		 Array1 <double> & x3, 
		 Array1 <double> & x4,
		 Array1 <double> & x5,
		 Array1 <double> & x6,
		 Array1 <double> & x7,
		 Array1 <double> & x8,
		 Array1 <double> & x9, 
		 const bool print=true);

void ReadInTable(const string & fileName,
		 const string & keyword,  // May be empty. Then all lines are read in.
		 const int kPos,          // May be -1. Then the keyward can be in any colum
		 const int n1,
		 const int n2,
		 const int n3,
		 const int n4,
		 const int n5,
		 const int n6,
		 const int n7,
		 const int n8,
		 const int n9,
		 const int n10,
		 int & n,
		 Array1 <double> & x1,
		 Array1 <double> & x2,
		 Array1 <double> & x3, 
		 Array1 <double> & x4,
		 Array1 <double> & x5,
		 Array1 <double> & x6,
		 Array1 <double> & x7,
		 Array1 <double> & x8,
		 Array1 <double> & x9,
		 Array1 <double> & x10, 
		 const bool print=true);

void ReadInTable(const string & fileName,
		 const string & keyword,  // May be empty. Then all lines are read in.
		 const int kPos,          // May be -1. Then the keyward can be in any colum
		 const int n1,
		 const int n2,
		 const int n3,
		 const int n4,
		 const int n5,
		 const int n6,
		 const int n7,
		 const int n8,
		 const int n9,
		 const int n10,
		 const int n11,
		 int & n,
		 Array1 <double> & x1,
		 Array1 <double> & x2,
		 Array1 <double> & x3, 
		 Array1 <double> & x4,
		 Array1 <double> & x5,
		 Array1 <double> & x6,
		 Array1 <double> & x7,
		 Array1 <double> & x8,
		 Array1 <double> & x9,
		 Array1 <double> & x10,
		 Array1 <double> & x11, 
		 const bool print=true);

////////////////////////////////////////////////////////////////////////////////////////////////////

inline void ReadInTable(const string & fileName,
			const int nx,
			int & n,
			Array1 <double> & x,
			const bool print=true) {
  ReadInTable(fileName,"",-1,nx,n,x,print);
}

inline void ReadInTable(const string & fileName,
			const int nx,
			const int ny,
			int & n,
			Array1 <double> & x,
			Array1 <double> & y, 
			const bool print=true) {
  ReadInTable(fileName,"",-1,nx,ny,n,x,y,print);
}

inline void ReadInTable(const string & fileName,
			const int nx,
			const int ny,
			const int nz,
			int & n,
			Array1 <double> & x,
			Array1 <double> & y,
			Array1 <double> & z, 
			const bool print=true) {
  ReadInTable(fileName,"",-1,nx,ny,nz,n,x,y,z,print);
}

inline void ReadInTable(const string & fileName,
			const int n1,
			const int n2,
			const int n3,
			const int n4,
			int & n,
			Array1 <double> & x1,
			Array1 <double> & x2,
			Array1 <double> & x3, 
			Array1 <double> & x4, 
			const bool print=true) {
  ReadInTable(fileName,"",-1,n1,n2,n3,n4,n,x1,x2,x3,x4,print);
}


inline void ReadInTable(const string & fileName,
			const int n1,
			const int n2,
			const int n3,
			const int n4,
			const int n5,
			int & n,
			Array1 <double> & x1,
			Array1 <double> & x2,
			Array1 <double> & x3, 
			Array1 <double> & x4,
			Array1 <double> & x5, 
			const bool print=true) {
  ReadInTable(fileName,"",-1,n1,n2,n3,n4,n5,n,x1,x2,x3,x4,x5,print);
}


inline void ReadInTable(const string & fileName,
			const int n1,
			const int n2,
			const int n3,
			const int n4,
			const int n5,
			const int n6,
			int & n,
			Array1 <double> & x1,
			Array1 <double> & x2,
			Array1 <double> & x3, 
			Array1 <double> & x4,
			Array1 <double> & x5,
			Array1 <double> & x6, 
			const bool print=true) {
  ReadInTable(fileName,"",-1,n1,n2,n3,n4,n5,n6,n,x1,x2,x3,x4,x5,x6,print);
}


inline void ReadInTable(const string & fileName,
			const int n1,
			const int n2,
			const int n3,
			const int n4,
			const int n5,
			const int n6,
			const int n7,
			int & n,
			Array1 <double> & x1,
			Array1 <double> & x2,
			Array1 <double> & x3, 
			Array1 <double> & x4,
			Array1 <double> & x5,
			Array1 <double> & x6,
			Array1 <double> & x7, 
			const bool print=true) {
  ReadInTable(fileName,"",-1,n1,n2,n3,n4,n5,n6,n7,n,x1,x2,x3,x4,x5,x6,x7,print);
}


inline void ReadInTable(const string & fileName,
			const int n1,
			const int n2,
			const int n3,
			const int n4,
			const int n5,
			const int n6,
			const int n7,
			const int n8,
			int & n,
			Array1 <double> & x1,
			Array1 <double> & x2,
			Array1 <double> & x3, 
			Array1 <double> & x4,
			Array1 <double> & x5,
			Array1 <double> & x6,
			Array1 <double> & x7,
			Array1 <double> & x8, 
			const bool print=true) {
  ReadInTable(fileName,"",-1,n1,n2,n3,n4,n5,n6,n7,n8,n,x1,x2,x3,x4,x5,x6,x7,x8,print);
}


inline void ReadInTable(const string & fileName,
			const int n1,
			const int n2,
			const int n3,
			const int n4,
			const int n5,
			const int n6,
			const int n7,
			const int n8,
			const int n9,
			int & n,
			Array1 <double> & x1,
			Array1 <double> & x2,
			Array1 <double> & x3, 
			Array1 <double> & x4,
			Array1 <double> & x5,
			Array1 <double> & x6,
			Array1 <double> & x7,
			Array1 <double> & x8,
			Array1 <double> & x9, 
			const bool print=true) {
  ReadInTable(fileName,"",-1,n1,n2,n3,n4,n5,n6,n7,n8,n9,n,x1,x2,x3,x4,x5,x6,x7,x8,x9,print);
}


inline void ReadInTable(const string & fileName,
			const int n1,
			const int n2,
			const int n3,
			const int n4,
			const int n5,
			const int n6,
			const int n7,
			const int n8,
			const int n9,
			const int n10,
			int & n,
			Array1 <double> & x1,
			Array1 <double> & x2,
			Array1 <double> & x3, 
			Array1 <double> & x4,
			Array1 <double> & x5,
			Array1 <double> & x6,
			Array1 <double> & x7,
			Array1 <double> & x8,
			Array1 <double> & x9,
			Array1 <double> & x10, 
			const bool print=true) {
  ReadInTable(fileName,"",-1,n1,n2,n3,n4,n5,n6,n7,n8,n9,n10,n,x1,x2,x3,x4,x5,x6,x7,x8,x9,x10,print);
}


inline void ReadInTable(const string & fileName,
			const int n1,
			const int n2,
			const int n3,
			const int n4,
			const int n5,
			const int n6,
			const int n7,
			const int n8,
			const int n9,
			const int n10,
			const int n11,
			int & n,
			Array1 <double> & x1,
			Array1 <double> & x2,
			Array1 <double> & x3, 
			Array1 <double> & x4,
			Array1 <double> & x5,
			Array1 <double> & x6,
			Array1 <double> & x7,
			Array1 <double> & x8,
			Array1 <double> & x9,
			Array1 <double> & x10,
			Array1 <double> & x11, 
			const bool print=true) {
  ReadInTable(fileName,"",-1,n1,n2,n3,n4,n5,n6,n7,n8,n9,n10,n11,n,x1,x2,x3,x4,x5,x6,x7,x8,x9,x10,x11,print);
}


int FindInTable(const double x, const Array1 <double> & t);
int FindInReverseTable(const double x, const Array1 <double> & t);

#endif // _READINTABLE_
