/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// Read text files                                                         // 
//                                                                         //
// Burkhard Militzer                                  Livermore 4-27-01    //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#include "ReadInTable.h"

#define NO_WARNINGS

void ReadInTable(const string & fileName, 
		 const string & keyword,  // May be empty. Then all lines are read in.
		 const int kPos,          // May be -1. Then the keyward can be in any colum
		 const Array1<int> & nPos,
		 const int nVar,
		 int & n,
		 Array1 <Array1 <double> *> & x, 
		 const bool print) {
  n = 0;
  int nMax=0;
  for(int i=0; i<nVar; i++) {
    //    if (nPos[i]<0) error("Incorrect column index",i,nPos[i]); // now allow nPos=-1 as a label for nothing to do
    if (nPos[i]>0 && nPos[i]>nMax) nMax=nPos[i];
  }
  if (kPos>nMax) nMax=kPos;
  
  if (print) cout << "Opening file \"" << fileName << "\" to read " << nVar << " columns of floating point values: Columns= "; 
  for(int i=0; i<nVar; i++) {
    if (nPos[i]>0 && print) cout << nPos[i] << " ";
  }
  if (keyword!="") {
    if (print) cout << "keyword= \"" << keyword << "\"";
    if (kPos<0) { 
      if (print) cout << " in any column.";
    } else { 
      if (print) cout << " in column " << kPos << ".";
    }
  }
  if (print) cout << endl;

  ifstream is(fileName.c_str());
  if (!is) 
    error("Cannot open file",fileName);
  Parser p(is);

  while(p.ReadLine()) {

    const int nW=p.GetNWords();
    if (nMax>nW) {
      warning("Input line has too few words",p.GetLineNumber(),nW,nMax,"\""+p.GetLineString()+"\"");
      continue;
    } 

    if (keyword!="") {
      if (kPos<0) {
	if (p.FindInLine(keyword)==false) continue;
      } else {
	if (p.PositionInLine(keyword)!=kPos-1) continue; // Subtract 1 because in ReadInTable, column numbers start with 1. In Parser they start with 0.
      }
    }

    n++;
    //      cout << "Read table: " << n << ":  ";
    for(int i=0; i<nVar; i++) {
      if (nPos[i]>0) {
	double q=p.GetDouble(nPos[i]-1); // Subtract 1 because in ReadInTable, column numbers start with 1. In Parser they start with 0.
	(x[i])->PushBack(q);
      }
      //	cout << "  " << q ;
    }
    //      cout << endl;

  }
  if (print) cout << "Read " << n << " lines from file \"" << fileName << "\"." << endl;
  is.close();
}

void ReadInTable(const string & fileName,
		 const string & keyword,  // May be empty. Then all lines are read in.
		 const int kPos,          // May be -1. Then the keyward can be in any colum
		 const int nx,
		 int & n,
		 Array1 <double> & x,
		 const bool print) {
  const int nn=1;
  Array1 <Array1 <double> *> xx(nn);

  xx[0] = & x;

  Array1 <int> nPos(nn);

  nPos[0] = nx;

  ReadInTable(fileName,keyword,kPos,nPos,nn,n,xx,print);
}

void ReadInTable(const string & fileName,
		 const string & keyword,  // May be empty. Then all lines are read in.
		 const int kPos,          // May be -1. Then the keyward can be in any colum
		 const int nx,
		 const int ny,
		 int & n,
		 Array1 <double> & x,
		 Array1 <double> & y,
		 const bool print) {
  const int nn=2;
  Array1 <Array1 <double> *> xx(nn);

  xx[0] = & x;
  xx[1] = & y;

  Array1 <int> nPos(nn);

  nPos[0] = nx;
  nPos[1] = ny;

  ReadInTable(fileName,keyword,kPos,nPos,nn,n,xx,print);
}

void ReadInTable(const string & fileName,
		 const string & keyword,  // May be empty. Then all lines are read in.
		 const int kPos,          // May be -1. Then the keyward can be in any colum
		 const int nx,
		 const int ny,
		 const int nz,
		 int & n,
		 Array1 <double> & x,
		 Array1 <double> & y,
		 Array1 <double> & z,
		 const bool print) {
  Array1 <Array1 <double> *> xx(3);

  xx[0] = & x;
  xx[1] = & y;
  xx[2] = & z;

  Array1 <int> nPos(3);

  nPos[0] = nx;
  nPos[1] = ny;
  nPos[2] = nz;

  ReadInTable(fileName,keyword,kPos,nPos,3,n,xx,print);
}

void ReadInTable(const string & fileName,
		 const string & keyword,  // May be empty. Then all lines are read in.
		 const int kPos,          // May be -1. Then the keyward can be in any colum
		 const int n1,
		 const int n2,
		 const int n3,
		 const int n4,
		 int & n,
		 Array1 <double> & x1,
		 Array1 <double> & x2,
		 Array1 <double> & x3, 
		 Array1 <double> & x4,
		 const bool print) {
  const int ii=4;
  Array1 <Array1 <double> *> xx(ii);

  xx[0] = & x1;
  xx[1] = & x2;
  xx[2] = & x3;
  xx[3] = & x4;

  Array1 <int> nPos(ii);

  nPos[0] = n1;
  nPos[1] = n2;
  nPos[2] = n3;
  nPos[3] = n4;

  ReadInTable(fileName,keyword,kPos,nPos,ii,n,xx,print);
}

void ReadInTable(const string & fileName,
		 const string & keyword,  // May be empty. Then all lines are read in.
		 const int kPos,          // May be -1. Then the keyward can be in any colum
		 const int n1,
		 const int n2,
		 const int n3,
		 const int n4,
		 const int n5,
		 int & n,
		 Array1 <double> & x1,
		 Array1 <double> & x2,
		 Array1 <double> & x3, 
		 Array1 <double> & x4,
		 Array1 <double> & x5,
		 const bool print) {
  const int ii=5;
  Array1 <Array1 <double> *> xx(ii);

  xx[0] = & x1;
  xx[1] = & x2;
  xx[2] = & x3;
  xx[3] = & x4;
  xx[4] = & x5;

  Array1 <int> nPos(ii);

  nPos[0] = n1;
  nPos[1] = n2;
  nPos[2] = n3;
  nPos[3] = n4;
  nPos[4] = n5;

  ReadInTable(fileName,keyword,kPos,nPos,ii,n,xx,print);
}

void ReadInTable(const string & fileName,
		 const string & keyword,  // May be empty. Then all lines are read in.
		 const int kPos,          // May be -1. Then the keyward can be in any colum
		 const int n1,
		 const int n2,
		 const int n3,
		 const int n4,
		 const int n5,
		 const int n6,
		 int & n,
		 Array1 <double> & x1,
		 Array1 <double> & x2,
		 Array1 <double> & x3, 
		 Array1 <double> & x4,
		 Array1 <double> & x5,
		 Array1 <double> & x6,
		 const bool print) {
  const int ii=6;
  Array1 <Array1 <double> *> xx(ii);

  xx[0] = & x1;
  xx[1] = & x2;
  xx[2] = & x3;
  xx[3] = & x4;
  xx[4] = & x5;
  xx[5] = & x6;

  Array1 <int> nPos(ii);

  nPos[0] = n1;
  nPos[1] = n2;
  nPos[2] = n3;
  nPos[3] = n4;
  nPos[4] = n5;
  nPos[5] = n6;

  ReadInTable(fileName,keyword,kPos,nPos,ii,n,xx,print);
}

void ReadInTable(const string & fileName,
		 const string & keyword,  // May be empty. Then all lines are read in.
		 const int kPos,          // May be -1. Then the keyward can be in any colum
		 const int n1,
		 const int n2,
		 const int n3,
		 const int n4,
		 const int n5,
		 const int n6,
		 const int n7,
		 int & n,
		 Array1 <double> & x1,
		 Array1 <double> & x2,
		 Array1 <double> & x3, 
		 Array1 <double> & x4,
		 Array1 <double> & x5,
		 Array1 <double> & x6,
		 Array1 <double> & x7,
		 const bool print) {
  const int ii=7;
  Array1 <Array1 <double> *> xx(ii);

  xx[0] = & x1;
  xx[1] = & x2;
  xx[2] = & x3;
  xx[3] = & x4;
  xx[4] = & x5;
  xx[5] = & x6;
  xx[6] = & x7;

  Array1 <int> nPos(ii);

  nPos[0] = n1;
  nPos[1] = n2;
  nPos[2] = n3;
  nPos[3] = n4;
  nPos[4] = n5;
  nPos[5] = n6;
  nPos[6] = n7;

  ReadInTable(fileName,keyword,kPos,nPos,ii,n,xx,print);
}

void ReadInTable(const string & fileName,
		 const string & keyword,  // May be empty. Then all lines are read in.
		 const int kPos,          // May be -1. Then the keyward can be in any colum
		 const int n1,
		 const int n2,
		 const int n3,
		 const int n4,
		 const int n5,
		 const int n6,
		 const int n7,
		 const int n8,
		 int & n,
		 Array1 <double> & x1,
		 Array1 <double> & x2,
		 Array1 <double> & x3, 
		 Array1 <double> & x4,
		 Array1 <double> & x5,
		 Array1 <double> & x6,
		 Array1 <double> & x7,
		 Array1 <double> & x8,
		 const bool print) {
  const int ii=8;
  Array1 <Array1 <double> *> xx(ii);

  xx[0] = & x1;
  xx[1] = & x2;
  xx[2] = & x3;
  xx[3] = & x4;
  xx[4] = & x5;
  xx[5] = & x6;
  xx[6] = & x7;
  xx[7] = & x8;

  Array1 <int> nPos(ii);

  nPos[0] = n1;
  nPos[1] = n2;
  nPos[2] = n3;
  nPos[3] = n4;
  nPos[4] = n5;
  nPos[5] = n6;
  nPos[6] = n7;
  nPos[7] = n8;

  ReadInTable(fileName,keyword,kPos,nPos,ii,n,xx,print);
}

void ReadInTable(const string & fileName,
		 const string & keyword,  // May be empty. Then all lines are read in.
		 const int kPos,          // May be -1. Then the keyward can be in any colum
		 const int n1,
		 const int n2,
		 const int n3,
		 const int n4,
		 const int n5,
		 const int n6,
		 const int n7,
		 const int n8,
		 const int n9,
		 int & n,
		 Array1 <double> & x1,
		 Array1 <double> & x2,
		 Array1 <double> & x3, 
		 Array1 <double> & x4,
		 Array1 <double> & x5,
		 Array1 <double> & x6,
		 Array1 <double> & x7,
		 Array1 <double> & x8,
		 Array1 <double> & x9,
		 const bool print) {
  const int ii=9;
  Array1 <Array1 <double> *> xx(ii);

  xx[0] = & x1;
  xx[1] = & x2;
  xx[2] = & x3;
  xx[3] = & x4;
  xx[4] = & x5;
  xx[5] = & x6;
  xx[6] = & x7;
  xx[7] = & x8;
  xx[8] = & x9;

  Array1 <int> nPos(ii);

  nPos[0] = n1;
  nPos[1] = n2;
  nPos[2] = n3;
  nPos[3] = n4;
  nPos[4] = n5;
  nPos[5] = n6;
  nPos[6] = n7;
  nPos[7] = n8;
  nPos[8] = n9;

  ReadInTable(fileName,keyword,kPos,nPos,ii,n,xx,print);
}

void ReadInTable(const string & fileName,
		 const string & keyword,  // May be empty. Then all lines are read in.
		 const int kPos,          // May be -1. Then the keyward can be in any colum
		 const int n1,
		 const int n2,
		 const int n3,
		 const int n4,
		 const int n5,
		 const int n6,
		 const int n7,
		 const int n8,
		 const int n9,
		 const int n10,
		 int & n,
		 Array1 <double> & x1,
		 Array1 <double> & x2,
		 Array1 <double> & x3, 
		 Array1 <double> & x4,
		 Array1 <double> & x5,
		 Array1 <double> & x6,
		 Array1 <double> & x7,
		 Array1 <double> & x8,
		 Array1 <double> & x9,
		 Array1 <double> & x10,
		 const bool print) {
  const int ii=10;
  Array1 <Array1 <double> *> xx(ii);

  xx[0] = & x1;
  xx[1] = & x2;
  xx[2] = & x3;
  xx[3] = & x4;
  xx[4] = & x5;
  xx[5] = & x6;
  xx[6] = & x7;
  xx[7] = & x8;
  xx[8] = & x9;
  xx[9] = & x10;

  Array1 <int> nPos(ii);

  nPos[0] = n1;
  nPos[1] = n2;
  nPos[2] = n3;
  nPos[3] = n4;
  nPos[4] = n5;
  nPos[5] = n6;
  nPos[6] = n7;
  nPos[7] = n8;
  nPos[8] = n9;
  nPos[9] = n10;

  ReadInTable(fileName,keyword,kPos,nPos,ii,n,xx,print);
}

void ReadInTable(const string & fileName,
		 const string & keyword,  // May be empty. Then all lines are read in.
		 const int kPos,          // May be -1. Then the keyward can be in any colum
		 const int n1,
		 const int n2,
		 const int n3,
		 const int n4,
		 const int n5,
		 const int n6,
		 const int n7,
		 const int n8,
		 const int n9,
		 const int n10,
		 const int n11,
		 int & n,
		 Array1 <double> & x1,
		 Array1 <double> & x2,
		 Array1 <double> & x3, 
		 Array1 <double> & x4,
		 Array1 <double> & x5,
		 Array1 <double> & x6,
		 Array1 <double> & x7,
		 Array1 <double> & x8,
		 Array1 <double> & x9,
		 Array1 <double> & x10,
		 Array1 <double> & x11,
		 const bool print) {
  const int ii=11;
  Array1 <Array1 <double> *> xx(ii);

  xx[0] = & x1;
  xx[1] = & x2;
  xx[2] = & x3;
  xx[3] = & x4;
  xx[4] = & x5;
  xx[5] = & x6;
  xx[6] = & x7;
  xx[7] = & x8;
  xx[8] = & x9;
  xx[9] = & x10;
  xx[10] = & x11;

  Array1 <int> nPos(ii);

  nPos[0] = n1;
  nPos[1] = n2;
  nPos[2] = n3;
  nPos[3] = n4;
  nPos[4] = n5;
  nPos[5] = n6;
  nPos[6] = n7;
  nPos[7] = n8;
  nPos[8] = n9;
  nPos[9] = n10;
  nPos[10] = n11;

  ReadInTable(fileName,keyword,kPos,nPos,ii,n,xx,print);
}

// assumes t[i]>=t[i+1]
// find i for t[i] <= x < t[i+1] with i <= n-2
int FindInTable(const double x, const Array1 <double> & t) {
  const int n=t.Size();
  if (n==0)
    error("Empty table");
  
  if (x<t[0]) {
#ifndef NO_WARNINGS
    warning("Look up beyond lower table boundaries",x,t[0],t[n-1]);
#endif
    return 0;
  }

  int ix;
  for(ix=1; ix<n; ix++) {
    if (x<t[ix]) {
      return ix-1;
    }
  }
  
  if (ix==n) {
#ifndef NO_WARNINGS
    warning("Look up beyond upper table boundaries",x,t[0],t[n-1]);
#endif
  }

  ix=n-2;
  return ix;
}

// assumes t[i]<=t[i+1]
// find i for t[i+1] > x > t[i] with i <= n-2
int FindInReverseTable(const double x, const Array1 <double> & t) {
  const int n=t.Size();
  if (n==0)
    error("Empty table");
  
  if (x>t[0]) {
    warning("Look up beyond lower table boundaries",x,t[0],t[n-1]);
    return 0;
  }

  int ix;
  for(ix=1; ix<n; ix++) {
    if (x>t[ix]) {
      return ix-1;
    }
  }
  
  if (ix==n) {
    warning("Look up beyond upper table boundaries",x,t[0],t[n-1]);
  }

  ix=n-2;
  return ix;
}


