/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//  Gaussian Quadrature Routines                                           //
//                                                                         //
//  B. Militzer                                     Berkeley 04-18-17      //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef _QUADRATURE_
#define _QUADRATURE_

#include "Array.h"

double gammln(double xx);

void GaussJacobiQuadraturePoints(Array1 <double> & x, Array1 <double> & w, const int n, const double alf, const double bet);

inline void GaussChebyshevQuadraturePoints(Array1 <double> & x, Array1 <double> & w, const int n) {
  GaussJacobiQuadraturePoints(x,w,n,-0.5,-0.5);
}

void GaussLegendreQuadraturePoints(const double x1, const double x2, const int n, Array1 <double> & x, Array1 <double> & w);

#endif // _QUADRATURE_
