/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// Physical Constants                                                      // 
//                                                                         //
// Burkhard Militzer                                  Livermore 4-27-01    //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef _PHYSICS_
#define _PHYSICS_

#include "Standard.h"

// #define HELIUM
#define HYDROGEN

class PC {
 public:
  static const double eConst;
  static const double e;
  static const double mu0;
  static const double c;
  static const double eps0;
  static const double h;
  static const double hBar;
  static const double kb;
  static const double fConst;
  static const double me;
  static const double mp;
  static const double mh;
  static const double md;
  static const double u;
  static const double mAlphaP;
  static const double mHAtom;
  static const double mHeAtom;
  static const double ab;
  static const double Ha;
  static const double Ry;
  static const double NA;
  static const double G;

  static const double A;
  static const double AToAU;
  static const double AUToA;
  static const double A3ToAU;
  static const double AUToA3;

  static const double rho0D2gccStandard;
  static const double rho0D2gcc;
  static const double rho0D2kgm3;
  static const double e0Standard;
  static const double e0;
  static const double e0DFT;
  static const double e0Aziz;
  static const double V0Hecm3molStandard;
  static const double V0Hecm3mol;
  static const double V0Hem3mol;
  static const double V0Hem3atom;
  static const double V0HeAUatom;
  static const double V0HeAUelectron;
  static const double rho0Hegcc;
  static const double nn0;
  static const double p0;

  static const double PaToAU;
  static const double AUToPa;
  static const double GPaToAU;
  static const double AUToGPa;
  static const double MbarToAU;
  static const double AUToMbar;
  static const double barToAU;
  static const double AUToBar;
  static const double P_AUToCGS;
  static const double P_CGSToAU;
  static const double GPaToCGS;
  static const double CGSToGPa;

  static const double AUToK;
  static const double KToAU;
  static const double K4ToAU;
  static const double AUToeV;
  static const double eVToAU;
  static const double timeAU;
  static const double sToAU;
  static const double e6cmPerSToAU;
  static const double kmPerSToAU;
  static const double AUTokmPerS;
  static const double AUToe6cmPerS;
  static const double mAU;
  static const double AUToH2gcc;
  static const double AUToD2gcc;
  static const double AUToHegcc;
  static const double H2gccToAU;
  static const double D2gccToAU;
  static const double AUTogcc;
  static const double gccToAU;
  static const double rho0Algcc;
  static const double rho0AlAU;
  static const double rho0Quartzgcc;
  static const double rho0QuartzAU;
};

inline double DensityFromRs(double rs) {
  double v=4.0/3.0*pi*rs*rs*rs;
  return 1.0/v;
}

inline double RsFromDensity(double nn) {
  return pow(3.0/(4.0*pi*nn),1.0/3.0);
}

#endif // PHYSICS
