/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// Parser class                                                            //
//                                                                         //
// Burkhard Militzer                                    Urbana 4-1-99      //
// based on earlier version by John Shumway                                //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#include "Standard.h"
#include "Parser.h"

// There can be a problem with the tyep of npos
// int          using KCC-3.4d
// unsigned int using gcc
// Earlier code used KCC defines "_CFE", use this as indicator
/*
#ifndef _CFE
unsigned int find_first_not_of(const string & s, const char c) {
  unsigned int i=0;
  while (i<s.length() && s[i]==c)
    i++;
  if (i==s.length()) i=s.npos;
  return i;
}
#else
int find_first_not_of(const string & s, const char c) {
  int i=0;
  while (i<s.length() && s[i]==c)
    i++;
  if (i==s.length()) i=s.npos;
  return i;
}
#endif
*/
string::size_type find_first_not_of(const string & s, const char c) {
  string::size_type i=0;
  while (i<s.length() && s[i]==c)
    i++;
  if (i==s.length()) i=s.npos;
  return i;
}

bool Parser::ReadLine() {
  string word; 
  do {
    while (GetLine()) { // stores line in 'line'
      nLinesRead++;
      //      Write2(nLinesRead,line);
      if (!ignoreEmptyLines) break;
      //      if ( line.length() != 0 && find_first_not_of(line,' ')!=line.npos ) {
      // This following line should be used but does not work with KCC earlier than 3.4f
      // but must use if for PGI 5.1 !!!
      if ( line.length() != 0 && line.find_first_not_of(' ')!=line.npos ) {
	break;
      }
    }
    if (Status()==false) return false;

    istringstream line_stream(line);
    line_stream >> word;
  } while (word[0]=='#' && ignoreComments);

  nNonEmptyLinesRead++;
  SplitLine();
  // if a line only contains a "tab" then CUPID will have problems, fix later

  return Status(); //Return boolean status of the input stream.
}

bool Parser::ReadTillKeyword(const string & w) {
  while(GetLine()) { // note that this line does not split the 'line' into 'words'
    if (line.find(w)!=line.npos) break;
  }
  return Status(); //Return boolean status of the input stream.
}

bool Parser::ParseTillKeyword(const string & w) {
  while(ReadLine()) { // note that this line does split the 'line' into 'words'
    if (line.find(w)!=line.npos) break;
  }
  return Status(); //Return boolean status of the input stream.
}

void Parser::SplitXMLWord(string & w) {
  while (true) {
    string::size_type j1 = w.find_first_not_of(' ');
    if (j1==w.npos) return; // nothing left but empty spaces
    w = w.substr(j1); // throw empty spaces at the beginning
    string::size_type j2 = w.find_first_of(' ');
    if (j2==w.npos) { // ok, remainder is all one word
      words.PushBack(w);
      //      cout << "X "; Write(words.back());
      return;
    } else {
      words.PushBack(w.substr(0,j2));
      w = w.substr(j2); // not sure if j2+1 would be safe for j2=last character
      //      cout << "Y "; Write(words.back());
      //      cout << "Y "; Write3(j1,j2,words.back());
      //      Write(w);
    }
  }
}

void Parser::SplitXMLLine() {
  string line = GetLineString();
  words.Clear();
  while (true) {
    string::size_type i1 = line.find('<');
    if (i1!=line.npos) {

      string::size_type j = line.find_first_not_of(' ');
      if (j<i1) { // ok there is something before the first '<' --> store it
	//	words.push_back(line.substr(j,i1-j));
	//	cout << "0 "; Write(words.back());
	string w = line.substr(j,i1-j);
	SplitXMLWord(w); // unclear why 'line.substr(j,i1-j)' does not work as argument directly
      }

      string::size_type i2 = line.find('>');
      if (i2==line.npos) error("XML: Could not find closing >",GetLineString());
      words.PushBack(line.substr(i1,i2-i1+1));
      line = line.substr(i2+1);
      //      cout << "1 "; Write(words.back());
      //      Write2(line,line.length());

    } else { // just one XML word left - split it according to spaces

      string::size_type j = line.find_first_not_of(' ');
      if (j!=line.npos) {
	string w = line.substr(j);
	SplitXMLWord(w);
	//	words.push_back(line.substr(j));
	//	cout << "2 "; Write(words.back());
      }
      break;
    }
  } 
  //  Write(GetLineString());
}

const string& Parser::GetString(const int i) const {
  if (i<0 || i>=int(words.Size())) 
    error("Index out of bounds in Parser",i,words.Size(),line,filename);
  return words[i];
}

void Parser::CheckNotNumber(const string & s) const {
  const string numbers = "0123456789";
  if (s.find_first_not_of(numbers)==string::npos) 
    error("Parser: Name string contains only numbers",s,filename);
}

// Check if it contains not just numbers
const string& Parser::GetNameString(const int i) const {
  const string & s=GetString(i);
  CheckNotNumber(s);
  return s;
}

const string Parser::GetStringLowerCase(const int i) const {
  string s=GetString(i);
  string sl;
  for(string::const_iterator p=s.begin();p!=s.end();++p) {
    //    s.replace(*p,*p+1,tolower(*p));
    sl += tolower(*p);
  }
  //  Write2(s,sl);
  return sl;
}

const string Parser::GetNameStringLowerCase(const int i) const {
  string s=GetStringLowerCase(i);
  CheckNotNumber(s);
  return s;
}

const string Parser::GetStringUpperCase(const int i) const {
  string s=GetString(i);
  return UpperCase(s);
}

const string Parser::GetNameStringUpperCase(const int i) const {
  string s=GetStringUpperCase(i);
  CheckNotNumber(s);
  return s;
}

int Parser::GetInt(const int i) const {
  if (i<0 || i>=int(words.Size())) 
    error("Index out of bounds in Parser",i,words.Size(),line,filename);

  if (IsInt(words[i])==false) error("Parser: Not an int ",i,words[i],filename);
  //  const string intChars(" +-0123456789");
  //  if (int j=words[i].find_first_not_of(intChars) != string::npos)
  //    error("Parser: Not an integer ","\""+words[i]+"\"",i,j+1,"\""+line+"\"","\""+filename+"\"");
  
  istringstream wordstream(words[i]);
  int value;
  wordstream >> value;
  return value;
}

double Parser::GetDouble(const int i) const {
  if (i<0 || i>=int(words.Size())) 
    error("Index out of bounds in Parser",i,words.Size(),line,filename);

  if (IsDouble(words[i])==false) error("Parser: Not a double ",i,words[i],filename);
    //  const string doubleChars(" +-0123456789.edDE");
    //  if (int j=words[i].find_first_not_of(doubleChars) != string::npos)
    //    error("Parser: Not a double ",words[i],j+1,filename);
  
  istringstream wordstream(words[i]);
  double value;
  wordstream >> value;
  return value;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////

int Parser::GetNumberOfDoublesFollowingString(const string & s) const {
  int p = PositionInLine(s);
  if (p<0) error("Could not find string \""+s+"\" in line \""+line+"\"");
  int n = 0;
  while (++p < words.Size()) {
    if (IsDouble(words[p])) {
      n++;
    } else {
      break;
    }
  }
  return n;
}

double Parser::GetDoubleFollowingString(const string & s, const int offset, const bool printError) const {
  int p = PositionInLine(s);
  if (p<0) {
    if (printError) {
      error("Could not find string \""+s+"\" in line \""+line+"\"");
    } else {
//      warning("Could not find string \""+s+"\" in line \""+line+"\"");
      warning("Could not find string \""+s+"\"");
      return -1.0;
    }
  }
  if (p+offset+1>words.Size()-1) error("Line may be too short. Cannot extract parameter number "+DoubleToString(p+offset+1)+" from line \""+line+"\"");
  return GetDouble(p+offset+1);
}

int Parser::GetIntFollowingString(const string & s, const int offset, const bool printError) const {
  int p = PositionInLine(s);
  if (p<0) {
    if (printError) {
      error("Could not find string \""+s+"\" in line \""+line+"\"");
    } else {
      warning("Could not find string \""+s+"\" in line \""+line+"\"");
      return -1;
    }
  }
  if (p+offset+1>words.Size()-1) error("Line may be too short. Cannot extract parameter number "+DoubleToString(p+offset+1)+" from line \""+line+"\"");
  return GetInt(p+offset+1);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////

void Parser::ProcessKeyword(const string & keyword) {
  ReadLineSavely();

  string kw=GetNameStringLowerCase(0);
  if (kw!=LowerCase(keyword))
    error("Parser: Wrong keyword found",keyword,GetLineString(),filename);
}

void Parser::ProcessKeyword(const string & keyword, const int n) {
  ProcessKeyword(keyword);

  if (n!=GetNWords())
    error("Parser: Incorrect number of arguments",n,GetNWords(),GetLineString(),filename);

}

void Parser::ProcessLine(const int n) {
  ReadLineSavely();

  if (n!=GetNWords())
    error("Parser: Incorrect number of arguments",n,GetNWords(),GetLineString(),filename);

}

void Parser::PutLineBackIntoParser(const Array1 <string> & l) {
  words.Clear();
  line.clear();
  for(int i=0; i<l.Size(); i++) {
    words.PushBack(l[i]);
    if (i>0) line += " ";
    line += l[i];
  }
}

int Parser::FindKeywordInLine(const string & key) {
  for(int i=0; i<GetNWords(); i++) {
    if (key==words[i]) return i;
  }
  return notFound; // return words.Find(key);
}

int Parser::FindKeywordInLineSafely(const string & key) {
  int i = FindKeywordInLine(key);
  if (i==notFound) error("Parser: Could not find keyword",key," in line ",GetLineString());
  return i;
}

double Parser::GetDoubleAfterKeyword(const string & key) {
  int i = FindKeywordInLineSafely(key);
  return GetDouble(i+1);
}

int Parser::GetIntAfterKeyword(const string & key) {
  int i = FindKeywordInLineSafely(key);
  return GetInt(i+1);
}  

bool Parser::GetDoubleSafely(const int i, double & x) const {
  //  Write2(i,GetNWords());
  if (i>=GetNWords()) return false;
  //  Write3(i,words[i],IsDouble(words[i]));
  if (IsDouble(words[i])==false) return false;
  x = GetDouble(i);
  //  Write2(i,x);
  return true;
}

bool Parser::GetIntSafely(const int i, int & x) const {
  if (i+1>=GetNWords()) return false;
  if (IsInt(words[i])==false) return false;
  x = GetInt(i);
  return true;
}

bool Parser::GetDoubleAfterKeywordSafely(const string & key, double & x) {
  int i = FindKeywordInLine(key);
  //  Write(i);
  if (i==notFound) return false;
  return GetDoubleSafely(i+1,x);
  //  if (i+1>=GetNWords()) return false;
  //  if (IsDouble(words[i+1])==false) return false;
  //  x = GetDouble(i+1);
  //  return true;
}

bool Parser::GetIntAfterKeywordSafely(const string & key, int & x) {
  int i = FindKeywordInLine(key);
  if (i==notFound) return false;
  return GetIntSafely(i+1,x);
}

