/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//  Legendre polynomials and first derivates                               //
//                                                                         //
//  B. Militzer                                     Berkeley 04-17-17      //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef _LEGENDREPOLYNOMIALS_
#define _LEGENDREPOLYNOMIALS_

#include "Array.h"

// note pn must have n+1 elements
inline void LegendrePolynomials(const int n, const double x, Array1 <double> & pn) {
  pn[0] = 1.0;
  if (n==0) return; // if n==0, pn[1] may not be accessible

  pn[1] = x;

  double p0 = 1.0;
  double p1 = x;

  for(int k=2; k<=n; k++) {

    double pf = (2.0*k-1.0)/double(k) * x * p1 - (k-1.0)/double(k) * p0;
    pn[k] = pf;

    p0 = p1;
    p1 = pf;

  }
}

// note pn must have n+1 elements
inline void LegendrePolynomials(const int n, const double x, Array1 <double> & pn, Array1 <double> & pd) {
  pn[0] = 1.0;
  pd[0] = 0.0;
  if (n==0) return; // if n==0, pn[1] may not be accessible

  pd[1] = 1.0;
  pn[1] = x;

  double p0 = 1.0;
  double p1 = x;

  for(int k=2; k<=n; k++) {

    double pf = (2.0*k-1.0)/double(k) * x * p1 - (k-1.0)/double(k) * p0;
    pn[k] = pf;

    if ( fabs(x)==1.0 ) {
      pd[k] = 0.5 * pow(x,k+1) * k * (k+1.0);
    } else {
      pd[k] = k * ( p1 - x * pf ) / ( 1.0 - x * x );
    }

    p0 = p1;
    p1 = pf;

  }
}

inline double LegendrePolynomial(const int n, const double x) {
  if (n==0) return 1.0;
  if (n==1) return x;

  double p0 = 1.0;
  double p1 = x;
  double pf = p1;

  for(int k=2; k<=n; k++) {
    pf = (2.0*k-1.0)/double(k) * x * p1 - (k-1.0)/double(k) * p0;
    p0 = p1;
    p1 = pf;
  }

  //  Array1 <double> pn(n+1);
  //  LegendrePolynomials(n,x,pn);
  //  Write4(n,x,pf,pn.Last());

  return pf; // just return value that is stored in pn[k] below
}

#endif // _LEGENDREPOLYNOMIALS_
