////////////////////////////////////////////////////////////////////////////////
//                                                                            //
// Class for linear, logarithmic, inverse (1/x) grids in 1D                   //
//                                                                            //
// Burkhard Militzer                                        Urbana 4-9-99     //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

#include "Grid.h"
#include "Parser.h"

string Grid::gridString="Grid";
const string LinearGrid::typeString = "LINEAR";
const string LogGrid::typeString    = "LOG";
const string InverseGrid::typeString= "INVERSE";
const string GeometricGrid::typeString= "GEOMETRIC";

Grid * Grid::Define(istream & is, const bool formatFlag) {
  Parser p(is);
  p.ReadLineSafely();
  
  Write(p.GetLineString());

  string gridType;
  double r1;
  double r2;
  int nPoints;

  if (formatFlag) { // Ceperley's grid line
    gridType = p.GetNameStringUpperCase(1);
    r1 = p.GetDouble(2);
    r2 = p.GetDouble(3);
    nPoints = p.GetInt(0);
  } else { // mine
    gridType = p.GetNameStringUpperCase(0);
    r1 = p.GetDouble(1);
    r2 = p.GetDouble(2);
    nPoints = p.GetInt(3);
  }

  if (gridType==UpperCase(LinearGrid::typeString)) {
    return new LinearGrid(r1,r2,nPoints);
  } else if (gridType==UpperCase(LogGrid::typeString)) {
    return new LogGrid(r1,r2,nPoints);
  } else if (gridType==UpperCase(InverseGrid::typeString)) {
    double cf=p.GetDouble(4);
    return new InverseGrid(r1,r2,nPoints,cf);
  };
  error("Unknown grid type",gridType);
  return (Grid*) 0;
}


  
  
