/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// Find minimum in  1D                                                     // 
//                                                                         //
// Burkhard Militzer                                  Livermore 02-26-02   //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef _FINDMINIMUM_
#define _FINDMINIMUM_

#include <math.h>
#include "Standard.h"

template <class T> 
double FindMinimumTrisection(double x1, 
			     double x2, 
			     const double tolX,
			     T & f, const double flag=true, const string name="") {
  const double x1Org = x1;
  const double x2Org = x2;

  bool flag1 = true;
  bool flag2 = true;
  double xx=(x2+x1)/2.0;
  while (fabs(x1-x2)>tolX) {
    double l3=(x2-x1)/3.0;
    double xx1=x1+l3;
    double xx2=x2-l3;
    double ff1=f(xx1);
    double ff2=f(xx2);
    if (ff1<ff2) {
      flag2=false;
      x2=xx2;
      xx=xx1;
    } else {
      flag1=false;
      x1=xx1;
      xx=xx2;
    }
    //    Write5(xx1,xx2,fabs(xx2-xx1),ff1,ff2);
  }

  string s = (name.length()==0) ? "" : "\""+name+"\" "; 
  if (flag1 && flag) 
    error("FindMinimumTrisection: "+s+"Minimum found at lower limit",x1Org,x2Org);
  if (flag2 && flag) 
    error("FindMinimumTrisection: "+s+"Minimum found at upper limit",x1Org,x2Org);

  return xx;
}

template <class T> 
double FindMaximumTrisection(double x1, 
			     double x2, 
			     const double tolX,
			     T & f, const double flag=true, const string name="") {
  const double x1Org = x1;
  const double x2Org = x2;

  bool flag1 = true;
  bool flag2 = true;
  double xx=(x2+x1)/2.0;
  while (fabs(x1-x2)>tolX) {
    double l3=(x2-x1)/3.0;
    double xx1=x1+l3;
    double xx2=x2-l3;
    double ff1=f(xx1);
    double ff2=f(xx2);
    if (ff1>ff2) {
      flag2=false;
      x2=xx2;
      xx=xx1;
    } else {
      flag1=false;
      x1=xx1;
      xx=xx2;
    }
    //    Write5(xx1,xx2,fabs(xx2-xx1),ff1,ff2);
  }

  string s = (name.length()==0) ? "" : "\""+name+"\" "; 
  if (flag1 && flag) 
    error("FindMaximumTrisection: "+s+"Minimum found at lower limit",x1Org,x2Org);
  if (flag2 && flag) 
    error("FindMaximumTrisection: "+s+"Minimum found at upper limit",x1Org,x2Org);

  return xx;
}

template <class T> 
double FindMinimumStepper(double x1, 
			  double dx, 
			  const double tolX,
			  T & f, const string name="") {
  double f1 = f(x1);
  while (fabs(dx)>tolX) {
    double x2 = x1+dx;
    double f2 = f(x2);
    //    Write2(x2,f2);
    if (f2<f1) {
      dx *= 1.1;
      x1 = x2;
      f1 = f2;
    } else {
      dx *= -0.5;
    }
  }

  return x1;
}

template <class T> 
double FindMinimumSurvey(double x1, 
			 double x2, 
			 const int n, 
			 const double tolX,
			 T & f, const string name="") {
  double x    = x1;
  double xMin = x;
  double fMin = f(x);
  double dx = (x2-x1)/double(n);
  for(int i=1; i<=n; i++) {
    x += dx;
    double ff = f(x);
    //    Write2(x,ff);
    if (ff<fMin) {
      xMin = x;
      fMin = ff;
    }
  }
  if (dx<tolX) return xMin;
  return FindMinimumStepper(xMin,dx*0.5,tolX,f);
}

#endif // _FINDMINIMUM_
