/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//  CMS Method                                                             //
//                                                                         //
//  B. Militzer                                     Berkeley 04-18-17      //
//                                                                         //
//  based on William Hubbard methodology and                               //
//  based on Sean Wahl tidal CMS code                                      //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#include "CMS.h"
#include "LegendrePolynomials.h"
#include "Quadrature.h"
#include "ReadInTable.h"
#include "Spline.h"
#include "MatrixAlgebra.h"

double CMS::KPolytrope() const {
  double PAverage = ( pressure[nl-1]+pressure[nl-2] )/2.0;
  double K = sqrt( PAverage ) / rho[nl-2] ;
  return K;
}

void CMS::UpdateDensityPolytrope() {
  double K = KPolytrope();
  //  Write2(K,CentralPressure());
  //  Write(pressure);

  Array1 <double> rhoDesired = rho;
  for(int i=0; i<nl-1; i++) {
    double PAverage = (pressure[i]+pressure[i+1])/2.0;
    rhoDesired[i] = sqrt( PAverage / K );
    //    Write2(i,rhoDesired[i]);
  }
  
  // for coreless model, pCentral constrains the innermost density
  double PAverage = (pressure[nl-1]+CentralPressure())/2.0;
  rhoDesired[nl-1] = sqrt( PAverage / K );

  rho = rhoDesired;
  //  Write2(rho,hasCore);
  //  Write(pressure);
  //  Quit("CCCCCCCCC");
}

////////////////////////////////////////////////////////////////////////////////

void CMS::ReadInitialDensitiesFromFile() {
  string fileName = "delta.dat";
  cout << "Reading initial densities from file: " << fileName << endl;
  LoadVector(fileName,delta,true);
  CalculateRhoFromDeltaRho();

  fileName = "zeta.dat";
  cout << "Reading initial zeta values from file: " << fileName << endl;
  LoadMatrix(fileName,zeta,true);

  //  Write(delta);
  //  Write(rho);
  //  Quit("d");
  cout << "Density at center = " << rho[nl-1] << endl;
  //          write(*,*) 'core rho:',rho(nlayer)
}

void CMS::SetInitialDensitiesToPolytropeEOS() { // removed older, special code that treat older one-layer cores 
  // equations 62 and 63 in Hubbard 2013
  cout << endl << " Setting initial densities to polytropic EOS." << endl;

  delta[0]    = 0.0; // no increase at the outermost boundary
  delta[nl-1] = 0.0; // formula below does not work for j=nl-1 b/c j+1=nl
  for(int j=0; j<nl-1; j++) {
    const double dLam = lambda[j] - lambda[j+1];
    const double lam = lambda[j];
    delta[j] = -dLam * ( cos(pi*lam)/lam - sin(pi*lam)/(pi*sqr(lam)) );
    //    Write3(j,lambda[j],delta[j]);
  }

  CalculateRhoFromDeltaRho();

  cout << " Density at center = " << rho[nl-1] << endl;
  //  Write(delta);
  //  Write(rho);
  //  Quit("SetInitialDensitiesToPolytropeEOS()");
}
