<a name="ds-structuredatasetmetadatajson"> </a>

# StructureDataset D-PLACE aggregated dataset

**CLDF Metadata**: [StructureDataset-metadata.json](./StructureDataset-metadata.json)

**Sources**: [sources.bib](./sources.bib)

property | value
 --- | ---
[dc:bibliographicCitation](http://purl.org/dc/terms/bibliographicCitation) | Kathryn R. Kirby, Russell D. Gray, Simon J. Greenhill, Fiona M. Jordan, Stephanie Gomes-Ng, Hans-Jörg Bibiko, Damián E. Blasi, Carlos A. Botero, Claire Bowern, Carol R. Ember, Dan Leehr, Bobbi S. Low, Joe McCarter, William Divale, and Michael C. Gavin. (2016). D-PLACE: A Global Database of Cultural, Linguistic and Environmental Diversity. PLoS ONE, 11(7): e0158391. doi:10.1371/journal.pone.0158391.
[dc:conformsTo](http://purl.org/dc/terms/conformsTo) | [CLDF StructureDataset](http://cldf.clld.org/v1.0/terms.rdf#StructureDataset)
[dc:identifier](http://purl.org/dc/terms/identifier) | https://d-place.org
[dc:license](http://purl.org/dc/terms/license) | https://creativecommons.org/licenses/by-nc/4.0/
[dcat:accessURL](http://www.w3.org/ns/dcat#accessURL) | https://github.com/d-place/dplace-cldf
[prov:wasDerivedFrom](http://www.w3.org/ns/prov#wasDerivedFrom) | <ol><li><a href="https://github.com/D-PLACE/dplace-dataset-binford/tree/v3.1">D-PLACE/dplace-dataset-binford v3.1</a></li><li><a href="https://github.com/D-PLACE/dplace-dataset-carneiro//tree/v3.1">D-PLACE/dplace-dataset-carneiro/ v3.1</a></li><li><a href="https://github.com/D-PLACE/dplace-dataset-ccmc/tree/v3.1">D-PLACE/dplace-dataset-ccmc v3.1</a></li><li><a href="https://github.com/D-PLACE/dplace-dataset-ea/tree/v3.1">D-PLACE/dplace-dataset-ea v3.1</a></li><li><a href="https://github.com/D-PLACE/dplace-dataset-ecoclimate/tree/v3.1">D-PLACE/dplace-dataset-ecoclimate v3.1</a></li><li><a href="https://github.com/D-PLACE/dplace-dataset-gmted2010/tree/v3.1">D-PLACE/dplace-dataset-gmted2010 v3.1</a></li><li><a href="https://github.com/D-PLACE/dplace-dataset-gshhs/tree/v3.1">D-PLACE/dplace-dataset-gshhs v3.1</a></li><li><a href="https://github.com/D-PLACE/dplace-dataset-jenkins/tree/v3.1">D-PLACE/dplace-dataset-jenkins v3.1</a></li><li><a href="https://github.com/D-PLACE/dplace-dataset-kreft/tree/v3.1">D-PLACE/dplace-dataset-kreft v3.1</a></li><li><a href="https://github.com/D-PLACE/dplace-dataset-modis/tree/v3.1">D-PLACE/dplace-dataset-modis v3.1</a></li><li><a href="https://github.com/D-PLACE/dplace-dataset-sccs/tree/v3.1">D-PLACE/dplace-dataset-sccs v3.1</a></li><li><a href="https://github.com/D-PLACE/dplace-dataset-teow/tree/v3.1">D-PLACE/dplace-dataset-teow v3.1</a></li><li><a href="https://github.com/D-PLACE/dplace-dataset-wnai/tree/v3.0">D-PLACE/dplace-dataset-wnai v3.0</a></li><li><a href="https://github.com/phlorest/atkinson2006/tree/v1.2">phlorest/atkinson2006 v1.2</a></li><li><a href="https://github.com/phlorest/birchall_et_al2016/tree/v1.1">phlorest/birchall_et_al2016 v1.1</a></li><li><a href="https://github.com/phlorest/bouckaert_et_al2012/tree/v1.1">phlorest/bouckaert_et_al2012 v1.1</a></li><li><a href="https://github.com/phlorest/bouckaert_et_al2018/tree/v1.1">phlorest/bouckaert_et_al2018 v1.1</a></li><li><a href="https://github.com/phlorest/bowern_and_atkinson2012/tree/v1.1">phlorest/bowern_and_atkinson2012 v1.1</a></li><li><a href="https://github.com/phlorest/chacon_and_list2015/tree/v1.1">phlorest/chacon_and_list2015 v1.1</a></li><li><a href="https://github.com/phlorest/chang_et_al2015/tree/v1.1">phlorest/chang_et_al2015 v1.1</a></li><li><a href="https://github.com/phlorest/defilippo_et_al2012/tree/v1.1">phlorest/defilippo_et_al2012 v1.1</a></li><li><a href="https://github.com/phlorest/dunn_et_al2011/tree/v1.1">phlorest/dunn_et_al2011 v1.1</a></li><li><a href="https://github.com/phlorest/gray_et_al2009/tree/v1.1.1">phlorest/gray_et_al2009 v1.1.1</a></li><li><a href="https://github.com/phlorest/greenhill2015/tree/v1.1">phlorest/greenhill2015 v1.1</a></li><li><a href="https://github.com/phlorest/grollemund_et_al2015/tree/v1.1">phlorest/grollemund_et_al2015 v1.1</a></li><li><a href="https://github.com/phlorest/honkola_et_al2013/tree/v1.1">phlorest/honkola_et_al2013 v1.1</a></li><li><a href="https://github.com/phlorest/hruschka_et_al2015/tree/v1.1">phlorest/hruschka_et_al2015 v1.1</a></li><li><a href="https://github.com/phlorest/kitchen_et_al2009/tree/v1.1">phlorest/kitchen_et_al2009 v1.1</a></li><li><a href="https://github.com/phlorest/kolipakam_et_al2018/tree/v1.1">phlorest/kolipakam_et_al2018 v1.1</a></li><li><a href="https://github.com/phlorest/lee2015/tree/v1.1">phlorest/lee2015 v1.1</a></li><li><a href="https://github.com/phlorest/lee_and_hasegawa2011/tree/v1.1">phlorest/lee_and_hasegawa2011 v1.1</a></li><li><a href="https://github.com/phlorest/lee_and_hasegawa2013/tree/v1.1">phlorest/lee_and_hasegawa2013 v1.1</a></li><li><a href="https://github.com/phlorest/robinson_and_holton2012/tree/v1.1">phlorest/robinson_and_holton2012 v1.1</a></li><li><a href="https://github.com/phlorest/sagart_et_al2019/tree/v1.1">phlorest/sagart_et_al2019 v1.1</a></li><li><a href="https://github.com/phlorest/sicoli_and_holton2014/tree/v1.1">phlorest/sicoli_and_holton2014 v1.1</a></li><li><a href="https://github.com/phlorest/walker_and_ribeiro2011/tree/v1.1">phlorest/walker_and_ribeiro2011 v1.1</a></li><li><a href="https://github.com/phlorest/zhang_et_al2019/tree/v1.1">phlorest/zhang_et_al2019 v1.1</a></li><li><a href="https://github.com/d-place/dplace-cldf/tree/v3.1.0">d-place/dplace-cldf v3.1.0</a></li><li><a href="https://github.com/glottolog/glottolog/tree/v5.0">Glottolog v5.0</a></li></ol>
[prov:wasGeneratedBy](http://www.w3.org/ns/prov#wasGeneratedBy) | <ol><li><strong>python</strong>: 3.10.12</li><li><strong>python-packages</strong>: <a href="./requirements.txt">requirements.txt</a></li></ol>
[rdf:ID](http://www.w3.org/1999/02/22-rdf-syntax-ns#ID) | dplace
[rdf:type](http://www.w3.org/1999/02/22-rdf-syntax-ns#type) | http://www.w3.org/ns/dcat#Distribution


## <a name="table-datacsv"></a>Table [data.csv](./data.csv)

Values are coded datapoints, i.e. measurements of a variable for a society.

**Note:** Missing data is signaled by an empty Value column.

property | value
 --- | ---
[dc:conformsTo](http://purl.org/dc/terms/conformsTo) | [CLDF ValueTable](http://cldf.clld.org/v1.0/terms.rdf#ValueTable)
[dc:extent](http://purl.org/dc/terms/extent) | 631668


### Columns

Name/Property | Datatype | Description
 --- | --- | --- 
[ID](http://cldf.clld.org/v1.0/terms.rdf#id) | `string`<br>Regex: `[a-zA-Z0-9_\-]+` | Primary key
[Soc_ID](http://cldf.clld.org/v1.0/terms.rdf#languageReference) | `string` | References [societies.csv::ID](#table-societiescsv)
[Var_ID](http://cldf.clld.org/v1.0/terms.rdf#parameterReference) | `string` | References [variables.csv::ID](#table-variablescsv)
[Value](http://cldf.clld.org/v1.0/terms.rdf#value) | `string` | Values for categorical and ordinal variables reference the corresponding code via the Code_ID column. Values for continuous variables have the measured number in the Value column and an empty Code_ID.
[Code_ID](http://cldf.clld.org/v1.0/terms.rdf#codeReference) | `string` | References [codes.csv::ID](#table-codescsv)
[Comment](http://cldf.clld.org/v1.0/terms.rdf#comment) | `string` | 
[Source](http://cldf.clld.org/v1.0/terms.rdf#source) | list of `string` (separated by `;`) | References [sources.bib::BibTeX-key](./sources.bib)
`sub_case` | `string` | More specific description of the population the data refer to in terms of society or area.
`year` | `string`<br>Regex: `-?[0-9]{1,4}(-[0-9]{4})?` | Focal year, i.e. the time period to which the data refer.
`source_coded_data` | `string` | The source of the coded data, which was aggregated in this dataset.
`admin_comment` | `string` | 

## <a name="table-societiescsv"></a>Table [societies.csv](./societies.csv)

The aggregated D-PLACE data lists two kinds of entities in its LanguageTable: Societies, i.e. cultural groups for which D-PLACE datasets provide data, and Languoids, i.e. language (varieties) which are referenced in Phlorest phylogenies. The two kinds are marked as "society" and "languoid"respectively in the type column.

property | value
 --- | ---
[dc:conformsTo](http://purl.org/dc/terms/conformsTo) | [CLDF LanguageTable](http://cldf.clld.org/v1.0/terms.rdf#LanguageTable)
[dc:extent](http://purl.org/dc/terms/extent) | 6174


### Columns

Name/Property | Datatype | Description
 --- | --- | --- 
[ID](http://cldf.clld.org/v1.0/terms.rdf#id) | `string`<br>Regex: `[a-zA-Z0-9_\-]+` | Primary key
[Name](http://cldf.clld.org/v1.0/terms.rdf#name) | `string` | 
[Latitude](http://cldf.clld.org/v1.0/terms.rdf#latitude) | `decimal`<br>&ge; -90<br>&le; 90 | 
[Longitude](http://cldf.clld.org/v1.0/terms.rdf#longitude) | `decimal`<br>&ge; -180<br>&le; 180 | 
[Glottocode](http://cldf.clld.org/v1.0/terms.rdf#glottocode) | `string`<br>Regex: `[a-z0-9]{4}[1-9][0-9]{3}` | 
`Name_and_ID_in_source` | `string` | Society names identified as pejorative have been replaced with a preferred, English-language ethnonym. The name (and ID) as given in the source dataset is kept in this field.
`xd_id` | `string` | “cross-data-set” identifier, used to link societies present in different datasets, if they share a focal location. Note: If this field is empty, other fields such as Name, Glottocode, focal year and location may be used to identify societies across datasets if appropriate.
`alt_names_by_society` | list of `string` (separated by `; `) | A list of ‘alternate’ names for the society; includes, where available, one or more autonyms in the society’s own language, as well as other commonly encountered ethnonyms.
`main_focal_year` | `integer` | Focal year specifying the time period to which the data refer, given as number of years BCE - if negative - or CE.
`HRAF_name_ID` | `string` | Name(s) and ID(s) of the corresponding society in HRAF (the Human Relations Area Files)
`HRAF_ID` | `string` | ID of the corresponding society in HRAF
`origLat` | `decimal`<br>&ge; -90<br>&le; 90 | Uncorrected latitude as given in the source.
`origLong` | `decimal`<br>&ge; -270<br>&le; 180 | Uncorrected longitude as given in the source.
[comment](http://cldf.clld.org/v1.0/terms.rdf#comment) | `string` | 
`glottocode_comment` | `string` | Comment on the Glottocode assignment.
`region` | `string` | World Geographical Scheme for Recording Plant Distributions level2 region
`type` | `string`<br>Valid choices:<br> `society` `languoid` | 
`Language_Level_Glottocodes` | list of `string` (separated by ` `) | Glottocode(s) of the language-level languoid(s) in Glottolog associated with the languoid specified by Glottocode. Matches the "Glottocode" column for languages, but differs for dialects and lists all contained languages for subgroups. The language-level Glottocodes can be used to match societies to languages in the Glottolog classification trees.
[ISO639P3code](http://cldf.clld.org/v1.0/terms.rdf#iso639P3code) | `string` | 
[Contribution_ID](http://cldf.clld.org/v1.0/terms.rdf#contributionReference) | `string` | References [contributions.csv::ID](#table-contributionscsv)

## <a name="table-variablescsv"></a>Table [variables.csv](./variables.csv)

Variables are cultural features or practices, or environmental descriptors.

property | value
 --- | ---
[dc:conformsTo](http://purl.org/dc/terms/conformsTo) | [CLDF ParameterTable](http://cldf.clld.org/v1.0/terms.rdf#ParameterTable)
[dc:extent](http://purl.org/dc/terms/extent) | 2987


### Columns

Name/Property | Datatype | Description
 --- | --- | --- 
[ID](http://cldf.clld.org/v1.0/terms.rdf#id) | `string`<br>Regex: `[A-Za-z.0-9_]+([0-9]+)?` | Primary key
[Name](http://cldf.clld.org/v1.0/terms.rdf#name) | `string` | 
[Description](http://cldf.clld.org/v1.0/terms.rdf#description) | `string` | 
[ColumnSpec](http://cldf.clld.org/v1.0/terms.rdf#columnSpec) | `json` | 
`category` | list of `string`<br>Valid choices:<br> `Anthropometry` `Architecture` `Ceramics and Art` `Ceremony` `Childhood` `Class` `Climate` `Clothing` `Community` `Community organization` `Data Quality` `Death` `Demography` `Dwelling` `Dwellings` `Ecology` `Economics` `Economy` `Games` `Gender` `Gossip` `Health` `Household` `Housing` `Infancy` `Kinship` `Labor` `Labour` `Law and Judicial Process` `Leadership` `Life cycle` `Marriage` `Material culture` `Metalworking` `Modernization` `Mourning` `Physical Landscape` `Political Organization` `Politics` `Population` `Property` `Religion` `Ritual` `Settlement` `Settlements` `Sexual practices` `Social Organization and Stratification` `Special Knowledge and Practices` `Subsistence` `Technology` `Tools` `Utensils` `War` `Warfare` `Watercraft and Navigation` `Wealth Transactions` `Wealth transactions` `and Textiles` (separated by `, `) | 
`type` | `string`<br>Valid choices:<br> `Continuous` `Categorical` `Ordinal` | Variables may be categorical (and then must be accompanied by a list of possible ‘codes’, i.e. rows in Codetable. Variables can also be continuous (e.g. Population size) or ordinal. Ordinal variables are accompanied by a list of codes (like categorical variables). The order of codes is encoded as `ord` column in CodeTable.
`unit` | `string` | The unit of measurement
`source_comment` | `string` | A note about the source of this variable.
`changes` | `string` | Notes about how a variable may have been derived from the source.
[comment](http://cldf.clld.org/v1.0/terms.rdf#comment) | `string` | 
[Contribution_ID](http://cldf.clld.org/v1.0/terms.rdf#contributionReference) | `string` | References [contributions.csv::ID](#table-contributionscsv)

## <a name="table-codescsv"></a>Table [codes.csv](./codes.csv)

property | value
 --- | ---
[dc:conformsTo](http://purl.org/dc/terms/conformsTo) | [CLDF CodeTable](http://cldf.clld.org/v1.0/terms.rdf#CodeTable)
[dc:extent](http://purl.org/dc/terms/extent) | 15450


### Columns

Name/Property | Datatype | Description
 --- | --- | --- 
[ID](http://cldf.clld.org/v1.0/terms.rdf#id) | `string`<br>Regex: `[a-zA-Z0-9_\-]+` | Primary key
[Var_ID](http://cldf.clld.org/v1.0/terms.rdf#parameterReference) | `string` | The parameter or variable the code belongs to.<br>References [variables.csv::ID](#table-variablescsv)
[Name](http://cldf.clld.org/v1.0/terms.rdf#name) | `string` | 
[Description](http://cldf.clld.org/v1.0/terms.rdf#description) | `string` | 
`ord` | `integer` | 

## <a name="table-mediacsv"></a>Table [media.csv](./media.csv)

For better re-usability, D-PLACE provides the Glottolog classification trees and Phlorest phylogenies in the NEXUS file format.

property | value
 --- | ---
[dc:conformsTo](http://purl.org/dc/terms/conformsTo) | [CLDF MediaTable](http://cldf.clld.org/v1.0/terms.rdf#MediaTable)
[dc:extent](http://purl.org/dc/terms/extent) | 109


### Columns

Name/Property | Datatype | Description
 --- | --- | --- 
[ID](http://cldf.clld.org/v1.0/terms.rdf#id) | `string`<br>Regex: `[a-zA-Z0-9_\-]+` | Primary key
[Name](http://cldf.clld.org/v1.0/terms.rdf#name) | `string` | 
[Description](http://cldf.clld.org/v1.0/terms.rdf#description) | `string` | 
[Media_Type](http://cldf.clld.org/v1.0/terms.rdf#mediaType) | `string`<br>Regex: `[^/]+/.+` | 
[Download_URL](http://cldf.clld.org/v1.0/terms.rdf#downloadUrl) | `anyURI` | 
[Path_In_Zip](http://cldf.clld.org/v1.0/terms.rdf#pathInZip) | `string` | 

## <a name="table-contributionscsv"></a>Table [contributions.csv](./contributions.csv)

Both, individual D-PLACE datasets as well as Phlorest phylogenies and Glottolog classification trees are citable units - and should be cited, if their data is used.

property | value
 --- | ---
[dc:conformsTo](http://purl.org/dc/terms/conformsTo) | [CLDF ContributionTable](http://cldf.clld.org/v1.0/terms.rdf#ContributionTable)
[dc:extent](http://purl.org/dc/terms/extent) | 122


### Columns

Name/Property | Datatype | Description
 --- | --- | --- 
[ID](http://cldf.clld.org/v1.0/terms.rdf#id) | `string`<br>Regex: `[a-zA-Z0-9_\-]+` | Primary key
[Name](http://cldf.clld.org/v1.0/terms.rdf#name) | `string` | 
[Description](http://cldf.clld.org/v1.0/terms.rdf#description) | `string` | 
[Contributor](http://cldf.clld.org/v1.0/terms.rdf#contributor) | `string` | 
[Citation](http://cldf.clld.org/v1.0/terms.rdf#citation) | `string` | 
`DOI` | `string` | 
`type` | `string`<br>Valid choices:<br> `dataset` `phylogeny` | D-PLACE aggregates two kinds of data: D-PLACE datasets, i.e. lists variables and coded values for cultural groups and language phylogenies from Phlorest. 
[Source](http://cldf.clld.org/v1.0/terms.rdf#source) | list of `string` (separated by `;`) | References [sources.bib::BibTeX-key](./sources.bib)

## <a name="table-treescsv"></a>Table [trees.csv](./trees.csv)

D-PLACE contains the summary trees of Phlorest phylogenies and classification trees for Glottolog families which are associated with at least two societies in D-PLACE.

property | value
 --- | ---
[dc:conformsTo](http://purl.org/dc/terms/conformsTo) | [CLDF TreeTable](http://cldf.clld.org/v1.0/terms.rdf#TreeTable)
[dc:extent](http://purl.org/dc/terms/extent) | 109


### Columns

Name/Property | Datatype | Description
 --- | --- | --- 
[ID](http://cldf.clld.org/v1.0/terms.rdf#id) | `string`<br>Regex: `[a-zA-Z0-9_\-]+` | Primary key
[Name](http://cldf.clld.org/v1.0/terms.rdf#name) | `string` | Name of tree as used in the tree file, i.e. the tree label in a Nexus file or the 1-based index of the tree in a newick file
[Description](http://cldf.clld.org/v1.0/terms.rdf#description) | `string` | Describe the method that was used to create the tree, etc.
[Tree_Is_Rooted](http://cldf.clld.org/v1.0/terms.rdf#treeIsRooted) | `boolean`<br>Valid choices:<br> `Yes` `No` | Whether the tree is rooted (Yes) or unrooted (No) (or no info is available (null))
[Tree_Type](http://cldf.clld.org/v1.0/terms.rdf#treeType) | `string`<br>Valid choices:<br> `summary` `sample` | Whether the tree is a summary (or consensus) tree, i.e. can be analysed in isolation, or whether it is a sample, resulting from a method that creates multiple trees
[Tree_Branch_Length_Unit](http://cldf.clld.org/v1.0/terms.rdf#treeBranchLengthUnit) | `string`<br>Valid choices:<br> `change` `substitutions` `years` `centuries` `millennia` | The unit used to measure evolutionary time in phylogenetic trees.
[Media_ID](http://cldf.clld.org/v1.0/terms.rdf#mediaReference) | `string` | References a file containing a Newick representation of the tree, labeled with identifiers as described in the LanguageTable (the [Media_Type](https://cldf.clld.org/v1.0/terms.html#mediaType) column of this table should provide enough information to chose the appropriate tool to read the newick)<br>References [media.csv::ID](#table-mediacsv)
[Source](http://cldf.clld.org/v1.0/terms.rdf#source) | list of `string` (separated by `;`) | References [sources.bib::BibTeX-key](./sources.bib)
[Contribution_ID](http://cldf.clld.org/v1.0/terms.rdf#contributionReference) | `string` | References [contributions.csv::ID](#table-contributionscsv)

