

library(gtsummary)

explanatory_vars <- xx %>% dplyr::select("je_status", "age_cat", "sex", "always_in_vill", "travel_6m","travel_30d","travel_7d",
                                  "electricity","piped_water", "sanitation","n_rooms", "hh_type", "education",
                                  "ducks_hh",  "pigeon_hh","goat", "cow", "sheep", "buffalo",
                                  "ducks_vill", "pigeon_vill", "migratorybird","dist.h.pig", "npigs" ,
                                 "pigs_hh", "pig_herd", "pig_vill", "pigs_community", "npigs",
                                  "presence_cx_quinquefasciatus", "presence_cx_tritaeniorhynchus", "presence_cx_vishnui", "presence_cx_pseudovishnui",  
                                  "presence_cx_fuscocephala", "presence_cx_gelidus", "presence_cx_bitaeniorhynchus", "presence_ar_subalvatus", 
                                  "presence_ae_albopictus", "presence_ae_vexans", "pop" )



# communities and households DUCKS ownership
length(unique(xx$hhid[xx$ducks_hh == 1]))
length(unique(xx$vill_id[xx$ducks_hh == 1])) # all communities

length(unique(xx$hhid[xx$ducks_hh == 1]))/length(unique(xx$hhid))

# communities and households PIGEON ownership
length(unique(xx$hhid[xx$pigeon_hh == 1]))
length(unique(xx$vill_id[xx$pigeon_hh == 1])) # all communities

length(unique(xx$hhid[xx$pigeon_hh == 1]))/length(unique(xx$hhid))

aggregate(xx$npigs, list(xx$je_status), FUN=mean) 
aggregate(xx$npigs, list(xx$je_status), FUN=summary) 


table1 <- 
  tbl_summary(
    explanatory_vars,
    by = je_status,
   type = list(npigs ~ "continuous2")) %>%
  #add_n() %>% 
  add_overall() %>% 
  add_p() %>% 
  modify_header(label = "**Variable**") %>% 
  bold_labels() 

write.csv(table1, "table1_01052024.csv")

univ_tab <- xx %>% 
  dplyr::select(vars, seroposenr) %>%
  tbl_uvregression(                         
    method = glm,                           
    y = seroposenr,                           
    method.args = list(family = binomial),  
    exponentiate = TRUE) 
