

coords_home <- xx[,c("x_proj","y_proj")] 
coords.sp <- as.matrix(as.data.frame(coords_home))
bnd <- inla.nonconvex.hull(coords.sp,convex=-0.1)
mesh <- inla.mesh.2d(boundary = bnd, max.edge=c(50,100))
spde <- inla.spde2.matern(mesh=mesh, alpha=2)
A <- inla.spde.make.A(mesh=mesh, loc=as.matrix(xx[,c("x_proj","y_proj")]))
s.index <- inla.spde.make.index(name="spatial.field",n.spde=spde$n.spde)

dp <- rasterToPoints(raj_pop)
dim(dp)
colnames(dp) <- c("x", "y", "pop")
coop <- dp[, c("x", "y")]
colnames(coop) <- c("X", "Y")
attr(coop,"projection")<-"LL"
coop <- convUL(coop)
Ap <- inla.spde.make.A(mesh = mesh, loc = as.matrix(coop))

#CONVERT POINTS DATA TO EN
social<-readShapeSpatial("pig data/All_gis_je_social.shp")
pig.coords<-social@coords
colnames(pig.coords)<-c("X","Y")
attr(pig.coords,"projection")<-"LL"
pigs<-convUL(pig.coords)

coop$dist.pig<-get.knnx(pigs,cbind(coop$X,coop$Y),k=1)$nn.dist[,1]
coop$pigWithinDist<-ifelse(coop$dist.pig <1, 1, 0)

npigs<-1000
map.to.p.dist2<-get.knnx(pigs,cbind(coop$X,coop$Y),k=npigs)$nn.dist[,1:npigs]
distThresh<-5
coop$npigs<-apply(map.to.p.dist2,1,function(x)sum(x<distThresh))
coop$npigs <- as.numeric(coop$npigs)

## Cut point UPR
xx$je_status_upr <- as.numeric(xx$je_status_upr)

n.data = nrow(xx)
n.covariates = 2
covar <- xx$npigs
X = cbind(rep(1,n.data),covar)
Q = qr.Q(qr(X))

A <- inla.spde.make.A(mesh = mesh, loc = as.matrix(xx[1:n.data, c("x_proj", "y_proj")]))

abx <- model.matrix(~age2+npigs, xx)[, -1]

stk.e <- inla.stack(
  data = list(y = xx[1:n.data,"je_status_upr"]),
  A = list(A, 1),
  effects = list(s.index, data.frame(Intercept=1,abx)),
  tag = 'est')


stk.p <- inla.stack(
  tag = "pred",
  data = list(y = NA),
  A = list(1, Ap), 
  effects = list(data.frame(Intercept = 1, age2 = rep(1, nrow(coop)), npigs = coop$npigs), s = s.index))


stk.full <- inla.stack(stk.e, stk.p)

formula2 <- y ~ -1 + Intercept + offset(log(age2)) + npigs + f(spatial.field, model=spde, extraconstr = list(A = as.matrix(t(Q)%*%A), e= rep(0,n.covariates)))

res.2 <- inla(
  formula2,
  data = inla.stack.data(stk.full),
  family = "binomial",
  control.family = list(link = "cloglog"),
  control.predictor = list(compute = TRUE,link = 1, A = inla.stack.A(stk.full)),
  control.compute= list(dic = TRUE, config=T),
  verbose=T)


age_vect = c(4.5, 14.5, 24.5, 34.5, 38, 38, 38)

foi_mean <- exp(res.2$summary.fixed[1,4])
foi_upr <- exp(res.2$summary.fixed[1,5])
foi_lwr <- exp(res.2$summary.fixed[1,3])

fit_age_spatial_2 =1-exp(-(foi_mean)*age_vect)
fit_age.loci_spatial_2 =1-exp(-(foi_lwr)*age_vect)
fit_age.hici_spatial_2 =1-exp(-(foi_upr)*age_vect)

prop_by_age_2 = tapply(xx$je_status_upr, xx$age_cat, mean)
length_age_2 = tapply(xx$je_status_upr, xx$age_cat, length)
ci_asym_2 = Hmisc::binconf(x=c(prop_by_age_2*length_age_2), n=c(length_age_2))
ci_asym_2 <- as.data.frame(ci_asym_2)

prop_by_age_2 = xx %>% 
  group_by(age_cat) %>% 
  summarise(je_status_upr=(mean(je_status_upr)))

prop_by_age_2 = cbind(prop_by_age_2, ci_asym_2)


(B.3 <- ggplot(data=prop_by_age_2, aes(x=age_cat, y=je_status_upr, group =1)) +
    theme_classic() +
    theme(legend.position = "bottom", legend.spacing.y = unit(0.05, 'cm'))+
    labs(x="Age (years)", y = "Seroprevalence")+
    #geom_bar(stat="identity", position=position_dodge(), fill = "darkslategray4")+
    geom_line(aes(y=fit_age_spatial_2, color = "Model"), linewidth = 0.5) +
    geom_ribbon(aes(ymin = fit_age.loci_spatial_2, ymax = fit_age.hici_spatial_2, fill = "Confidence Interval"), alpha = 0.4)+
    geom_pointrange(aes(x=age_cat, y=PointEst, ymin=Upper, ymax=Lower, linetype = "Data")) +
    ylim(0, 0.35)+
    scale_linetype_discrete(name = "") +
    scale_colour_manual(name = "", values = c("Model" = "red4")) +
    scale_fill_manual(name = "",  values = c("Confidence Interval" = "red4")) +
    theme(axis.title.x = element_text(size=20, family = "Times"), axis.text.x = element_text(angle=0, size=15, family = "Times")) +
    theme(axis.title.y = element_text(size=20, family = "Times"), axis.text.y = element_text(angle=0, size=15, family = "Times")) +
    theme(legend.text = element_text(size = 12, family = "Times" ), legend.key.size = unit(0.4, "cm")) )



######## CUT OFF LWR

xx$je_status_lwr <- as.numeric(xx$je_status_lwr)

stk.e <- inla.stack(
  data = list(y = xx[1:n.data,"je_status_lwr"]),
  A = list(A, 1),
  effects = list(s.index, data.frame(Intercept=1,abx)),
  tag = 'est')


stk.p <- inla.stack(
  tag = "pred",
  data = list(y = NA),
  A = list(1, Ap), 
  effects = list(data.frame(Intercept = 1, age2 = rep(1, nrow(coop)), npigs = coop$npigs), s = s.index))


stk.full <- inla.stack(stk.e, stk.p)

formula <- y ~ -1 + Intercept + offset(log(age2)) + npigs + f(spatial.field, model=spde, extraconstr = list(A = as.matrix(t(Q)%*%A), e= rep(0,n.covariates)))

res.3 <- inla(
  formula,
  data = inla.stack.data(stk.full),
  family = "binomial",
  control.family = list(link = "cloglog"),
  control.predictor = list(link =1, compute = TRUE, A = inla.stack.A(stk.full)),
  control.compute= list(dic = TRUE, config=T),
  verbose=T)


age_vect = c(4.5, 14.5, 24.5, 34.5, 38, 38, 38)

foi_mean <- exp(res.3$summary.fixed[1,4])
foi_upr <- exp(res.3$summary.fixed[1,5])
foi_lwr <- exp(res.3$summary.fixed[1,3])


fit_age_spatial_3 = 1-exp(-(foi_mean)*age_vect)
fit_age.loci_spatial_3 =1-exp(-(foi_lwr)*age_vect)
fit_age.hici_spatial_3 =1-exp(-(foi_upr)*age_vect)

prop_by_age_3 = tapply(xx$je_status_lwr, xx$age_cat, mean)
length_age_3 = tapply(xx$je_status_lwr, xx$age_cat, length)
ci_asym_3 = Hmisc::binconf(x=c(prop_by_age_3*length_age_3), n=c(length_age_3))
ci_asym_3 <- as.data.frame(ci_asym_3)

prop_by_age_3 = xx %>% 
  group_by(age_cat) %>% 
  summarise(je_status_lwr=(mean(je_status_lwr)))

prop_by_age_3 = cbind(prop_by_age_3, ci_asym_3)


(B.1 <- ggplot(data=prop_by_age_3, aes(x=age_cat, y=je_status_lwr, group =1)) +
    theme_classic() +
    theme(legend.position = "bottom")+
    labs(x="Age (years)", y = "Seroprevalence")+
    geom_line(aes(y=fit_age_spatial_3, color = "Model"), linewidth = 0.5) +
    geom_ribbon(aes(ymin = fit_age.loci_spatial_3, ymax = fit_age.hici_spatial_3, fill = "Confidence Interval"), alpha = 0.4)+
    geom_pointrange(aes(x=age_cat, y=PointEst, ymin=Upper, ymax=Lower, linetype = "Data")) +
    ylim(0, 0.6)+
    scale_linetype_discrete(name = "") +
    scale_colour_manual(name = "", values = c("Model" = "darkgreen")) +
    scale_fill_manual(name = "",  values = c("Confidence Interval" = "darkgreen")) +
    theme(axis.title.x = element_text(size=20, family = "Times"), axis.text.x = element_text(angle=0, size=15, family = "Times")) +
    theme(axis.title.y = element_text(size=20, family = "Times"), axis.text.y = element_text(angle=0, size=15, family = "Times")) +
    theme(legend.text = element_text(size = 12, family = "Times"), legend.key.size = unit(0.4, "cm")) )

(B.2 <- ggplot(data=prop_by_age, aes(x=age_cat, y=je_status, group =1)) +
    theme_classic() +
    theme(legend.position = "bottom", legend.spacing.y = unit(0.05, 'cm'))+
    labs(x="Age (years)", y = "Seroprevalence")+
    #geom_bar(stat="identity", position=position_dodge(), fill = "darkslategray4")+
    geom_line(aes(y=fit_age_spatial, color = "Model"), linewidth = 0.5) +
    geom_ribbon(aes(ymin = fit_age.hici_spatial, ymax = fit_age.loci_spatial, fill = "Confidence Interval"), alpha = 0.4)+
    geom_pointrange(aes(x=age_cat, y=PointEst, ymin=Upper, ymax=Lower, linetype = "Data")) +
    ylim(0, 0.4)+
    scale_linetype_discrete(name = "") +
    scale_colour_manual(name = "", values = c("Model" = "#63a6a0")) +
    scale_fill_manual(name = "",  values = c("Confidence Interval" = "#63a6a0")) +
    theme(axis.title.x = element_text(size=20, family = "Times"), axis.text.x = element_text(angle=0, size=15, family = "Times")) +
    theme(axis.title.y = element_text(size=20, family = "Times"), axis.text.y = element_text(angle=0, size=15, family = "Times")) +
    theme(legend.text = element_text(size = 12, family = "Times" ), legend.key.size = unit(0.4, "cm")) )


plot_grid( B.1,B.2, B.3, nrow=1, labels = "AUTO")

(A.1 <- ggplot() +
  geom_histogram(
    aes(x = xx$je, fill = factor(xx$je_status)),
    bins = 50,        
    binwidth = 0.2     
  ) +
  theme_classic() +
  scale_fill_manual(values = c("0" = "#0d585f", "1" = "#63a6a0")) +
  labs(
    x = "Titer",
    y = "Count",
    title = "Seropositivity cut-off >=3",
    fill = "" ) +
    geom_vline(xintercept=3, linetype = "dashed")+
  guides(fill = FALSE)+
    theme(axis.title.x = element_text(size=20, family = "Times"), axis.text.x = element_text(angle=0, size=15, family = "Times")) +
    theme(axis.title.y = element_text(size=20, family = "Times"), axis.text.y = element_text(angle=0, size=15, family = "Times")) +
    theme(title = element_text(size = 15, family = "Times")) )


(A.2 <- ggplot() +
  geom_histogram(
    aes(x = xx$je, fill = factor(xx$je_status_upr)),
    bins = 50,        
    binwidth = 0.2     
  ) +
  theme_classic() +
    scale_fill_manual(values = c("0" = "red4", "1" = "lightsalmon")) +
  labs(
    x = "Titer",
    y = "Count",
    title = "Seropositivity cut-off >=4",
    fill = ""
  )+
    geom_vline(xintercept=4, linetype = "dashed")+
  guides(fill = FALSE) +
    theme(axis.title.x = element_text(size=20, family = "Times"), axis.text.x = element_text(angle=0, size=15, family = "Times")) +
    theme(axis.title.y = element_text(size=20, family = "Times"), axis.text.y = element_text(angle=0, size=15, family = "Times")) +
    theme(title = element_text(size = 15, family = "Times")) )

(A.3 <- ggplot() +
    geom_histogram(
      aes(x = xx$je, fill = factor(xx$je_status_lwr)),
      bins = 50,        
      binwidth = 0.2     
    ) +
    theme_classic() +
    scale_fill_manual(values = c("0" = "darkgreen", "1" = "lightgreen")) +
    labs(
      x = "Titer",
      y = "Count",
      title = "Seropositivity cut-off >=2.0",
      fill = ""
    )+
    guides(fill = FALSE) +
    geom_vline(xintercept=2, linetype = "dashed")+
    theme(axis.title.x = element_text(size=20, family = "Times"), axis.text.x = element_text(angle=0, size=15, family = "Times")) +
    theme(axis.title.y = element_text(size=20, family = "Times"), axis.text.y = element_text(angle=0, size=15, family = "Times")) +
    theme(title = element_text(size = 15, family = "Times")) )

plot_grid( A.2, A.1, A.3, B.1, B.2, B.3,
           nrow=2, labels = c("A", "B", "C"))


