

##### MV with constraints

covariates <- c("sex", "always_in_vill", "travel_6m","travel_30d","travel_7d",
                "electricity","piped_water", "sanitation","n_rooms",
                "current_employment",
                "ducks_hh",  "pigeon_hh","goat", "cow", "sheep", "buffalo",
                "ducks_vill", "pigeon_vill", "migratorybird", "npigs",
                "presence_cx_quinquefasciatus", "presence_cx_tritaeniorhynchus", "presence_cx_vishnui", "presence_cx_pseudovishnui",  
                "presence_cx_fuscocephala", "presence_cx_gelidus", "presence_cx_bitaeniorhynchus", "presence_ar_subalvatus", 
                "presence_ae_albopictus", "presence_ae_vexans", "pop" )

covariates <- c( "npigs",
                 "presence_ae_vexans" , "pop")

# mod<-glm(xx$je_status~xx$presence_cx_quinquefasciatus+xx$age2,family="binomial")


# random_cov <- c("hh_type", "education", "hh_income")
# 
# add_cov_random <- vector("list", length(random_cov))
# 
# for (i in seq_along(random_cov)) {
#   if (random_cov[i] == "hh_type"){# hh type
#     xx$hh_type = as.factor(xx$hh_type)
#     add_cov_random[[i]] <-"f(hh_type, model='iid', constr = F, extraconstr = list(A=matrix(c(1e4,rep(1,length(unique(xx$hh_type))-2)), nrow=1), e=rep(0,1)))"}
# 
#   else if(random_cov[i] == "education"){# education
#     xx$education = as.factor(xx$education)
#     add_cov_random[[i]] <-"f(education, model='iid', constr = F, extraconstr = list(A=matrix(c(1e4,rep(1,length(unique(xx$education))-2)), nrow=1), e=rep(0,1)))"}
# 
#   else if(random_cov[i] == "hh_income"){# hh income
#     xx$hh_income = as.factor(xx$hh_income)
#     add_cov_random[[i]] <-"f(hh_income, model='iid', constr = F, extraconstr = list(A=matrix(c(1e4,rep(1,length(unique(xx$hh_income))-2)), nrow=1), e=rep(0,1)))"}
# }

# boundary <- inla.nonconvex.hull(cbind(xx$x_proj,xx$y_proj),convex=-0.1)
# mesh <- inla.mesh.2d(boundary = boundary,offset=c(-0.05, -0.1), max.edge=c(50,100))
# spde <- inla.spde2.matern(mesh=mesh, alpha=2)
# s.index <- inla.spde.make.index("spatial.field", spde$n.spde)

covariate_data <- na.omit(xx[, c("age2", covariates)])
n.data <- nrow(covariate_data)
n.covariates <- length(covariates)
X <- cbind(rep(1, n.data), covariate_data)
Q <- qr.Q(qr(X))

A <- inla.spde.make.A(mesh = mesh, loc = as.matrix(xx[1:n.data, c("x_proj", "y_proj")]))

abx <- model.matrix(~ age2 + ., data = as.data.frame(covariate_data))[, -1]


stack.est_mv <- inla.stack(
  data = list(je_status = xx[1:n.data,"je_status"]),
  A = list(A, 1,1),
  effects = list(s.index, data.frame(Intercept=1,abx), list(xx[1:n.data, which(names(xx) != "je_status")])),
  tag = 'stdata'
)


formula_multivariable_all <- as.formula(paste("je_status ~ -1 + age2 + Intercept +f(spatial.field, model=spde, extraconstr = list(A = as.matrix(t(Q) %*% A), e = rep(0, n.covariates+2))) +", 
                                              paste(covariates, collapse = " + ")))

#  , "+" ,paste(add_cov_random, collapse = "+")))


# Fit the multivariable model with both fixed and random effects
output_mv <- inla(
  formula_multivariable_all,
  data = inla.stack.data(stack.est_mv, spde=spde),
  family = "binomial",
  control.compute = list(dic = TRUE, cpo= T, po = T),
  control.inla=list(strategy = "laplace", int.strategy = "grid", diff.logdens = 4, npoints = 21),
  control.predictor = list(compute = TRUE,link = 1, A = inla.stack.A(stack.est_mv)),
  # control.fixed = list(expand.factor.strategy = "inla"),
  verbose = FALSE
)

output_mv$dic$dic
exp(output_mv$summary.fixed)

exp(output_mv$summary.fixed[-c(1:2), c("mean", "0.025quant", "0.975quant")])


check <- inla.cpo(output_mv, force=T)

# results_mv <- exp(output_mv$summary.fixed[-1, c("mean", "0.025quant", "0.975quant")])
# write.csv(results_mv, "results_mv.csv")

exp(output_mv$summary.random[[3]][, c("mean", "0.025quant", "0.975quant")])
exp(output_mv$summary.random[[4]][, c("mean", "0.025quant", "0.975quant")])
exp(output_mv$summary.random[[5]][, c("mean", "0.025quant", "0.975quant")])
