
setwd("~/Desktop/JED/univariate")

covariates <- c("sex", "always_in_vill", "travel_6m","travel_30d","travel_7d",
                "electricity","piped_water", "sanitation","n_rooms",
                "ducks_hh",  "pigeon_hh","goat", "cow", "sheep", "buffalo",
                "ducks_vill", "pigeon_vill", "migratorybird","dist.h.pig", "npigs", "pigWithinDist", 
                "presence_cx_quinquefasciatus", "presence_cx_tritaeniorhynchus", "presence_cx_vishnui", "presence_cx_pseudovishnui",  
                "presence_cx_fuscocephala", "presence_cx_gelidus", "presence_cx_bitaeniorhynchus", "presence_ar_subalvatus", 
                "presence_ae_albopictus", "presence_ae_vexans", "pop" )

random_cov <- c("hh_type", "education", "hh_income")

add_cov_random <- vector("list", length(random_cov))

for (i in seq_along(random_cov)) {
  if (random_cov[i] == "hh_type"){# hh type
    xx$hh_type = as.factor(xx$hh_type)
    add_cov_random[[i]] <-"f(hh_type, model='iid', constr = F, extraconstr = list(A=matrix(c(1e4,rep(1,length(unique(xx$hh_type))-2)), nrow=1), e=rep(0,1)))"}
  
  else if(random_cov[i] == "education"){# education
    xx$education = as.factor(xx$education)
    add_cov_random[[i]] <-"f(education, model='iid', constr = F, extraconstr = list(A=matrix(c(1e4,rep(1,length(unique(xx$education))-2)), nrow=1), e=rep(0,1)))"}
  
  else if(random_cov[i] == "hh_income"){# hh income
    xx$hh_income = as.factor(xx$hh_income)
    add_cov_random[[i]] <-"f(hh_income, model='iid', constr = F, extraconstr = list(A=matrix(c(1e4,rep(1,length(unique(xx$hh_income))-2)), nrow=1), e=rep(0,1)))"}
}


boundary <- inla.nonconvex.hull(cbind(xx$x_proj,xx$y_proj),convex=-0.1)
mesh <- inla.mesh.2d(boundary = boundary,offset=c(-0.05, -0.1), max.edge=c(50,100))
spde <- inla.spde2.matern(mesh=mesh, alpha=2)
# A.est <- inla.spde.make.A(mesh=mesh, loc=cbind(cbind(xx$x_proj,xx$y_proj)))
s.index <- inla.spde.make.index("spatial.field", spde$n.spde)


########
# MODEL UNI SPATIAL ABX
##########

results_m2 <- list()

for (i in seq_along(covariates)) {

  covariate_name <- covariates[i]
  covariate_data <- na.omit(xx[[covariate_name]])
  n.data <- length(covariate_data)
  n.covariates <- 2
  X <- cbind(rep(1, n.data), covariate_data)
  Q <- qr.Q(qr(X))
  
  A <- inla.spde.make.A(mesh = mesh, loc = as.matrix(xx[1:n.data, c("x_proj", "y_proj")]))
  
  formula2 <-as.formula(paste0("je_status ~ -1 + Intercept + f(spatial.field, model=spde, extraconstr = list(A = as.matrix(t(Q) %*% A), e = rep(0, n.covariates))) + ", covariates[i]))
  
  print(i)
  
  abx <- model.matrix(~xx[[covariates[i]]], xx)[, -1]

  stack.est <- inla.stack(
    data = list(je_status = xx[1:n.data,"je_status"]),
    A = list(A, 1,1),
    effects = list(s.index, data.frame(Intercept=1,abx), list(xx[1:n.data, which(names(xx) != "je_status")])),
    tag = 'stdata'
  )
  #
  # stack.est <- inla.stack(
  #   data = list(je_status = xx[1:n.data,"je_status"]),
  #   A = list(A, 1),
  #   effects = list(c(s.index, list(Intercept = 1)), list(xx[1:n.data, which(names(xx) != "je_status")])),
  #   tag = 'stdata')
  # 
  
  output_m2 <- inla(
    formula2,
    data = inla.stack.data(stack.est, spde=spde),
    family = "binomial", 
    control.compute = list(dic = TRUE),
    control.predictor = list(A = inla.stack.A(stack.est), compute = TRUE, link =1),
    verbose = FALSE
  )
  
  posterior_fixed_m2 <- cbind(data.frame(output_m2$summary.fixed[, c("mean", "0.025quant", "0.975quant")]))
  file_name_m2 <- paste0("univariate_m2_", covariates[i], ".RData")
  results_m2[[i]] <- posterior_fixed_m2
  save(output_m2, posterior_fixed_m2, file = file_name_m2)
}


posterior_list_m2 <- list()
for (i in seq_along(covariates)) {
  file_name <- paste0("univariate_m2_",covariates[i],".RData")
  load(file_name)
  posterior_fixed_m2 <- cbind(data.frame(covariate=i),output_m2$summary.fixed[,c("mean","0.025quant","0.975quant")],output_m2$dic$dic )
  posterior_list_m2[[i]] <- posterior_fixed_m2
}

posterior_table_m2 <- bind_rows(posterior_list_m2)
posterior_table_m2 <- posterior_table_m2[c(2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64),]
posterior_table_m2 <- as.data.frame(posterior_table_m2[,-1])
posterior_table_m2$covariate <- rownames(posterior_table_m2)
colnames(posterior_table_m2) <- c("estimate", "CI_1", "CI_2", "dic", "covariate")
posterior_table_m2 <- posterior_table_m2[,c(5,1,2,3, 4)]

results_m2_random <- list()
for (i in seq_along(random_cov)) {
  formula2_random <-as.formula(paste0("je_status ~ -1 + Intercept + age2 + f(spatial.field, model=spde)+ ", add_cov_random[i]))
  print(i)
  
  A <- inla.spde.make.A(mesh = mesh, loc = as.matrix(xx[, c("x_proj", "y_proj")]))
  
  stack.est = inla.stack(data=list(je_status=xx$je_status),
                         A=list(A,1),
                         effects=list(c(s.index, list(Intercept=1)),list(xx[,which(names(xx)!= "je_status")])),
                         tag='stdata')
  
  output_m2_random <- inla(
    formula2_random,
    data = inla.stack.data(stack.est),
    family = "binomial",
    control.compute = list(dic = TRUE),
    control.predictor = list(A = inla.stack.A(stack.est), compute = TRUE, link =1),
    verbose = F
  )
  
  posterior_random_m2 <- cbind(data.frame(output_m2_random$summary.random[[random_cov[i]]][, c(1, 2, 4, 6)]))
  file_name_m2 <- paste0("univariate_m2_random_",random_cov[i],".RData")
  results_m2_random[[i]] <- posterior_random_m2
  save(output_m2_random, posterior_random_m2, file = file_name_m2)
}

posterior_list_random_m2 <- list()
for (i in seq_along(random_cov)) {
  file_name <- paste0("univariate_m2_random_",random_cov[i],".RData")
  load(file_name)
  posterior_random_m2 <- cbind(data.frame(random_cov = random_cov[i], 
                                          output_m2_random$summary.random[[2]][, c("mean", "0.025quant", "0.975quant")],
                                          output_m2_random$dic$dic))
  
  posterior_list_random_m2[[i]] <- posterior_random_m2
}

posterior_list_random_m2 <- bind_rows(posterior_list_random_m2)
colnames(posterior_list_random_m2) <- c("covariate","estimate", "CI_1", "CI_2", "dic")



m2 <- rbind(posterior_table_m2,posterior_list_random_m2)
rownames(m2) <- 1:nrow(m2)
m2[,2:4] <- exp(m2[,2:4])
print(m2)

write.csv(m2, "univariate.csv")


