

dat<-read.csv("lumi.csv")
xx<-read.csv("xx.csv")

### Add in JE result
cutpoint<-3
tmp<-match(xx$ParticpantID,dat$ID)
xx$JE<-(dat$JE3/dat$CTRL)[tmp]
xx$JEStatus<-(dat$JE3/dat$CTRL)[tmp]>cutpoint

xx$DENV1status<-(dat$DEN1/dat$CTRL)[tmp]>cutpoint
xx$DENV2status<-(dat$DEN2/dat$CTRL)[tmp]>cutpoint
xx$DENV3status<-(dat$DEN3/dat$CTRL)[tmp]>cutpoint
xx$DENV4status<-(dat$DEN4/dat$CTRL)[tmp]>cutpoint


den_values <- cbind(dat$DEN1, dat$DEN2, dat$DEN3, dat$DEN4) / dat$CTRL
xx$DENVstatus <- apply(den_values[tmp, ], 1, function(x) any(x > cutpoint))

xx<-xx[which(xx$JEStatus>=0),]

Hmisc::binconf(x=c(mean(xx$DENVstatus)*1455), n=c(1455))
Hmisc::binconf(x=c(mean(xx$DENV1status)*1455), n=c(1455))
Hmisc::binconf(x=c(mean(xx$DENV2status)*1455), n=c(1455))
Hmisc::binconf(x=c(mean(xx$DENV3status)*1455), n=c(1455))
Hmisc::binconf(x=c(mean(xx$DENV4status)*1455), n=c(1455))


ggplot(data = xx) +
  geom_point(aes(x = PanbioUnit, y = log(JE))) +
  labs(x = "DENV PanBio unit", y = "JEV luminex (log)") 

xx$ave_seropositive_denv1 <- ave(xx$DENV1status, xx$vill.id, FUN = function(x) mean(x))*100
xx$ave_seropositive_denv1_cat <-  cut(xx$ave_seropositive_denv1, breaks = c(-Inf, 5, 10, 20 , 30, 40, Inf), labels = c("<5%", "5-10%","10-20%", "20-30%", "30-40%", ">40%"))

xx$ave_seropositive_denv2 <- ave(xx$DENV2status, xx$vill.id, FUN = function(x) mean(x))*100
xx$ave_seropositive_denv2_cat <-  cut(xx$ave_seropositive_denv2, breaks = c(-Inf, 5, 10, 20 , 30, 40, Inf), labels = c("<5%", "5-10%","10-20%", "20-30%", "30-40%", ">40%"))

xx$ave_seropositive_denv3 <- ave(xx$DENV3status, xx$vill.id, FUN = function(x) mean(x))*100
xx$ave_seropositive_denv3_cat <-  cut(xx$ave_seropositive_denv3, breaks = c(-Inf, 5, 10, 20 , 30, 40, Inf), labels = c("<5%", "5-10%","10-20%", "20-30%", "30-40%", ">40%"))

xx$ave_seropositive_denv4 <- ave(xx$DENV4status, xx$vill.id, FUN = function(x) mean(x))*100
xx$ave_seropositive_denv4_cat <-  cut(xx$ave_seropositive_denv4, breaks = c(-Inf, 5, 10, 20 , 30, 40, Inf), labels = c("<5%", "5-10%","10-20%", "20-30%", "30-40%", ">40%"))

xx$ave_seropositive_denv <- ave(xx$DENVstatus, xx$vill.id, FUN = function(x) mean(x))*100
xx$ave_seropositive_denv_cat <-  cut(xx$ave_seropositive_denv, breaks = c(-Inf, 5, 10, 20 , 30, 40, 50,Inf), labels = c("<5%", "5-10%","10-20%", "20-30%", "30-40%", "40%-50%", ">50%"))



(fig_denv1 <- ggplot() + 
  geom_sf(data = raj, fill = "white") +
  geom_point(data = xx, aes(x = qgpslong, y = qgpslat, color = ave_seropositive_denv1_cat), shape=20, size = 8) +
  scale_color_carto_d(palette = "Geyser")+
  theme_map() +
  annotation_north_arrow(which_north = "true", height = unit(1, "cm"),width = unit(1, "cm"), location = "tl") +
  annotation_scale()+
  guides(color = guide_legend(reverse = TRUE)) +
  theme(legend.position= c(1, 0.3), legend.text = element_text(size = 20,  family = "Times"), legend.title = element_text(size =20,  family = "Times"),
        legend.key.width=unit(0.5, "cm"), legend.key.height = unit(0.6,"cm"), legend.direction = "vertical") +
  labs(x = "", y = "", color='DENV1 IgG+') )


(fig_denv2 <- ggplot() + 
    geom_sf(data = raj, fill = "white") +
    geom_point(data = xx, aes(x = qgpslong, y = qgpslat, color = ave_seropositive_denv2_cat), shape=20, size = 8) +
    scale_color_carto_d(palette = "Geyser")+
    theme_map() +
    annotation_north_arrow(which_north = "true", height = unit(1, "cm"),width = unit(1, "cm"), location = "tl") +
    annotation_scale()+
    guides(color = guide_legend(reverse = TRUE)) +
    theme(legend.position= c(1, 0.3), legend.text = element_text(size = 20,  family = "Times"), legend.title = element_text(size =20,  family = "Times"),
          legend.key.width=unit(0.5, "cm"), legend.key.height = unit(0.6,"cm"), legend.direction = "vertical") +
    labs(x = "", y = "", color='DENV2 IgG+') )

(fig_denv3 <- ggplot() + 
    geom_sf(data = raj, fill = "white") +
    geom_point(data = xx, aes(x = qgpslong, y = qgpslat, color = ave_seropositive_denv3_cat), shape=20, size = 8) +
    scale_color_carto_d(palette = "Geyser")+
    theme_map() +
    annotation_north_arrow(which_north = "true", height = unit(1, "cm"),width = unit(1, "cm"), location = "tl") +
    annotation_scale()+
    guides(color = guide_legend(reverse = TRUE)) +
    theme(legend.position= c(1, 0.3), legend.text = element_text(size = 20,  family = "Times"), legend.title = element_text(size =20,  family = "Times"),
          legend.key.width=unit(0.5, "cm"), legend.key.height = unit(0.6,"cm"), legend.direction = "vertical") +
    labs(x = "", y = "", color='DENV3 IgG+') )

(fig_denv4 <- ggplot() + 
    geom_sf(data = raj, fill = "white") +
    geom_point(data = xx, aes(x = qgpslong, y = qgpslat, color = ave_seropositive_denv4_cat), shape=20, size = 8) +
    scale_color_carto_d(palette = "Geyser")+
    theme_map() +
    annotation_north_arrow(which_north = "true", height = unit(1, "cm"),width = unit(1, "cm"), location = "tl") +
    annotation_scale()+
    guides(color = guide_legend(reverse = TRUE)) +
    theme(legend.position= c(1, 0.3), legend.text = element_text(size = 20,  family = "Times"), legend.title = element_text(size =20,  family = "Times"),
          legend.key.width=unit(0.5, "cm"), legend.key.height = unit(0.6,"cm"), legend.direction = "vertical") +
    labs(x = "", y = "", color='DENV4 IgG+') )


plot_grid(fig_denv1, fig_denv2 , fig_denv3 , fig_denv4, labels = "AUTO")

(fig_denv <- ggplot() + 
    geom_sf(data = raj, fill = "white") +
    geom_point(data = xx, aes(x = qgpslong, y = qgpslat, color = ave_seropositive_denv_cat), shape=20, size = 8) +
    scale_color_carto_d(palette = "Geyser")+
    theme_map() +
    annotation_north_arrow(which_north = "true", height = unit(1, "cm"),width = unit(1, "cm"), location = "tl") +
    annotation_scale()+
    guides(color = guide_legend(reverse = TRUE)) +
    theme(legend.position= c(1, 0.3), legend.text = element_text(size = 20,  family = "Times"), legend.title = element_text(size =20,  family = "Times"),
          legend.key.width=unit(0.5, "cm"), legend.key.height = unit(0.6,"cm"), legend.direction = "vertical") +
    labs(x = "", y = "", color='DENV IgG+') )



# PanBio vs Luminex

cor.test(xx$PanbioUnit, xx$JE, method = "pearson")

xx$denv_panbio<-xx$PanbioUnit>10

table(xx$denv_panbio, xx$JEStatus)

table(xx$DENVstatus, xx$JEStatus)

conting_table <- xtabs(~ JEStatus + denv_panbio, data = xx)

xtabs(~ JEStatus + denv_panbio, data = xx)
xtabs(~ JEStatus + DENVstatus, data = xx)


xx_filtered <- xx %>%
  filter(!is.na(JEStatus) & !is.na(denv_panbio))


ggplot(data = xx_filtered) +
  geom_mosaic(aes(x = product(JEStatus), fill = denv_panbio)) +
  geom_mosaic_text(aes(x = product(JEStatus, denv_panbio), label = after_stat(.wt)), as.label = TRUE, check_overlap = TRUE) +
  labs(fill = "", x = "DENV PanBio unit", y = "JEV luminex") +
  scale_fill_manual(values =c("grey80", "grey80"))+
  theme_classic()+
  theme(legend.position = "none")
 
ggplot(data = xx_filtered) +
  geom_mosaic(aes(x = product(JEStatus), fill = DENVstatus)) +
  geom_mosaic_text(aes(x = product(JEStatus, DENVstatus), label = after_stat(.wt)), as.label = TRUE, check_overlap = TRUE) +
  labs(fill = "", x = "DENV luminex", y = "JEV luminex") +
  scale_fill_manual(values =c("grey80", "grey80"))+
  theme_classic()+
  theme(legend.position = "none")

