library(foreign)
library(cluster)
library(FNN)
library(maptools)
library(tidyverse)
library(janitor)
library(bangladesh)
library(aod)
library(readxl)
library(ggnewscale)
library(cowplot)
library(ggplot2)


df_2007_2016 <- read_excel("hospital_cases.xlsx")
df_2007_2016 <- clean_names(df_2007_2016)
df_2007_2016 <- df_2007_2016 %>% 
  rename(
    upazila = epid_upazila)
  
#Coordinates
bgd_coordinates = get_coordinates(level = "upazila")
bgd_coordinates = clean_names(bgd_coordinates)
bgd_coordinates = bgd_coordinates[bgd_coordinates$division == "Rajshahi", ]
bgd_coordinates = bgd_coordinates[bgd_coordinates$district == "Nawabganj", ]

df_2007_2016$upazila[df_2007_2016$upazila == 'Banskhali'] <- 'Banshkhali'
df_2007_2016$upazila[df_2007_2016$upazila == 'Chittagong CC'] <- 'Chittagong Port'
df_2007_2016$upazila[df_2007_2016$upazila == 'Daulatpur-Kush'] <- 'Daulatpur'
df_2007_2016$upazila[df_2007_2016$upazila == 'Durgapur_RAJ.'] <- 'Durgapur'
df_2007_2016$upazila[df_2007_2016$upazila == 'Fulchari'] <- 'Fulchhari'
df_2007_2016$upazila[df_2007_2016$upazila == 'Gaibandha Mun.'] <- 'Gaibandha Sadar'
df_2007_2016$upazila[df_2007_2016$upazila == 'Kaliganj-LAL'] <- 'Kaliganj'
df_2007_2016$upazila[df_2007_2016$upazila == 'Kawkhali-RAN'] <- 'Kawkhali (Betbunia)'
df_2007_2016$upazila[df_2007_2016$upazila == 'Kotalipara'] <- 'Kotali Para'
df_2007_2016$upazila[df_2007_2016$upazila == 'Lohagara_CTG'] <- 'Lohagara'
df_2007_2016$upazila[df_2007_2016$upazila == 'Mithapukur'] <- 'Mitha Pukur'
df_2007_2016$upazila[df_2007_2016$upazila == 'Nab_Shibganj'] <- 'Shibganj'
df_2007_2016$upazila[df_2007_2016$upazila == 'Pabna Mun.'] <- 'Pabna Sadar'
df_2007_2016$upazila[df_2007_2016$upazila == 'Pirganj-RANG'] <- 'Pirganj'
df_2007_2016$upazila[df_2007_2016$upazila == 'Thakurgoan'] <- 'Thakurgaon'
df_2007_2016$upazila[df_2007_2016$upazila == 'Pirganj-THAK'] <- 'Pirganj'
df_2007_2016$upazila[df_2007_2016$upazila == 'Rajshahi CC'] <- 'Boalia'
df_2007_2016$upazila[df_2007_2016$upazila == 'Rangamati Mun.'] <- 'Rangamati Sadar'
df_2007_2016$upazila[df_2007_2016$upazila == 'Rangpur Mun.'] <- 'Rangpur Sadar'
df_2007_2016$upazila[df_2007_2016$upazila == 'Shibganj_NAB'] <- 'Shibganj'
df_2007_2016$upazila[df_2007_2016$upazila == 'Thakurgaon Mun.'] <- 'Thakurgaon Sadar'
df_2007_2016$upazila[df_2007_2016$upazila == 'Chuadanga Mun.'] <- 'Chuadanga Sadar'
df_2007_2016$upazila[df_2007_2016$upazila == 'Lohagara_NAR'] <- 'Lohagara'
df_2007_2016$upazila[df_2007_2016$upazila == 'Rajahat'] <- 'Rajarhat'
df_2007_2016$epid_district[df_2007_2016$epid_district == 'Rajshahi CC'] <- 'Rajshahi'
df_2007_2016$epid_district[df_2007_2016$epid_district == 'Nowabganj'] <- 'Nawabganj'


# define new data frame
id_list <- data.frame()

# loop over rows of dat.lab (get new ID each round)
for (i in seq(nrow(df_2007_2016))) {
  # find the row in bgd_coordinates where the upazila "bgd_coordinates$upazila" is identical to
  # current upazila in df for this round "df_2007_2016$upazila[i]"
  new_row <- bgd_coordinates[bgd_coordinates$upazila == df_2007_2016$upazila[i],]
  # add new row to orderd_id_list
  id_list <- rbind(id_list, new_row)
}

id_list = id_list[!duplicated(id_list), ]

# merge x and y columns
df_all <- merge(df_2007_2016, id_list, by = "upazila", all=F)
df_all <- df_all %>% distinct(epid, .keep_all = TRUE)


raj.cases <- df_all[,!names(df_all) %in% c("division", "district")]
raj.cases <- raj.cases[raj.cases$epid_district == 'Nawabganj',]

coords_raj.cases = raj.cases[,c("lon","lat")]
colnames(coords_raj.cases)<-c("X","Y")
attr(coords_raj.cases,"projection")<-"LL"
coords_raj.cases<-convUL(coords_raj.cases,km=F)
coords_raj.cases[,c("x_proj","y_proj")] = coords_raj.cases

#UTM conversion
case.data.index.surv.sp<-SpatialPoints(raj.cases[,c("lon","lat")])
proj4string(case.data.index.surv.sp) <- CRS("+proj=longlat")
newproj <- "+proj=utm +zone=45 +ellps=WGS84 +datum=WGS84 +units=km"
case.data.index.surv.sp<-spTransform(case.data.index.surv.sp, CRS=CRS(newproj))

# surveillance hospital only Rajashahi
LON <- c("88.586317")
LAT <- c("24.372005") 
hospitals.surv<- data.frame(LON, LAT)
hospitals.surv$LON <- as.numeric(hospitals.surv$LON)
hospitals.surv$LAT <- as.numeric(hospitals.surv$LAT)
hosp.surv.sp<-SpatialPoints(hospitals.surv[,c("LON","LAT")])
proj4string(hosp.surv.sp) <- CRS("+proj=longlat")
newproj <- "+proj=utm +zone=45 +ellps=WGS84 +datum=WGS84 +units=km"
hosp.surv.sp<-spTransform(hosp.surv.sp, CRS=CRS(newproj))

case.data.index.surv<-case.data.index.surv.sp
hosp.surv<-hosp.surv.sp

case.dists<-get.knnx(hosp.surv@coords,case.data.index.surv@coords,k=1)[[2]]

library(sf)
library(sp)
library(raster)
library(spatstat)
library(bangladesh)

# Load upazila boundary data using sf
raj <- get_divisions(divisions = "Rajshahi", level = "upazila")
raj <- subset(raj, District %in% c("Nawabganj"))
raj <- st_as_sf(raj)


upazilas <- c("Bholahat", "Gomastapur", "Nachole", "Nawabganj Sadar", "Shibganj")
dots_per_upazila <- c(
  "Bholahat" = 1, "Gomastapur" = 5, "Nachole" = 5, "Nawabganj Sadar" = 4, "Shibganj" = 14
)

dot_list <- list()
set.seed(1234)
for (upazila_name in upazilas) {
  
  index <- which(raj$Upazila == upazila_name)
  
  if (length(index) > 0) {
    upazila <- raj[index, ]
    upazila_poly <- upazila$geometry
    
    random_points <- st_sample(upazila_poly, size = dots_per_upazila[upazila_name], type = "random")
    dot_list[[upazila_name]] <- random_points
  } else {
  }
}

all_dot_data <- data.frame()

# Iterate through each upazila
for (upazila_name in names(dot_list)) {
  dot_locations <- dot_list[[upazila_name]]
  
  # Extract coordinates from dot locations
  coordinates <- st_coordinates(dot_locations)
  
  # Create a data frame for the current upazila's dot data
  upazila_dot_data <- data.frame(
    Upazila = rep(upazila_name, nrow(coordinates)),
    x = coordinates[, "X"],
    y = coordinates[, "Y"]
  )
  
  # Append the current upazila's dot data to all_dot_data
  all_dot_data <- rbind(all_dot_data, upazila_dot_data)
}

#UTM conversion
case.data.index.surv.sp<-SpatialPoints(all_dot_data[,c("x","y")])
proj4string(case.data.index.surv.sp) <- CRS("+proj=longlat")
newproj <- "+proj=utm +zone=45 +ellps=WGS84 +datum=WGS84 +units=km"
case.data.index.surv.sp<-spTransform(case.data.index.surv.sp, CRS=CRS(newproj))
case.data.index.surv<-case.data.index.surv.sp

case.dists<-get.knnx(hosp.surv@coords,case.data.index.surv@coords,k=1)[[2]]

raj <- get_divisions(divisions = "Rajshahi", level = "district")
raj <- subset(raj, District %in% c("Nawabganj", "Rajshahi"))
raj <- st_as_sf(raj)
ggplot() +
    geom_sf(data = raj) +
    geom_point(data = all_dot_data, aes(x, y))+
    geom_point(data = hospitals.surv, aes(LON, LAT))
  

##Fit smooth spline to JED case data
xs<-xs2<-seq(1,120,1)
# total
obs.cdf<-ecdf(case.dists)(xs)
ss<-smooth.spline(obs.cdf,spar=0.8)
ss.pred<-predict(ss,xs)
ss.pred$y[which(ss.pred$y<0)]<-0
ss.pred$y[which(ss.pred$y>1)]<-1

# Plot of fit of spline 
plot(xs,obs.cdf,pch=20)
lines(xs,ss.pred$y)

# Predictive cumulative observed cases with distance 
jed.cases.prob.obs<-c(0,diff(ss.pred$y))
jed.cases.prob.obs[which(jed.cases.prob.obs<0)]<-0
jed.cases.cumcounts.obs<-obs.cdf*length(case.dists)  #cdf of observed jed cases
plot(xs, jed.cases.cumcounts.obs, pch=20)
plot(xs, jed.cases.prob.obs, pch=20)

enc.cases.cumcounts.obs<-length(case.dists)*ecdf(case.dists)(xs)

ggplot() + 
  aes(case.dists)+ 
  geom_histogram(binwidth=1, colour="black", fill="white")


################ BRING IN HOSPITAL UTILIZATION DATA ###########################
dat<-read.dta("catchment_data.dta")


raj<-which(dat$district%in%c("01", "02", "03")) # "01", "02" "03"
dat<-dat[raj,]   

## Look at proportion who turn up to hospital by distance
dat2<-dat[which(dat$q24!=1),]
dat2<-dat[which(dat$q24%in%c(3,4)),]

case<-(dat$q26%in%c(3,4))|(dat$q27%in%c(3,4)) # More than 7 hours only
sum(case)

dat2<-dat[which(case==1),]

nrow(dat2)
nrow(dat)

dist.by.ind2<-dat2$diatance
turned.up.at.hosp2<-which(is.na(dat2$q31mch)==F)


breaks=seq(0,120,20)
hist.all<-hist(dist.by.ind2,breaks=breaks,plot=T)$counts
hist.cases<-hist(dist.by.ind2[turned.up.at.hosp2],breaks=breaks,plot=T)$counts
breaks.mids<-breaks[-length(breaks)]+diff(breaks)[1]/2
p.hosp<-hist.cases/hist.all
p.hosp[which(p.hosp<0)]<-0
p.hosp[which(is.na(p.hosp))]<-0


enc.cases.cumcounts<-length(dist.by.ind2)*ecdf(dist.by.ind2)(xs)
enc.cases.cumcounts.obs<-length(turned.up.at.hosp2)*ecdf(dist.by.ind2[turned.up.at.hosp2])(xs)

ci<-matrix(NaN,length(p.hosp),2)
for (i in 1:length(p.hosp)){
	if(is.na(p.hosp[i]))(next)
	ci[i,]<-binom.test(hist.cases[i],hist.all[i])$conf.int
}

#Fit models to hospital utilization data
ds<-dist.by.ind2
hosp<-rep(0,length(ds))
hosp[turned.up.at.hosp2]<-1

library(splines)
mod1<-glm(hosp~1,family="binomial")
mod2<-glm(hosp~ds,family="binomial") 

AIC(mod1)
AIC(mod2)

summary(mod2)
exp(confint(mod2))

confint(mod2)
confint.default(mod2) # using standard errors
wald.test(b = coef(mod2), Sigma = vcov(mod2), Terms = 2) # test for an overall effect of ds

## odds ratios only
exp(coef(mod2))

## odds ratios and 95% CI
exp(cbind(OR = coef(mod2), confint(mod2)))


######## Estimate number of JED cases using logistic models  ############
jed.cases.prob.obs<-c(0,diff(ss.pred$y))
jed.cases.prob.obs[which(jed.cases.prob.obs<0)]<-0
jed.cases.cumcounts.obs<-obs.cdf*length(case.dists)  #cdf of observed jed cases

plot(xs,jed.cases.prob.obs )

pred<-predict(mod2,newdata=list(ds=xs2),type="response", interval= "confidence", se=T)

critval <-  qnorm(0.975) ## approx 95% CI
upr <- pred$fit + critval * pred$se.fit
lwr <- pred$fit - critval * pred$se.fit
ypoly.pred<-c(upr,rev(lwr))


fit2 <- mod2$family$linkinv(pred$fit)

fit2[which(xs2==10)]
lwr2[which(xs2==10)]
upr2[which(xs2==10)]
fit2[which(xs2==50)]
lwr2[which(xs2==50)]
upr2[which(xs2==50)]

#p= prediction(mod2, list(ds=xs2)) # same as predict

n.tot<-(jed.cases.prob.obs*nrow(all_dot_data))/pred$fit  #pdf of total cases
n.tot.lwr <- (jed.cases.prob.obs*nrow(all_dot_data))/lwr
n.tot.upr <- (jed.cases.prob.obs*nrow(all_dot_data))/upr

cum.tot<-cumsum(n.tot)  ##cdf of total cases
cum.tot.lwr <- cumsum(n.tot.lwr)
cum.tot.upr <- cumsum(n.tot.upr)

cum.tot[length(cum.tot)]  
cum.tot.lwr[length(cum.tot.lwr)] 
cum.tot.upr[length(cum.tot.upr)] 


## Plot graph
xpoly<-c(xs,rev(xs))
#ypoly1<-c(rep(0,length(enc.cases.cumcounts.obs)),rev(enc.cases.cumcounts.obs))
#ypoly2<-c(enc.cases.cumcounts.obs,rev(enc.cases.cumcounts))

ypoly1.jed<-c(rep(0,length(jed.cases.cumcounts.obs)),rev(jed.cases.cumcounts.obs))
ypoly2.jed<-c(jed.cases.cumcounts.obs,rev(cum.tot))


## case distances and plots
breaks=seq(0,120,20)
breaks.mids<-breaks[-length(breaks)]+diff(breaks)[1]/2
hist.jed.cases<-hist(case.dists,breaks=breaks,plot=T)$counts
hist.jed.cases <- c(hist.jed.cases, 0)

(AA <- ggplot() +
  geom_col(aes(breaks, hist.jed.cases), width = 3, fill = "#70a494") +
  theme_classic() +
  scale_y_continuous(breaks = seq(0, 30, by = 5)) + 
  scale_x_continuous(breaks = seq(0, 120, by =20))+
  expand_limits(x = 0, y = 0)+
  theme(legend.position = "left", text = element_text(size = 24, family = "Times")) +
  xlab("Distance from hospital (km)") + ylab("JED hospital cases"))



(BB <- ggplot() +
  geom_line(aes(xs, cum.tot), col = "#008080") +
  geom_line(aes(xs, jed.cases.cumcounts.obs), col = "#70a494") +
  geom_polygon(aes(xpoly, ypoly1.jed, fill = "Observed"), alpha = 0.5) +
  geom_polygon(aes(xpoly, ypoly2.jed, fill = "Estimated unobserved"), alpha = 0.3) +
  scale_fill_manual(values = c("Observed" = "#008080", "Estimated unobserved" = "#70a494")) +
  theme_classic() +
  ylim(0, 150) +
  scale_x_continuous(breaks = seq(0, 120, by = 20))+
  theme(legend.position = c(0.3,0.95), text = element_text(size = 24, family = "Times")) +
  xlab("Distance from hospital (km)") +
  ylab("Cumulative number \nof JED cases") +
  guides(fill = guide_legend(title = "")) )


count_df <- as.data.frame(table(raj.cases$upazila))
colnames(count_df) <- c("upazila", "cases")

count_df <- merge(count_df, raj.cases[, c("upazila", "lon", "lat")], 
                by = "upazila", all.x = F)

count_df <- distinct(count_df)

# Rename the columns
colnames(count_df) <- c("upazila", "cases", "lon", "lat")
count_df$group <- cut(count_df$cases, 
                      breaks = c(0, 5, 10, Inf), 
                      labels = c('1-5 cases', '5-10 cases', '10+ cases'),
                      right = FALSE)


raj <- get_divisions(divisions = "Rajshahi",level =  "district")
raj <- subset(raj, District %in% c("Nawabganj", "Rajshahi", "Naogaon"))
# raj <- subset(raj, District %in% c("Nawabganj"))

library(ggspatial)
(AAA <- 
  ggplot(data = raj) +
  geom_sf(fill = 'white', lwd = 0.5) +
  annotation_scale()+
  theme_map()+
  geom_point(data = all_dot_data, aes(x = x, y =y, color = "#70a494"), shape = 20, size = 5) +
  geom_point(data = hospitals.surv, aes(LON, LAT), shape ="H", size = 7)+
  xlab("Longitude") + ylab("Latitude") +
  scale_color_manual(values = c("#70a494"), labels = c("JED hospital cases")) +
  guides(color = guide_legend(title = "")) +
  theme(text = element_text(size = 20, family = "Times"), legend.position = c(0,0.2))
  )
  # new_scale_color() +
  # # geom_point(aes(x = 88.586317, y = 24.372005, color = "black"), size = 6, shape = "H") +
  # # scale_color_manual(values = c("black"), labels = "Rajshahi Medical Hospital") +
  # guides(color = guide_legend(title = "")) +
  # theme(text = element_text(size = 20, family = "Times"), legend.position = "left", 
  #       legend.text = element_text(size = 20,family="Times")))



library(reshape2)
library(truncnorm)

set.seed(2356)
num_bootstraps <- 2000

# Initialize vectors to store results
boot_results <- numeric(num_bootstraps)
boot_cfr <- numeric(num_bootstraps)
prob_symptoms_boot <- numeric(num_bootstraps)
ifr_boot <- numeric(num_bootstraps)
out<- numeric(num_bootstraps)
bgd_2015 <- read_csv("~/Desktop/JED/bgd_2015.csv")


#  bootstrapping
for (b in 1:num_bootstraps) { 
  
  # CFR
  bootstrap_sample <- sample(c(rep(1, 5), rep(0, 59)), size = 64, replace = T)
  cfr_boot <- sum(bootstrap_sample == 1) / length(bootstrap_sample)
  boot_cfr[b] <- cfr_boot
  
  # HOSPITAL CASES
  
  ind.sim <- sample(nrow(dat2), nrow(dat2), replace = F)
  turned.up.at.hosp2.sim <- which(is.na(dat2$q31mch[ind.sim]) == FALSE)
  ds.sim <- ds[ind.sim]
  hosp <- rep(0, length(ds.sim))
  hosp[turned.up.at.hosp2.sim] <- 1
  mod2 <- glm(hosp ~ ds.sim, family = "binomial")
  pred.sim <- predict(mod2, newdata = list(ds.sim = xs2), type = "response", se = FALSE)
  if (min(pred.sim) < 0.001) {
    next
  }
  case.dists.sim <- sample(length(case.dists), length(case.dists), replace = TRUE)
  mu<-mean(case.dists[case.dists.sim])
  sd<-sd(case.dists[case.dists.sim])
  dnorm<-dnorm(xs2,mu,sd)
  dnorm<-dnorm/sum(dnorm)
  
  # case.dists.sim.ecdf <- ecdf(case.dists[case.dists.sim])(xs)
  # ss <- smooth.spline(case.dists.sim.ecdf, spar = 0.8)
  # ss.pred <- predict(ss, xs)
  # ss.pred$y[which(ss.pred$y < 0)] <- 0
  # ss.pred$y[which(ss.pred$y > 1)] <- 1
  # jed.cases.prob.obs <- c(0, diff(ss.pred$y))
  # jed.cases.prob.obs[which(jed.cases.prob.obs < 0)] <- 0
  jed.cases.prob.obs<-dnorm
  n.tot <- jed.cases.prob.obs * length(case.dists[case.dists.sim]) / pred.sim
  out[b] <- sum(n.tot)
  
}


# Calculate quantiles
cases_boot_quantiles <- quantile(out, probs = c(0.025, 0.5, 0.975), na.rm=T)
cfr_quantiles <- quantile(boot_cfr, probs = c(0.025, 0.5, 0.975))


######
save(cases_boot_quantiles, file = "cases_boot_quantiles.rds")
save(cfr_quantiles, file = "cfr_quantiles.rds")

load("~/Desktop/JED/JE_data_for_human_cases/hospital cases/cases_boot_quantiles.rds")
load("~/Desktop/JED/JE_data_for_human_cases/hospital cases/cfr_quantiles.rds")

hist(out,breaks=100)
hist(boot_cfr)


# expected deaths with this cases and cfr
((cases_boot_quantiles[2]+29)*cfr_quantiles[2])/10
((cases_boot_quantiles[2]+29)*cfr_quantiles[1])/10
((cases_boot_quantiles[2]+29)*cfr_quantiles[3])/10


# expected cases annually (hospital data is 2007-2016)
# (cases_boot_quantiles[2]+29)/10
# (cases_boot_quantiles[1]+29)/10
# (cases_boot_quantiles[3]+29)/10


library(cowplot)
top_row <- plot_grid(AAA, AA, BB, nrow =1,labels = "AUTO")
# plot_grid(s.surv_plot, prob_severe_ilness_plot,cfr_plot, ifr_plot, nrow=1, labels = c("D", "E", "F", "G"))

scientific_10 = function(x) {
  ifelse(
    x==0, "0",
    parse(text = sub("e[+]?", " %*% 10^", label_scientific()(x)))
  )
} 

(bottom_row <- plot_grid(
  
(ggplot(data.frame(prob_symptoms_boot), aes(x = "Probability \nsevere ilness", y=prob_symptoms_boot)) +
  labs(x="", y="") +
  geom_violin( fill = "tan1") + 
  expand_limits(y = 0)+
  geom_boxplot(width=0.1) +
   scale_y_continuous(
     breaks = seq(0, 0.001, by = 0.0005), 
     labels = scientific_10,
     expand = expansion(mult = c(0.05, 0.1))) +
  theme_classic()+theme(axis.text=element_text(colour="black"), text = element_text(size = 24, family = "Times"))),


(ggplot(data.frame(boot_cfr), aes(x = "Case \nFatality Ratio", y=boot_cfr)) +
  labs(x="", y="") +
  geom_violin( fill = "tomato3") + 
  geom_boxplot(width=0.1) +
  expand_limits(y = 0)+
  scale_y_continuous(breaks = seq(0, 0.15, by = 0.075), labels = c("0", "0.075", "0.15"))+
  theme_classic()+
  theme(axis.text=element_text(colour="black"), text = element_text(size = 24, family = "Times"))),


(ggplot(data.frame(ifr_boot), aes(x = "Infection \nFatality Ratio", y=ifr_boot)) +
  labs(x="", y="") +
  geom_violin( fill = "chocolate4") + 
  geom_boxplot(width=0.1) +
  expand_limits(y = 0)+
  scale_y_continuous(breaks = seq(0, 0.00015, by = 0.000075), labels = scientific_10)+
  theme_classic()+
  theme(axis.text=element_text(colour="black"), text = element_text(size = 24, family = "Times"))), labels = c("D", "E", "F"), nrow =1))

plot_grid(top_row, bottom_row, nrow =2, labels = NULL)


##### BIG LOOP BOOTSRAP
dot_lists <- list()
all_dot_datas <- list()
case_dists <- list()
case.data.index.surv.sp <- list()  


for (bootstrap_iteration in 1:1000) {
  dot_list <- list()
  set.seed(1234 + bootstrap_iteration)  # Use a different seed for each bootstrap
  
  # Your existing code for generating random points
  raj <- get_divisions(divisions = "Rajshahi", level = "upazila")
  raj <- subset(raj, District %in% c("Nawabganj"))
  raj <- st_as_sf(raj)
  
  upazilas <- c("Bholahat", "Gomastapur", "Nachole", "Nawabganj Sadar", "Shibganj")
  dots_per_upazila <- c(
    "Bholahat" = 1, "Gomastapur" = 5, "Nachole" = 5, "Nawabganj Sadar" = 4, "Shibganj" = 14
  )
  
  for (upazila_name in upazilas) {
    index <- which(raj$Upazila == upazila_name)
    
    if (length(index) > 0) {
      upazila <- raj[index, ]
      upazila_poly <- upazila$geometry
      
      random_points <- st_sample(upazila_poly, size = dots_per_upazila[upazila_name], type = "random")
      dot_list[[upazila_name]] <- random_points
    } else {
      # Handle cases where no matching data is found
    }
  }
  
  all_dot_data <- data.frame()
  
  # Iterate through each upazila
  for (upazila_name in names(dot_list)) {
    dot_locations <- dot_list[[upazila_name]]
    
    # Extract coordinates from dot locations
    coordinates <- st_coordinates(dot_locations)
    
    # Create a data frame for the current upazila's dot data
    upazila_dot_data <- data.frame(
      Upazila = rep(upazila_name, nrow(coordinates)),
      x = coordinates[, "X"],
      y = coordinates[, "Y"]
    )
    
    # Append the current upazila's dot data to all_dot_data
    all_dot_data <- rbind(all_dot_data, upazila_dot_data)
  }
  
  # Store dot_list and all_dot_data in lists for each bootstrap iteration
  dot_lists[[bootstrap_iteration]] <- dot_list
  all_dot_datas[[bootstrap_iteration]] <- all_dot_data
  
  # Create SpatialPoints for the current bootstrap iteration
  case.data.index.surv.sp[[bootstrap_iteration]] <- SpatialPoints(all_dot_data[, c("x", "y")])
  proj4string(case.data.index.surv.sp[[bootstrap_iteration]]) <- CRS("+proj=longlat")
  newproj <- "+proj=utm +zone=45 +ellps=WGS84 +datum=WGS84 +units=km"
  case.data.index.surv.sp[[bootstrap_iteration]] <- spTransform(case.data.index.surv.sp[[bootstrap_iteration]], CRS = CRS(newproj))
  
  # Calculate distances
  case_dists[[bootstrap_iteration]] <- get.knnx(hosp.surv@coords, case.data.index.surv.sp[[bootstrap_iteration]]@coords, k = 1)[[2]]
  
}


# Create a function to perform the calculations for each case_dist and corresponding dot data
process_case_dist <- function(case_dists, all_dot_data) {
  xs <- xs2 <- seq(1, 80, 1)
  obs.cdf <- ecdf(case_dists)(xs)
  ss <- smooth.spline(obs.cdf, spar = 0.8)
  ss.pred <- predict(ss, xs)
  ss.pred$y[which(ss.pred$y < 0)] <- 0
  ss.pred$y[which(ss.pred$y > 1)] <- 1
  jed.cases.prob.obs <- c(0, diff(ss.pred$y))
  jed.cases.prob.obs[which(jed.cases.prob.obs < 0)] <- 0
  n.tot <- (jed.cases.prob.obs * nrow(all_dot_data)) / pred$fit
  cum.tot <- cumsum(n.tot)
  return(cum.tot[length(cum.tot)])
}

# Initialize a list to store cum_tot_values for each bootstrap iteration
cum_tot_values <- numeric(length(case_dists))

# Apply the function to each element in case_dists using a loop
for (i in 1:length(case_dists)) {
  cum_tot_values[[i]] <- process_case_dist(case_dists[[i]], all_dot_datas[[i]])
}

quantile(cum_tot_values, probs = c(0.025, 0.5, 0.975))


