
# Fig 2 and supplements

#change with 1977 intro

A <- inla.spde.make.A(mesh = mesh, loc = as.matrix(xx[1:n.data, c("x_proj", "y_proj")]))

abx <- model.matrix(~age2+npigs, xx)[, -1]

stk.e <- inla.stack(
  data = list(y = xx[1:n.data,"je_status"]),
  A = list(A, 1),
  effects = list(s.index, data.frame(Intercept=1,abx)),
  tag = 'est')


stk.p <- inla.stack(
  tag = "pred",
  data = list(y = NA),
  A = list(A, 1), 
  effects = list(s.index, data.frame(Intercept=1,abx)))


stk.full <- inla.stack(stk.e, stk.p)


formula <- y ~ -1 + Intercept + offset(log(age2)) + npigs + f(spatial.field, model=spde, extraconstr = list(A = as.matrix(t(Q)%*%A), e= rep(0,n.covariates)))

output_model <- inla(
  formula,
  data = inla.stack.data(stk.full),
  family = "binomial",
  control.family = list(link = "cloglog"),
  control.predictor = list(compute = TRUE,link = 1, A = inla.stack.A(stk.full)),
  control.compute= list(dic = TRUE, config=T),
  verbose=T)


pred.ind2 <- inla.stack.index(stack = stk.full, tag = "pred")$data


output_model$summary.fitted.values[pred.ind2,"0.5quant"]

m <-  data.frame(model = c(output_model$summary.fitted.values[pred.ind2,"0.5quant"]),
                 age_cat= xx$age_cat)
prop_by_age_m = tapply(m$model, m$age_cat, mean)
length_m = tapply(m$model, m$age_cat, length)
m_asym = Hmisc::binconf(x=c(prop_by_age_m*length_m), n=c(length_m))
m_asym <- as.data.frame(m_asym)

prop_by_age_m = m %>% 
  group_by(age_cat) %>% 
  summarise(model=(mean(model)))

prop_by_age_m = cbind(prop_by_age_m, m_asym)


prop_by_age = tapply(xx$je_status, xx$age_cat, mean)
length_age = tapply(xx$je_status, xx$age_cat, length)
ci_asym = Hmisc::binconf(x=c(prop_by_age*length_age), n=c(length_age))
ci_asym <- as.data.frame(ci_asym)

prop_by_age = xx %>% 
  group_by(age_cat) %>% 
  summarise(model=(mean(je_status)))

prop_by_age = cbind(prop_by_age, ci_asym)

est_model = rbind(prop_by_age, prop_by_age_m)
est_model$group = c("Data", "Data", "Data", "Data", "Data", "Data", "Data",
                    "Model - JEV introduction 1977", "Model - JEV introduction 1977", "Model - JEV introduction 1977", 
                    "Model - JEV introduction 1977", "Model - JEV introduction 1977", "Model - JEV introduction 1977", "Model - JEV introduction 1977")

(fig.2A <- ggplot(data=est_model, aes(x=age_cat, y=model, color =group)) +
    theme_classic() +
    theme(legend.position = "bottom", legend.spacing.y = unit(0.05, 'cm'))+
    labs(x="Age (years)", y = "Seroprevalence")+
    scale_color_carto_d(palette = "Geyser")+
    geom_pointrange(aes(x=age_cat, y=PointEst, ymin=Upper, ymax=Lower), position=position_dodge(width=0.6)) +
    ylim(0, 0.4)+
    labs(color = "")+
    theme(axis.title.x = element_text(size=20, family = "Times"), axis.text.x = element_text(angle=0, size=15, family = "Times")) +
    theme(axis.title.y = element_text(size=20, family = "Times"), axis.text.y = element_text(angle=0, size=15, family = "Times")) +
    theme(legend.text = element_text(size = 12, family = "Times" ), legend.key.size = unit(0.4, "cm")) )



# plot_grid(fig.2A, fig.2C, fig.npigs, infections_map, labels = "AUTO")
fig3 <- plot_grid(fig.2A, fig_dic, fig.2B,ncol = 1, labels = "AUTO", rel_heights = c(2,2, 1.5) )
fig3b <- plot_grid(fig.2C, infections_map,ncol = 1, labels = c("D", "E") )
plot_grid(fig3, fig3b, rel_widths = c(1.2,2),labels = NULL, ncol =2)



##### 1960 intro
xx$age3 <- xx$age_y
xx$age3[which(xx$age3>53)] <- 53

A <- inla.spde.make.A(mesh = mesh, loc = as.matrix(xx[1:n.data, c("x_proj", "y_proj")]))

abx <- model.matrix(~age3+npigs, xx)[, -1]

stk.e <- inla.stack(
  data = list(y = xx[1:n.data,"je_status"]),
  A = list(A, 1),
  effects = list(s.index, data.frame(Intercept=1,abx)),
  tag = 'est')


stk.p <- inla.stack(
  tag = "pred",
  data = list(y = NA),
  A = list(A, 1), 
  effects = list(s.index, data.frame(Intercept=1,abx)))


stk.full <- inla.stack(stk.e, stk.p)


formula <- y ~ -1 + Intercept + offset(log(age3)) + npigs + f(spatial.field, model=spde, extraconstr = list(A = as.matrix(t(Q)%*%A), e= rep(0,n.covariates)))

output_model_3 <- inla(
  formula,
  data = inla.stack.data(stk.full),
  family = "binomial",
  control.family = list(link = "cloglog"),
  control.predictor = list(compute = TRUE,link = 1, A = inla.stack.A(stk.full)),
  control.compute= list(dic = TRUE, config=T),
  verbose=T)


pred.ind2 <- inla.stack.index(stack = stk.full, tag = "pred")$data


output_model_3$summary.fitted.values[pred.ind2,"0.5quant"]

mb <-  data.frame(model = c(output_model_3$summary.fitted.values[pred.ind2,"0.5quant"]),
                  age_cat= xx$age_cat)
prop_by_age_mb = tapply(mb$model, mb$age_cat, mean)
length_mb = tapply(mb$model, mb$age_cat, length)
mb_asym = Hmisc::binconf(x=c(prop_by_age_mb*length_mb), n=c(length_mb))
mb_asym <- as.data.frame(mb_asym)

prop_by_age_mb = mb %>% 
  group_by(age_cat) %>% 
  summarise(model=(mean(model)))

prop_by_age_mb = cbind(prop_by_age_mb, mb_asym)


##### 1950 intro
xx$age4 <- xx$age_y
xx$age4[which(xx$age4>63)] <- 63

A <- inla.spde.make.A(mesh = mesh, loc = as.matrix(xx[1:n.data, c("x_proj", "y_proj")]))

abx <- model.matrix(~age4+npigs, xx)[, -1]

stk.e <- inla.stack(
  data = list(y = xx[1:n.data,"je_status"]),
  A = list(A, 1),
  effects = list(s.index, data.frame(Intercept=1,abx)),
  tag = 'est')


stk.p <- inla.stack(
  tag = "pred",
  data = list(y = NA),
  A = list(A, 1), 
  effects = list(s.index, data.frame(Intercept=1,abx)))


stk.full <- inla.stack(stk.e, stk.p)


formula <- y ~ -1 + Intercept + offset(log(age4)) + npigs + f(spatial.field, model=spde, extraconstr = list(A = as.matrix(t(Q)%*%A), e= rep(0,n.covariates)))

output_model_4 <- inla(
  formula,
  data = inla.stack.data(stk.full),
  family = "binomial",
  control.family = list(link = "cloglog"),
  control.predictor = list(compute = TRUE,link = 1, A = inla.stack.A(stk.full)),
  control.compute= list(dic = TRUE, config=T),
  verbose=T)


pred.ind2 <- inla.stack.index(stack = stk.full, tag = "pred")$data


mc <-  data.frame(model = c(output_model_4$summary.fitted.values[pred.ind2,"0.5quant"]),
                  age_cat= xx$age_cat)
prop_by_age_mc = tapply(mc$model, mc$age_cat, mean)
length_mc = tapply(mc$model, mc$age_cat, length)
mc_asym = Hmisc::binconf(x=c(prop_by_age_mc*length_mc), n=c(length_mc))
mc_asym <- as.data.frame(mc_asym)

prop_by_age_mc = mc %>% 
  group_by(age_cat) %>% 
  summarise(model=(mean(model)))

prop_by_age_mc = cbind(prop_by_age_mc, mc_asym)


##### 1990 intro
xx$age5 <- xx$age_y
xx$age5[which(xx$age5>23)] <- 23

A <- inla.spde.make.A(mesh = mesh, loc = as.matrix(xx[1:n.data, c("x_proj", "y_proj")]))

abx <- model.matrix(~age5+npigs, xx)[, -1]

stk.e <- inla.stack(
  data = list(y = xx[1:n.data,"je_status"]),
  A = list(A, 1),
  effects = list(s.index, data.frame(Intercept=1,abx)),
  tag = 'est')


stk.p <- inla.stack(
  tag = "pred",
  data = list(y = NA),
  A = list(A, 1), 
  effects = list(s.index, data.frame(Intercept=1,abx)))


stk.full <- inla.stack(stk.e, stk.p)


formula <- y ~ -1 + Intercept + offset(log(age5)) + npigs + f(spatial.field, model=spde, extraconstr = list(A = as.matrix(t(Q)%*%A), e= rep(0,n.covariates)))

output_model_5 <- inla(
  formula,
  data = inla.stack.data(stk.full),
  family = "binomial",
  control.family = list(link = "cloglog"),
  control.predictor = list(compute = TRUE,link = 1, A = inla.stack.A(stk.full)),
  control.compute= list(dic = TRUE, config=T),
  verbose=T)


pred.ind2 <- inla.stack.index(stack = stk.full, tag = "pred")$data


md <-  data.frame(model = c(output_model_5$summary.fitted.values[pred.ind2,"0.5quant"]),
                  age_cat= xx$age_cat)
prop_by_age_md = tapply(md$model, md$age_cat, mean)
length_md = tapply(md$model, md$age_cat, length)
md_asym = Hmisc::binconf(x=c(prop_by_age_md*length_md), n=c(length_md))
md_asym <- as.data.frame(md_asym)

prop_by_age_md = md %>% 
  group_by(age_cat) %>% 
  summarise(model=(mean(model)))

prop_by_age_md = cbind(prop_by_age_md, md_asym)



est_model2 <- rbind(prop_by_age_mb, prop_by_age_mc, prop_by_age_md)
est_model2$group = c("1960", "1960", "1960", "1960", "1960", "1960", "1960",
                     "1950", "1950", "1950", "1950", "1950", "1950", "1950", 
                     "1990", "1990", "1990", "1990", "1990", "1990", "1990")

est_model3 <- rbind(est_model, est_model2)



(fig.2A_sup <- ggplot(data=est_model3, aes(x=age_cat, y=model, color =group)) +
    theme_classic() +
    theme(legend.position = "bottom", legend.spacing.y = unit(0.05, 'cm'))+
    labs(x="Age (years)", y = "Seroprevalence")+
    scale_color_carto_d(palette = "Geyser")+
    #geom_bar(stat="identity", position=position_dodge(), fill = "darkslategray4")+
    geom_pointrange(aes(x=age_cat, y=PointEst, ymin=Upper, ymax=Lower), position=position_dodge(width=0.6)) +
    ylim(0, 0.5)+
    labs(color = "")+
    theme(axis.title.x = element_text(size=20, family = "Times"), axis.text.x = element_text(angle=0, size=15, family = "Times")) +
    theme(axis.title.y = element_text(size=20, family = "Times"), axis.text.y = element_text(angle=0, size=15, family = "Times")) +
    theme(legend.text = element_text(size = 12, family = "Times" ), legend.key.size = unit(0.4, "cm")) )


#008080,#70a494,#b4c8a8,#f6edbd,#edbb8a,#de8a5a,#ca562c


DIC_values <- numeric(length = 41) 

for (i in 23:63) {
  
  xx$age2 <- xx$age_y
  xx$age2[which(xx$age2>i)] <- i
  
  print(i)
                
  A <- inla.spde.make.A(mesh = mesh, loc = as.matrix(xx[1:n.data, c("x_proj", "y_proj")]))
                
  abx <- model.matrix(~age2+npigs, xx)[, -1]
                
  stk.e <- inla.stack(
  data = list(y = xx[1:n.data,"je_status"]),
  A = list(A, 1),
  effects = list(s.index, data.frame(Intercept=1,abx)),
  tag = 'est')
                
                
    stk.p <- inla.stack(
    tag = "pred",
    data = list(y = NA),
    A = list(A, 1), 
    effects = list(s.index, data.frame(Intercept=1,abx)))
                
                
  stk.full <- inla.stack(stk.e, stk.p)
                
                
 formula <- y ~ -1 + Intercept + offset(log(age2)) + npigs + f(spatial.field, model=spde, extraconstr = list(A = as.matrix(t(Q)%*%A), e= rep(0,n.covariates))) 
  
 imod <- inla(
         formula,
        data = inla.stack.data(stk.full),
       family = "binomial",
        control.family = list(link = "cloglog"),
        control.predictor = list(compute = TRUE,link = 1, A = inla.stack.A(stk.full)),
       control.compute= list(dic = TRUE, config=T),
                  verbose=T)
 
 
 DIC_values[i - 22] <- imod$dic$dic
}

dic_val <- data.frame( dic = DIC_values,
                       year = seq(1990, 1950, by=-1))

(fig_dic<- ggplot(dic_val, aes(x = year, y = dic)) +
  geom_point(size =2,aes(color = factor(dic))) +
  scale_color_carto_d(palette = "BrwnYl", direction = -1)+
  theme_classic() +
  theme(legend.position = "none")+
  ylim(1295, 1310)+
  geom_vline(xintercept = 1977, linetype = "dashed", color = "black")+
  labs(x = "Years",
       y = "DIC")+ theme(axis.title.x = element_text(size=12, family = "Times"), axis.text.x = element_text(angle=0, size=12, family = "Times")) +
  theme(axis.title.y = element_text(size=20, family = "Times"), axis.text.y = element_text(angle=0, size=15, family = "Times"),
        axis.title.x = element_text(size=20, family = "Times"), axis.text.x = element_text(angle=0, size=15, family = "Times")) )


inset_grob <- ggplotGrob(fig_dic)

(sero_models <- (fig.2A_sup + 
                  annotation_custom(inset_grob, xmin = 0.5, xmax = 3, ymin = 0.25, ymax = 0.5)))
