library(readxl)
library(PBSmapping)
library(raster)
library(ggplot2)
library(INLA)
library(geoR)
library(FNN)
library(lme4)
library(sp)
library(tidyverse)
library(bangladesh)
library(stats)
library(ggregplot)
library(ggthemes)
library(ggspatial)
library(epikit)
library(coop)
library(colorspace)
library(sf)
library(janitor)
library(cowplot)
library(ggnewscale)
library(rcartocolor)
library(rgeos)
library(scales)
library(palettes)

# BRING CHAPAI ONLY FROM HH QUESTIONNAIRE

#Adding meter coordinates
coords_home = xx[,c("CommLong","CommLat")]
colnames(coords_home)<-c("X","Y")
attr(coords_home,"projection")<-"LL"
coords_home<-convUL(coords_home,km=F)
xx[,c("x_proj","y_proj")] = coords_home


## A. Spatial models using SPDE latent effect
# The offset shifts the response on the scale of the linear predictor - age, sets a coefficient of 1
# 0. Model formula hh adjusted
xx <- xx %>% drop_na(age)
xx$hhid <- as.factor(xx$hhid)

formula = seroposenr ~ 1 + offset(log(age)) + f(hhid, model = "iid") # hhid is a random effect

output_hhadjusted = inla(formula, data = xx, family = "binomial", 
                         control.family = list(link="cloglog"), 
                         control.predictor = list(compute=TRUE),
                         verbose = T)


est_mean <- output_hhadjusted$summary.fitted.values["mean"]
est_ll <- output_hhadjusted$summary.fitted.values["0.025quant"]
est_ul <- output_hhadjusted$summary.fitted.values["0.975quant"]


## fit model
formula = seroposenr ~ -1 + Intercept + offset(log(age)) + f(spatial.field, model=spde)

# 1. Define mesh (to calculate approximation to solution)
# What is the distance for which we would expect dependency? 
## Convert spatialpolygon object into matrix
coords.sp <- as.matrix(as.data.frame(coords_home))
boundary <- inla.nonconvex.hull(points = coords.sp)
mesh <- inla.mesh.2d(loc=xx[,c("x_proj","y_proj")],boundary = boundary, max.edge = c(30000, 100000))
plot(mesh)
points(coords.sp, col = "red", pch = 16)

#mesh_res = 3000
#mesh = inla.mesh.2d(loc=raj_je[,c("CommLong","CommLat")], max.edge= c(mesh_res,mesh_res*5),cutoff=mesh_res, boundary=raj_border)

# 2. Create SPDE with a Matérn covariance (weak solution)
spde = inla.spde2.matern(mesh=mesh,alpha=2)
s.index <- inla.spde.make.index(name="spatial.field", n.spde=spde$n.spde) 
A.est = inla.spde.make.A(mesh=mesh, loc=as.matrix(xx[,c("x_proj","y_proj")]))

# 3.Create a data structure for model fitting
stack.est = inla.stack(data=list(seroposenr=xx$seroposenr), # a list with data vectors
            A=list(A.est,1), # a list of projector matrices
            effects=list(c(s.index, list(Intercept=1)),
            list(xx[,c( "age", "pop")])), # a list of effects (e.g., the SPDE index) or predictors (i.e., covariates)
            tag='stdata') # a character with a label for this group of data


output_spacedep_foi = inla(formula,
                           data =inla.stack.data(stack.est),
                           family = "binomial",
                           control.family = list(link="cloglog"),
                           control.predictor=list(A=inla.stack.A(stack.est), compute = TRUE),
                           control.compute= list(dic = TRUE, config=T),
                           verbose=T)


#save(output_spacedep_foi, raj_je, A.est, file="output_spacedep_foi.RData")

#Adjust for households------------------------
load("~/Desktop/JED/JE_data_for_human_cases/output_hhadjusted.RData")
# which formula
output_hhadjusted$.args$formula
est_hhadjusted = output_hhadjusted$summary.fixed
hh_vect = sapply(xx$hhid, function(x) which(output_hhadjusted$summary.random$hhid$ID == x))
foi_vect = exp(output_hhadjusted$summary.fixed$mean + output_hhadjusted$summary.random$hhid$mean[hh_vect])
prob_vect = 1 - exp(- foi_vect * xx$age)
hist(prob_vect, 100)
residuals_hhadjusted = xx$seroposenr - prob_vect
variance_hhadjusted = mean(residuals_hhadjusted^2, na.rm=T)
plot(residuals_hhadjusted)
variance_hhadjusted = mean(residuals_hhadjusted^2)

# without adjustment
formula = seroposenr ~ 1 + offset(log(age))
output_constant_foi = inla(formula, data = xx, family = "binomial", control.family = list(link="cloglog"), control.predictor = list(compute=T), control.compute = list(dic = TRUE),verbose = T)
foi_vect = exp(output_constant_foi$summary.fixed$mean)
prob_vect = 1 - exp(- foi_vect * xx$age)
hist(prob_vect, 100)
residuals_constantfoi = xx$seroposenr - prob_vect
plot(residuals_constantfoi)
variance_constantfoi = mean(residuals_constantfoi^2)

#Percentage of variance explained by household adjustment
(1 - (variance_hhadjusted / variance_constantfoi))*100 

output = output_spacedep_foi2
#check the posterior mean estimate for the range. Then, go back and redo max.edge to be between 1/5 and 1/10 of this range
output$summary.hyperpar$mean
output$.args$formula
length(output$.args$data$seroposenr)
spatial.field.contrib = output_spacedep_foi$summary.random$`spatial.field`[,c("ID","mean")]
foi_vect = exp(output_spacedep_foi$summary.fixed$mean + as.vector(A.est%*%spatial.field.contrib$mean))
foi_vect = exp(output_spacedep_foi$summary.fix[1, "mean"] + drop(A.est %*% output_spacedep_foi$summary.random$spatial.field$mean))
prob_vect = 1 - exp(- foi_vect * xx$age)
hist(prob_vect, 100)
residuals_spacedep = xx$je_status - prob_vect
variance_spacedep = mean(residuals_spacedep^2)

#Percentage of variance explained by spatial field when adjusting by household
(1 - (variance_spacedep/ variance_constantfoi))*100 

#Constant FOI-----------------------------------------
formula = seroposenr ~ 1 + offset(log(age))
output_constant_foi = inla(formula, data = xx, family = "binomial", control.family = list(link="cloglog"), control.predictor = list(compute=T), verbose = T)
#save(raj_je, output_constant_foi, file = "~/output_constant_foi.RData")

#
exp(output_spacedep_foi$summary.fix[1, "mean"] + drop(A.est %*% output_spacedep_foi$summary.random$spatial.field$mean))


#Map----------------------------------------
#remotes::install_github("ovirahman/bangladesh")
raj <- get_divisions(divisions = "Rajshahi",level =  "district")
raj <- subset(raj, District %in% c("Nawabganj"))
#raj = bangladesh[which( bangladesh$NAME_2 == "Rajshahi" |bangladesh$NAME_2 == "Naogaon"|bangladesh$NAME_2 == "Nawabganj" ),]

#Get maps
bgd_border = raster::getData('GADM', country='BGD', level=3)
bangladesh = raster::getData('GADM', country='BGD', level=3)
#raj_border = bgd_border[which(bgd_border$NAME_2 == c("Rajshahi", "Nawabganj", "Naogaon")),]
raj_border <- subset(bgd_border, NAME_2 %in% c("Nawabganj"))
bgd_border_meters = spTransform(bgd_border, CRS('+proj=utm +zone=45'))
raj_meters = spTransform(raj_border, CRS("+proj=longlat +ellps=WGS84
                      +datum=WGS84"))

#Get pop. density - number of people in each pixel by the pixel surface area (1km)
bgd_pop = raster("~/Desktop/JED/JE_data_for_human_cases/bgd_pd_2020_1km.tif")
raj_pop = crop(bgd_pop, extent(raj_border))
raj_pop = projectRaster(raj_pop, crs = crs("+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs"))
raj_pop = mask(raj_pop, raj_meters)
df_pop = data.frame(coordinates(raj_pop))
df_pop_1 = SpatialPoints(df_pop, proj4string = CRS("+proj=longlat"))
df_pop_1 = spTransform(df_pop_1, CRS('+proj=utm +zone=45'))
df_pop_1 = as.data.frame(df_pop_1)
df_pop$pop_density = values(raj_pop)

#Plot spatial field 
output = output_spacedep_foi2
field = exp(output$summary.fixed$mean[1] + output$summary.random[['spatial.field']][['mean']])

#Project from the mesh onto raster cell 
proj = inla.mesh.projector(mesh, loc=as.matrix(coordinates(df_pop_1)))
field.proj = inla.mesh.project(proj, field)
#alpha.proj = inla.mesh.project(proj, alpha_vect)
df_pop$lambda = field.proj
#df_pop$alpha = alpha.proj
#df_pop$lambda[is.na(df_pop$lambda)] = mean(df_pop$lambda, na.rm=T)
#df_pop$alpha[is.na(df_pop$alpha)] = 0
df_pop = df_pop[!is.na(df_pop$pop_density),]
df_pop = df_pop[!is.na(df_pop$lambda),]


proj.xx = inla.mesh.projector(mesh, loc=as.matrix(coords_home))
field.proj = inla.mesh.project(proj.xx, field)
human_foi <- field.proj

dff <- data.frame(coords_home, human_foi)
dff <- dff[!duplicated(dff$Y),]

xx <- merge(xx, dff, by.x ="x_proj", by.y = "X")

# FOI map
ggplot(df_pop, aes(x, y)) +
  geom_raster(aes(fill = lambda), interpolate = TRUE, alpha=0.9)+
  scale_fill_gradient(low = "cornsilk2", high = "brown1", na.value = NA, name= "Force of \ninfection") +
  theme_classic() +
  coord_equal() +
  theme(legend.position="right", legend.text = element_text(size = 8))+
  theme(legend.key.width=unit(0.5, "cm"), legend.key.height = unit(0.4,"cm")) +
  xlab("Longitude") + ylab("Latitude") #+
  #scale_fill_gradient2(midpoint=mean(df_pop$lambda), low=cols[5],  mid="grey",high=cols[3], limits=c(0,0.015), breaks=seq(0.001,0.015,by=0.002), space = "Lab")


#pop density
library(rcartocolor)
par(mfrow(1, 0.3))

(H <-ggplot(df_pop, aes(x, y)) +
  geom_raster(aes(fill = pop_density), interpolate = TRUE) +
  scale_fill_carto_c(palette = "Mint")+
  theme_map() +
  coord_equal() +
  geom_point(data = xx, aes(x = CommLong, y = CommLat, color = "Community centroids"), size=2) +
  scale_color_manual(name = "", values = "#00798c") +
  theme(legend.position = c(0.8,0.2), legend.text = element_text(size = 13,family="Times"), legend.title = element_text(size=13,family="Times")) +
  theme(legend.key.width = unit(0.3, "cm"), legend.key.height = unit(0.5, "cm")) +
  labs(fill='Human density') )


(fig_1A <-ggplot(df_pop, aes(x, y)) +
    geom_raster(aes(fill = pop_density), interpolate = TRUE) +
    scale_fill_gradient(low = "floralwhite", high = "burlywood4")+
    theme_map() +
    coord_equal() +
    theme(legend.position = "bottom", legend.text = element_text(size = 20,family="Times"), legend.title = element_text(size=20,family="Times")) +
    theme(legend.key.width = unit(0.3, "cm"), legend.key.height = unit(1, "cm")) +
    labs(fill = expression("Human density (km"^2*")"))+
    geom_point(data = xx, aes(x = CommLong, y = CommLat, color = ave_seropositive_cat), shape=20, size = 6) +
    scale_color_carto_d(palette = "Geyser")+
    guides(color = guide_legend(reverse = TRUE)) +
    theme(legend.position = "bottom", legend.direction = "vertical", text = element_text(size = 20, family="Times"))+
    labs(color='Proportion human JEV IgG+') )

(fig_1A <- ggplot() + 
    geom_sf(data = raj, fill = "white") +
    geom_point(data = xx, aes(x = qgpslong, y = qgpslat, color = ave_seropositive_cat), shape=20, size = 7) +
    scale_color_carto_d(palette = "Geyser")+
    theme_map() +
    annotation_north_arrow(which_north = "true", height = unit(1, "cm"),width = unit(1, "cm"), location = "tl") +
    annotation_scale()+
    guides(color = guide_legend(reverse = TRUE)) +
    theme(legend.position= c(1, 0.3), legend.text = element_text(size = 16,  family = "Arial"), legend.title = element_text(size =16,  family = "Arial"),
          legend.key.width=unit(0.5, "cm"), legend.key.height = unit(0.6,"cm"), legend.direction = "vertical") +
    labs(x = "", y = "", color='Proportion human JEV IgG+') )


plot_grid(AAA, fig_1A, pig_1, labels = "AUTO", nrow =1)

# U <- ggplot(data = xx, aes(x = age_cat)) +
#   geom_bar(aes(fill = sex.x), position = position_dodge()) +
#   theme_classic() +
#   scale_fill_carto_d(palette = "Mint", name = "", labels = c("Male", "Female")) +
#   labs(x = "Age (years)", y = "Number of individuals")+
#   theme(text = element_text(size = 14, family="Times"), 
#         axis.text.x = element_text(size = 14, family="Times"), 
#         axis.text.y = element_text(size = 14, family="Times"),
#         legend.text = element_text(size =14, family ="Times"),
#         legend.position = c(0.9,0.8))
# 
# (G <- ggplot() +
#     geom_sf(data = raj, fill = "white") +
#     geom_point(data = xx, aes(x = CommLong, y = CommLat, color = positive_cat), shape=17, size = 3) +
#     scale_color_carto_d(palette = "Geyser")+
#     theme_map()+
#     annotation_scale()+
#     guides(color = guide_legend(reverse = TRUE)) +
#     theme(legend.position = c(0.9, 0.2), legend.direction = "vertical", text = element_text(size = 13, family="Times"))+
#     labs(color='JEV seropositivity') )


# (M <- ggplot(data=prop_by_age, aes(x=age_cat, y=seroposenr, group =1)) +
#   geom_bar(stat="identity", position=position_dodge(), fill = "#B4D9CC")+
#   theme_classic() +
#   labs(x="Age (years)", y = "JEV seropositivity")+
#   geom_pointrange(aes(x=age_cat, y=PointEst, ymin=Upper, ymax=Lower)) +
#   theme(text = element_text(size = 14, family="Times"),
#         axis.text.x = element_text(size = 14, family="Times"), 
#         axis.text.y = element_text(size = 14, family="Times")) +
#   scale_linetype_discrete(name = ""))
# 
# plot_grid(H, U, G, M, labels = "AUTO")
# 
# 
# (G <- ggplot() +
#   geom_sf(data = raj, fill = "white") +
#   geom_point(data = xx, aes(x = CommLong, y = CommLat, color = positive_cat), shape=17, size = 3) +
#   scale_color_manual(values = c("dodgerblue4", "dodgerblue3", "dodgerblue", "coral", "firebrick1", "tomato4"))+
#   theme_map()+
#   annotation_scale()+
#   guides(color = guide_legend(reverse = TRUE)) +
#   theme(legend.position = c(0.8, 0.2), legend.direction = "vertical", text = element_text(size = 14, family="Times"))+
#   labs(color='Human seropositivity') )


