% Example: Solution of the Lyapunov equation 
%
% A*X+X*A+B=0,    A SPD and banded, ill-conditioned, B symm. and banded
%
% by lyap_banded.
% Reference manuscript:
%
% Davide Palitta and Valeria Simoncini
% NUMERICAL METHODS FOR LARGE-SCALE LYAPUNOV EQUATIONS WITH SYMMETRIC BANDED DATA
% July 2018, SISC
%
% REQUIREMENT: the subroutines TruncSubGen_mex and lowrank_normF which make use of LAPACK and C-BLAS subroutines. 


% the matrix A comes from the finite difference discretization of the 1D
% differential operator 
%
% Lu=-1/gamma*u_xx+gamma*u
%
% on [0,1], with zero Dirichlet b.c.
n=1000;
gamma=1e2;
A=1/gamma*(n-1)^2*(spdiags([-ones(n,1),2*ones(n,1),-ones(n,1)],-1:1,n,n))+gamma*speye(n,n);

% generate a randomn diagonal rhs
B=spdiags(2*ones(n,1)+ (-1).^(1:n),0,n,n);

% set all the parameters and thresholds of the algorithm
param.resrel=1e-3;
param.maxit=1000;
param.epsilon_quad=1e-5;
param.nu=6;
param.epsilon_tau=param.epsilon_quad;
param.bandexp=150;
param.epsilon_sparseinv=param.epsilon_quad;

% call lyap_banded
[Xb,Xl]=Lyap_Banded(A,B,param);


