%==========================================================================
%Magma mixing model
% Multicomponent diffusion of 8 melt oxides (SiO2, TiO_2, Al2O_3, FeO,
% MgO, CaO, Na_2O, K_2O) and effective binary diffusion-exsolution of H2O 
% and CO2
%
%Author: Simone Colucci
%Affiliation: Istituto Nazionale di Geofisica e Vulcanologia
%             sezione diPisa
%Date: January 2024
%==========================================================================

% Plot experimental data

Ca_data=readtable('Ca.csv');
x_Ca=Ca_data.Var1;
x_Ca=x_Ca-650;
y_Ca=Ca_data.Var2;

Al_data=readtable('Al.csv');
x_Al=Al_data.Var1;
x_Al=x_Al-650;
y_Al=Al_data.Var2;

Mg_data=readtable('Mg.csv');
x_Mg=Mg_data.Var1;
x_Mg=x_Mg-650;
y_Mg=Mg_data.Var2;

K_data=readtable('K.csv');
x_K=K_data.Var1;
x_K=x_K-650;
y_K=K_data.Var2;

Na_data=readtable('Na.csv');
x_Na=Na_data.Var1;
x_Na=x_Na-650;
y_Na=Na_data.Var2;

Si_data=readtable('Si.csv');
x_Si=Si_data.Var1;
x_Si=x_Si-650;
y_Si=Si_data.Var2;

figure(1);

subplot(6,2,6);plot(x_Ca,y_Ca,'r.')
subplot(6,2,3);plot(x_Al,y_Al,'r.')
subplot(6,2,5);plot(x_Mg,y_Mg,'r.')
subplot(6,2,8);plot(x_K,y_K,'r.')
subplot(6,2,7);plot(x_Na,y_Na,'r.')
subplot(6,2,1);plot(x_Si,y_Si,'r.')

