%==========================================================================
%Magma mixing model
% Multicomponent diffusion of 8 melt oxides (SiO2, TiO_2, Al2O_3, FeO,
% MgO, CaO, Na_2O, K_2O) and effective binary diffusion-exsolution of H2O 
% and CO2
%
%Author: Simone Colucci
%Affiliation: Istituto Nazionale di Geofisica e Vulcanologia
%             sezione diPisa
%Date: January 2024
%==========================================================================

function D = D_H2O_model(Cw,T)
% Model for H2O diffusion coefficient in basalt [m^2/s]
% reference:
% Freda, C., D. R. Baker, C. Romano, and P. Scarlato (2003) 
% Water diffusion in natural potassic melts. 
% Geological Society, London, Special Publications, 
% 213 (1), 53–62, 
% doi:10.1144/GSL.SP.2003.213.01.04.

R = 8.314462618; % gas constant
D = exp( -11.924 -1.003*log(100*Cw) )*exp( -exp( 11.836-0.139*log(100*Cw) )/(R*T) );
end

