%==========================================================================
%Magma mixing model
% Multicomponent diffusion of 8 melt oxides (SiO2, TiO_2, Al2O_3, FeO,
% MgO, CaO, Na_2O, K_2O) and effective binary diffusion-exsolution of H2O 
% and CO2
%
%Author: Simone Colucci
%Affiliation: Istituto Nazionale di Geofisica e Vulcanologia
%             sezione diPisa
%Date: January 2024
%==========================================================================

% Input parameters

% initial conditions for the diffusion couple
% - anhydrous melt oxides [TiO_2 Al2O_3 FeO MgO CaO Na_2O K_2O] (weight fraction)
%   left couple side 
Dict.InitialConditions.Ym_oxides_left = ...
    [0.7986; 19.1869; 6.5339; 2.7588; 10.1120; 3.7959; 2.1928]*0.01;
%   right couple side 
Dict.InitialConditions.Ym_oxides_right = ...
    [0.6293; 13.7431; 6.0456; 2.5846; 33.9253; 1.9665; 0.8877]*0.01;
% - dissolved CO2   
%   left couple side
Dict.InitialConditions.Ym_CO2_left = 0;               
%   right couple side
Dict.InitialConditions.Ym_CO2_right = 0.025;          
% - dissolved H2O
%   left couple side
Dict.InitialConditions.Ym_H2O_left = 0.023;         
%   right couple side
Dict.InitialConditions.Ym_H2O_right = 0.02;           
% - gas volume fraction
Dict.InitialConditions.alphag0 = 0.00001;   
% - gas composition (CO2 weight fraction) 
Dict.InitialConditions.Yg_CO2_0 = 0.01;                
% reference:
% F. M. Deegan, V. R. Troll, C. Freda, V. Misiti, J. P. Chadwick,
% C. L. McLeod, J. P. Davidson (2010)
% Magma-Carbonate Interaction Processes and Associated CO_2 Release at
% Merapi Volcano, Indonesia: Insights from Experimental Petrology
% Journal of Petrology,
% 51 (5), 1027–1051,
% doi:10.1093/petrology/egq010.

% physical parameters
% - pressure (Pa)
Dict.System.p = 500e6;  
% - temperature (K)
Dict.System.T = 1260+273.15;  
% - melt density (kg/m^3)
Dict.System.rhol = (2727+2549)/2;  
% - bubble radius (m)
Dict.Bubble.R = 0.5e-6;  
% - bubble number density (num. bubbles)/(m^3 melt)
Dict.Bubble.Nb = 1.e12;              

% oxides diffusion matrix
% - eigenvectors 
Dict.Diffusion.P = [-0.48,-0.37,-0.42,-0.008,-0.04,0.017,-0.005;...
                    -0.10,0.79,-0.33,-0.09,-0.09,-0.015,-0.036;...
                    -0.59,-0.37,0.61,0.29,0.93,-0.72,-0.51;...
                    -0.35,-0.27,0.42,-0.60,-0.19,-0.03,-0.13;
                    -0.45,-0.11,0.35,0.71,-0.29,0.59,-0.11;
                    0.21,0.11,-0.16,-0.05,-0.019,-0.19,0.84;
                    0.21,0.07,-0.15,-0.21,0.08,0.31,0.01];
% - eigenvalues 
Dict.Diffusion.lambda = [1.764,2.02,3.55,16.39,22.74,26.71,163.7]*1.e-12;
% reference:
% C. Guo and Y. Zhang (2020)
% Multicomponent diffusion in a basaltic melt: Temperature dependence
% Chemical Geology,
% 549, 119700,
% doi:10.1016/j.chemgeo.2020.119700

% space domain
% - number of mesh nodes
Dict.Mesh.Nodes = 20;       
% - half length (m)
Dict.Mesh.Xh = 1.e-3;      

% time
% - number of time steps
Dict.Time.nt = 10;  
% - final time (s)
Dict.Time.tf = 230;           

% plot experimental data (no=0, yes=1)
Dict.plot.data = 1;

% x axis limit (m)
Dict.Plot.xlim = 600e-6;      

% src path
path.src = '../src';

% data path
path.data = '../data/Deegan';
% reference:
% F. M. Deegan, V. R. Troll, C. Freda, V. Misiti, J. P. Chadwick,
% C. L. McLeod, J. P. Davidson (2010)
% Magma-Carbonate Interaction Processes and Associated CO_2 Release at
% Merapi Volcano, Indonesia: Insights from Experimental Petrology
% Journal of Petrology,
% 51 (5), 1027–1051,
% doi:10.1093/petrology/egq010.

%%
addpath(path.src,path.data)

S = magmaMixing(Dict);
