%==========================================================================
%Magma mixing model
% Multicomponent diffusion of 8 melt oxides (SiO2, TiO_2, Al2O_3, FeO,
% MgO, CaO, Na_2O, K_2O) and effective binary diffusion-exsolution of H2O 
% and CO2
%
%Author: Simone Colucci
%Affiliation: Istituto Nazionale di Geofisica e Vulcanologia
%             sezione diPisa
%Date: January 2024
%==========================================================================

function u0 = reactionDiffusion_ic(x,C_CO2m_left,C_CO2m_right,C_H2Om_left,C_H2Om_right,C_CO2g_0,C_H2Og_0)
% Initial conditions

c_CO2m_0(x<0)=C_CO2m_left;
c_CO2m_0(x>0)=C_CO2m_right;
c_CO2m_0(x==0)=(C_CO2m_left+C_CO2m_right)*0.5;

c_H2Om_0(x<0)=C_H2Om_left;
c_H2Om_0(x>0)=C_H2Om_right;
c_H2Om_0(x==0)=(C_H2Om_left+C_H2Om_right)*0.5;

u0 = [c_CO2m_0; c_H2Om_0; C_H2Og_0; C_CO2g_0];

end