%==========================================================================
%Magma mixing model
% Multicomponent diffusion of 8 melt oxides (SiO2, TiO_2, Al2O_3, FeO,
% MgO, CaO, Na_2O, K_2O) and effective binary diffusion-exsolution of H2O 
% and CO2
%
%Author: Simone Colucci
%Affiliation: Istituto Nazionale di Geofisica e Vulcanologia
%             sezione diPisa
%Date: January 2024
%==========================================================================

function C = multicomponentDiffusion(x,t,Ym_oxides_left,Ym_oxides_right,lambda,P)
% Analytical solution for multicomponent diffusion 8 melt oxides 
% (SiO2, TiO_2, Al2O_3, FeO, MgO, CaO, Na_2O, K_2O)

C_mean = 0.5*(Ym_oxides_right + Ym_oxides_left);
DeltaC_0 = Ym_oxides_right-Ym_oxides_left;

C=zeros(7,length(x),length(t));
for i=1:length(t)
    for j=1:length(x)
        f = erf(x(j)./(2*sqrt(lambda*t(i))));
        F = diag(f);
        C(:,j,i) = C_mean + 0.5*P*F/P*DeltaC_0;
    end
end
