%==========================================================================
%Magma mixing model
% Multicomponent diffusion of 8 melt oxides (SiO2, TiO_2, Al2O_3, FeO,
% MgO, CaO, Na_2O, K_2O) and effective binary diffusion-exsolution of H2O 
% and CO2
%
%Author: Simone Colucci
%Affiliation: Istituto Nazionale di Geofisica e Vulcanologia
%             sezione diPisa
%Date: January 2024
%==========================================================================

function D = D_CO2_model(Cw,p,T)
% Model for CO2 diffusion coefficient in all melts [m^2/s]
% reference:
% Zhang Y, Xu Z, Zhu M, Wang H (2007) 
% Silicate melt properties and volcanic eruptions. 
% Rev Geophys 45:RG4004,
% doi:10.1029/2006RG000216

D = exp(-13.99 -(17367 + 1.9448*p*1e-6)/T + Cw*100*(855.2 + 0.2712*p*1.e-6)/T);
end

