{{#section 'page'}}
  <link rel=preload href=/images/textile.jpg as=image type=image/jpeg>
{{/section}}

# Nisinoon

A multilingual dictionary database of Algonquian derivational morphemes {.subtitle}

<search>
  <form action=/search class=search-form method=get>
    <label for=search-box>Search the Database</label>
    <input
      autocomplete=on
      autocorrect=off
      class=text-box
      enterkeyhint=search
      id=search-box
      inputmode=search
      name=q
      placeholder='e.g. “atimw-” or “dog”'
      spellcheck=false
      type=search
    >
  </form>
</search>

<figure class=textile>
  <img alt='A rectangular textile hand made by Angela Waupochick for the Nisinoon project, displaying a top-down view of two trillium flowers at opposite corners of a pink square in the center, bordered by side views of two trillium flowers along the top and bottom. Photo by Rodney Schreiner.' src=/images/textile.jpg>
  <figcaption class=caption>
    <span>Trillium applique by Angela Waupochick</span>
    <span>Photo by Rodney Schreiner</span>
  </figcaption>
</figure>

<section class=intro>

## Introduction {#introduction}

This project is an NSF-funded cross-linguistic database of the components which make up words in Algonquian languages. There are two main goals:

1. To provide tribes with a source for lexical expansion for their language revitalization/reclamation projects.
2. To provide a basis for comprehensive reconstruction of Proto-Algonquian.
{.list .numbered}

This database is a web-based, open-access, centralized resource for Algonquian word components, providing community members and linguists with a set of data that has previously been difficult to access. [Explore the database here.](/search)

</section>

## Contents {#contents}

- [Introduction](#introduction)
- [Project Team](#project-team)
- [Advisory Board](#advisory-board)
- [What does Nisinoon mean?](#nisinoon-meaning)
- [Basics of Algonquian Word Structure](#grammar)
- [Algonquian Components Bibliography](#bibliography)
- [How to Cite this Project](#how-to-cite)
- [Former Team Members](#former-team-members)
{.bulleted .list}

## Project Team {{> backlink/backlink }} {#project-team}

- **Monica Macaulay**, *Project Lead* (University of Wisconsin-Madison)
- [Hunter Thompson Lockwood][website-hunter], *Co-Project Lead* (The Myaamia Center)
- [Daniel W. Hieber][website-danny] ("Danny"), *Data Manager*, *Lead Developer* (Chitimacha Tribe of Louisiana)
{.bulleted .list}

## Advisory Board {{> backlink/backlink }} {#advisory-board}

- Sarah Babinski, University of Zürich
- jessie little doe baird, Mashpee Wampanoag
- Daryl Baldwin, Miami Tribe of Oklahoma; Myaamia Center
- David Costa, Myaamia Center
- Marie-Odile Junker, Carleton University
- Will Oxford, University of Manitoba
- Yolanda Pushetonequa, Meskwaki Nation; University of Wisconsin-Madison
- Michael Migizi Sullivan, Waadookodaading Ojibwe Language Immersion School
- Rand Valentine, University of Wisconsin
- Natalie Weber, Yale University
- Arok Wolvengrey, First Nations University of Canada
{.bulleted .list}

## What does Nisinoon mean? {{> backlink/backlink }} {#nisinoon-meaning}

[Nisinoon][nisinoon-entry] is an Ojibwe word meaning {{{tln 'there are three' }}}. We chose it to represent the tripartite structure of Algonquian words (initial-medial-final). Click on the word to learn more about the word and hear it pronounced.

## Basics of Algonquian Word Structure {{> backlink/backlink }} {#grammar}

[Read an overview of word structure in Algonquian languages here.](/grammar)

## Algonquian Components Bibliography {{> backlink/backlink }} {#bibliography}

The [Algonquian Components Bibliography](/bibliography) is a set of resources used in the Nisinoon project to collect data on derivational morphemes in Algonquian languages. (It is not intended to be an exhaustive bibliography on Algonquian languages!) It was compiled by Monica Macaulay (University of Wisconsin-Madison) and [Hunter Lockwood][website-hunter] (Myaamia Center, Miami University) with the help of Rachel Fedorchak, Anushri Kartik-Narayan, Eleanor Sand, Leksi Scarr, Savana Stauss, and Jen Stoughton.

If you see an error in this bibliography, or would like to suggest any additions, please email Monica Macaulay at [mmacaula@wisc.edu](mailto:mmacaula@wisc.edu).

[See the Algonquian Components Bibliography here.](/bibliography)

## How to Cite this Project {{> backlink/backlink }} {#how-to-cite}

> Monica Macaulay, Hunter T. Lockwood, & Daniel W. Hieber. {{ meta.releaseYear }}. <cite>Nisinoon: The Algonquian Components Database</cite> v{{ package.version }}. <https://nisinoon.net>. DOI: [10.5281/zenodo.11459862][data-doi].

## Former Team Members {{> backlink/backlink }} {#former-team-members}

- Jack Crabb, *Undergraduate Research Assistant* (University of Wisconsin-Madison), 2023–2024
- Andrea Cudworth, *Project Assistant* (University of Wisconsin-Madison), 2018-2019
- Thaddeus A. Dockery ("Tad"), *Developer* (Wisconsin Historical Society), 2019
- Rachel Fedorchak, *Undergraduate Research Assistant*, *Bibliographer* (University of Wisconsin-Madison), 2020-2021
- Eli Fox Baker, *Undergraduate Research Assistant* (University of Wisconsin-Madison), 2023–2024
- Tong Jiao, *Undergraduate Research Assistant*, *Developer* (University of Wisconsin-Madison), 2021-2022
- Alison Jozwiak, *Project Assistant* (University of Wisconsin-Madison), 2020
- Vade Kamenitsa-Hale, *Undergraduate Research Assistant*, *Developer* (University of Wisconsin-Madison), 2020-2021
- Anushri Kartik-Narayan, *Bibliographer* (University of Wisconsin-Madison), 2018-2019
- Chloe Knope, *Intern* (College of Menominee Nation), 2022
- Naneque LaTender, *Intern* (College of Menominee Nation), 2021
- Sarah Lundquist, *Project Assistant* (University of Wisconsin-Madison), 2019
- Elsa Mager, *Undergraduate Research Assistant* (University of Wisconsin-Madison), 2023–2024
- Gabrielle Mistretta, *Project Assistant* (University of Wisconsin-Madison), 2020-2022
- Vivian Nash, *Project Assistant* (University of Wisconsin-Madison), 2022–2023
- Eleanor Sand, *Undergraduate Research Assistant*, *Bibliographer* (University of Wisconsin-Madison), 2021-2022
- Leksi Scarr, *Undergraduate Research Assistant* (University of Wisconsin-Madison), 2022–2023
- Savana Stauss, *Bibliographer* (University of Wisconsin-Madison), 2018-2019
- Jennifer Stoughton, *Undergraduate Research Assistant* (University of Wisconsin-Madison), 2022–2023
- Brock Wroblewski, *Developer* (University of Wisconsin-Madison), 2018-2020
{.bulleted .list}

<!-- LINKS -->
[data-doi]:       https://doi.org/10.5281/zenodo.11459862
[nisinoon-entry]: https://ojibwe.lib.umn.edu/main-entry/nisinoon-vii
[website-danny]:  https://github.com/dwhieb
[website-hunter]: https://miamioh.edu/myaamia-center/about/staff-faculty-affiliates/lockwood/index.html
