# Technical details

- Authors:     Thorsten Simon, Wolfgang Schulz, Gregor Ehrensperger, Georg Mayr
- Date:       2024-08-05
- One-liner:  ALDIS data (2010--2019) aggregated to ERA5 resolution: Cloud to ground lightning occurrence in June, July, August.
- DOI: 10.5281/zenodo.13164463
- Format: netCDF

# Overview

ALDIS lightning data we gratefully recieved from [ALDIS](https://www.aldis.at/), the
Austrian Lightning Detection and Information System, through Wolfgang Schulz.

ALDIS data are available for the summer months (June, July, August) for the years 2010--2019.

This dataset contains data aggregated to ERA5 resolution.


# Details

We aggregated the ALDIS data to ERA5 resolution (0.25° x 0.25°) using ceiling, meaning all flash occurrences are stored at the next full hour.
The area covered is a rectangle from 8.25E to 16.75E longitude and 45.25N to 49.75N latitude.
`flash` is set to `True` if at least one cloud to ground lighting occurred within the given spatiotemporal ERA5 cell
and `False` otherwise.

**Non-commercial use** is allowed conditional on proper citation of the data source, the accompanying [manuscript](https://doi.org/10.48550/arXiv.2210.11529) and [ALDIS](https://www.aldis.at/).


# Data schema
## Dimensions                                                                                                                                                                                                                                                                                        
 | Dimension | Size |
 |-----------|------|
 | time      | 22080|
 | latitude  | 19   |
 | longitude | 35   |

## Coordinates
 | Coordinate | Type             | Values                                     | Units   | Long Name  |
 |------------|------------------|--------------------------------------------|---------|------------|
 | longitude  | float64          | 8.25, 8.5, 8.75, ..., 16.25, 16.5, 16.75   | degrees | longitude  |
 | latitude   | float64          | 45.25, 45.5, 45.75, ..., 49.5, 49.75       | degrees | latitude   |
 | time       | datetime64[ns]   | 2010-06-01T01:00:00, ..., 2019-09-01       | -       | time       |

## Data Variables
 | Variable | Dimensions                    | Type      | Description                          |
 |----------|-------------------------------|-----------|--------------------------------------|
 | flash    | (time, latitude, longitude)   | boolean   | dask.array<chunksize=(720, 19, 35)>  |
