# Large mass hierarchies from strongly-coupled dynamics---Data release

This release contains data associated with the publication
[Large mass hierarchies from strongly-coupled dynamics][arxiv]
([JHEP 06 (2016) 114][jhep])

It comprises four files:

- `README.md`:
  This file.
- `Fig4.csv`:
  the data shown in Figure 4 of [the paper][jhep].
  The mass of composite spin-0 and spin-2 states,
  and their excitations,
  computed for $c_1 = 0 = A_0$,
  as a function of $\Delta$,
  for $r_{\mathrm{UV}} = 25$ and $r_{\mathrm{IR}} = 10^{-6}$,
  normalised to the mass $M_0$ of the lightest scalar.
- `Fig5.csv`:
  the data shown in Figure 5 of [the paper][jhep].
  The mass $M$ of the composite spin-0 and spin-2 states,
  computed for $c_1 = 0 = A$,
  as a function of $-A(r_{\mathrm{IR}})=\log(\Lambda_0 / \Lambda_{\mathrm{IR}})$,
  for $\Delta = 1.5$,
  normalised to the mass $M_T$ of the lightest tensor.
  $A(r_{\mathrm{UV}}) - A(r_{\mathrm{IR}})$ is fixed to 8.
- `DataRelease.nb`:
  A Mathematica notebook that will take the above two files
  and generate plots similar to those shown in [the paper][jhep].

## Column specifications

### `Fig4.csv`

Each row represents a single computation of a state mass.
The data comprise three columns:

- `Delta`:
  The $x$-coordinate in Figure 4 of [the paper][jhep].
  $\Delta$,
  related to the scaling dimension of the operator deforming the conformal theory,
  as described in Section 3 of [the paper][jhep].
- `Spin`:
  The spin of the state.
  This controls the colour in Figure 4 of [the paper][jhep].
- `M/M0`:
  The $y$ coordinate of Figure 4 of [the paper][jhep].
  The mass of the state,
  normalised by the lightest scalar mass.

### `Fig5.csv`

Each row represents a single computation of a state mass.
The data comprise three columns:

- `-A(rIR)`:
  The $x$-coordinate in Figure 5 of [the paper][jhep].
  The value of the function $A(r)$
  defined in Equation (3.7) of [the paper][jhep],
  at the IR cutoff.
- `Spin`:
  The spin of the state.
  This controls the colour in Figure 4 of [the paper][jhep].
- `M/MT`:
  The $y$ coordinate of Figure 4 of [the paper][jhep].
  The mass of the state,
  normalised by the lightest tensor mass.

[arxiv]: https://arxiv.org/abs/1605.04258
[jhep]: https://doi.org/10.1007/JHEP06(2016)114
