(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     10150,        308]
NotebookOptionsPosition[      8989,        282]
NotebookOutlinePosition[      9384,        298]
CellTagsIndexPosition[      9341,        295]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Figure 4", "Title",ExpressionUUID->"6de9da86-8e90-467b-b268-0443f01302f6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"spectrum", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"StringJoin", "[", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", "\"\<Fig4.csv\>\""}], 
     "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"spectrum0", "=", 
   RowBox[{"Select", "[", 
    RowBox[{"spectrum", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], "&"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"spectrum2", "=", 
   RowBox[{"Select", "[", 
    RowBox[{"spectrum", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "2"}], "&"}]}], "]"}]}], 
  ";"}]}], "Input",ExpressionUUID->"a54ec4b9-7a9d-44f7-b5ca-f4e2ef9eef24"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"spin0", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"spectrum0", "[", 
      RowBox[{"[", 
       RowBox[{"i1", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i1", ",", 
       RowBox[{"Length", "[", "spectrum0", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"spin2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"spectrum2", "[", 
      RowBox[{"[", 
       RowBox[{"i1", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i1", ",", 
       RowBox[{"Length", "[", "spectrum2", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",ExpressionUUID->"d94ee672-7620-40af-9b70-a44edc494687"],

Cell[BoxData[
 RowBox[{"Show", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{"spin0", ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "9"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Black"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"spin2", ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "9"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Blue"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",ExpressionUUID->"6629782b-c05f-4f6f-ad80-41f662d3e42d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Figure 5", "Title",ExpressionUUID->"55917c6a-f760-4734-9b59-f78623d83302"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"spectrum", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"StringJoin", "[", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", "\"\<Fig5.csv\>\""}], 
     "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"spectrum0", "=", 
   RowBox[{"Select", "[", 
    RowBox[{"spectrum", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], "&"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"spectrum2", "=", 
   RowBox[{"Select", "[", 
    RowBox[{"spectrum", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "2"}], "&"}]}], "]"}]}], 
  ";"}]}], "Input",ExpressionUUID->"53db49b9-491f-4d8f-b6b0-b43ff30852c0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"spectrumphys", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"StringJoin", "[", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", "\"\<Fig4.csv\>\""}], 
     "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"spectrumphys", "=", 
   RowBox[{"Select", "[", 
    RowBox[{"spectrumphys", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "1.5"}], "&"}]}], "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"spectrumphys0", "=", 
   RowBox[{"Select", "[", 
    RowBox[{"spectrumphys", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], "&"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"spectrumphys2", "=", 
   RowBox[{"Select", "[", 
    RowBox[{"spectrumphys", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "2"}], "&"}]}], "]"}]}], 
  ";"}]}], "Input",ExpressionUUID->"aa646029-de72-4d4d-8584-2b4237c219cc"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"spin0", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"spectrum0", "[", 
      RowBox[{"[", 
       RowBox[{"i1", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i1", ",", 
       RowBox[{"Length", "[", "spectrum0", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"spin2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"spectrum2", "[", 
      RowBox[{"[", 
       RowBox[{"i1", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i1", ",", 
       RowBox[{"Length", "[", "spectrum2", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"spinphys0", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"spectrumphys0", "[", 
      RowBox[{"[", 
       RowBox[{"i1", ",", "3"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i1", ",", 
       RowBox[{"Length", "[", "spectrumphys0", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"spinphys2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"spectrumphys2", "[", 
      RowBox[{"[", 
       RowBox[{"i1", ",", "3"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i1", ",", 
       RowBox[{"Length", "[", "spectrumphys2", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",ExpressionUUID->"72742129-06ce-4a07-9f2c-f84b11cdd21d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"plot1", "=", 
   RowBox[{"Show", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ListPlot", "[", 
      RowBox[{"spin0", ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], ",", "9"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "4.53"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Black"}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ListPlot", "[", 
      RowBox[{"spin2", ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "10"}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Blue"}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}]}], "\[IndentingNewLine]",
     "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plot2", "=", 
   RowBox[{"Show", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"spinphys0", "/", 
        RowBox[{"spinphys2", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "5.5"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Gray", ",", 
          RowBox[{"Thickness", "[", "0.0025", "]"}]}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"spinphys2", "/", 
        RowBox[{"spinphys2", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "5.5"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Lighter", "[", 
           RowBox[{"Blue", ",", "0.5"}], "]"}], ",", 
          RowBox[{"Thickness", "[", "0.0025", "]"}]}], "}"}]}]}], "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"plot1", ",", "plot2"}], "]"}]}], "Input",ExpressionUUID->"d62c4ebb-\
6ed2-4470-b183-29fd3ac8379f"]
}, Open  ]]
},
WindowSize->{699, 855},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"14.0 for Mac OS X ARM (64-bit) (December 12, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"84e55716-b729-43df-b0b3-bf06f55d0f19"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 80, 0, 98, "Title",ExpressionUUID->"6de9da86-8e90-467b-b268-0443f01302f6"],
Cell[663, 24, 818, 25, 73, "Input",ExpressionUUID->"a54ec4b9-7a9d-44f7-b5ca-f4e2ef9eef24"],
Cell[1484, 51, 830, 26, 52, "Input",ExpressionUUID->"d94ee672-7620-40af-9b70-a44edc494687"],
Cell[2317, 79, 834, 20, 136, "Input",ExpressionUUID->"6629782b-c05f-4f6f-ad80-41f662d3e42d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3188, 104, 80, 0, 98, "Title",ExpressionUUID->"55917c6a-f760-4734-9b59-f78623d83302"],
Cell[3271, 106, 818, 25, 73, "Input",ExpressionUUID->"53db49b9-491f-4d8f-b6b0-b43ff30852c0"],
Cell[4092, 133, 1109, 34, 94, "Input",ExpressionUUID->"aa646029-de72-4d4d-8584-2b4237c219cc"],
Cell[5204, 169, 1510, 48, 94, "Input",ExpressionUUID->"72742129-06ce-4a07-9f2c-f84b11cdd21d"],
Cell[6717, 219, 2256, 60, 283, "Input",ExpressionUUID->"d62c4ebb-6ed2-4470-b183-29fd3ac8379f"]
}, Open  ]]
}
]
*)

