library(metafor)

path = 'C:/Users/tumkayat/Desktop/Systematic Review Project/AfterEmbaseReview/StudyUpdated_04082017/Meta-analyses/'
files=list.files(path)
#pdf('C:/Users/tumkayat/Desktop/Percentage_change_FunnelPlots_TrimFilled_combinednew.pdf',family= 'Helvetica',useDingbats=FALSE)
#names(pdfFonts())

##MAD function###################

CalculateMAD <- function(alist) {
  length = length(alist)
  numofcomp = (length)*(length-1)/2 
  total = 0
  for (i in 1:(length-1)){
    for (j in (i+1):length){
      abs_diff = abs((alist[i]) - (alist[j]))
      total = total + abs_diff  
    }
  }
  mad = (total/numofcomp)
  if (length(mad) != 0){
    return(mad) 
  } else {
    
    return(NA)
  }
  
}

### Inter-allellic I2 Calculation#############################################
IntraAlleleI2 = NULL
InterAlleleI2 = NULL
OverAllI2 = NULL

IntraAlleleMAD = NULL
InterAlleleMAD = NULL
OverAllMAD = NULL

AlleleNames = NULL
N = NULL
ES = NULL
GeneName = NULL

##Loop thru the .csv files to calculate I2 and MADs#######################

for (i in files) { myfile = paste(path , i,'/' , i , '.csv', sep = '')
                   print(i)
                   mydata<-read.csv(myfile, header=TRUE)                 
                   #mydata<-read.csv("C:/Users/tumkayat/Desktop/Systematic Review Project/AfterEmbaseReview/Meta-analyses/Vol//Vol.csv",header=TRUE)                  
                   attach(mydata)
                   
                   OverallMETA<-rma(yi=mydata$DeltaPI, sei=mydata$S.Pooled)
                   OverAllI2 = append(OverAllI2, paste(summary(OverallMETA)$I2))
                   OverAllMAD = append(OverAllMAD, CalculateMAD(mydata$DeltaPI.))
                   
                   check<-colnames(mydata)                   
                   
                   if ("Subset.ID" %in% check) {
                     AlleleES = NULL
                     AlleleSE = NULL
                     AlleleMAD = NULL
                     
                     numofSubGroups<-unique(c(mydata$Subset.ID))
                     
                     for (j in numofSubGroups){
                       meta<-rma(yi=mydata$DeltaPI, sei=mydata$S.Pooled,subset=(mydata$Subset.ID==j))
                       
                       AlleleNames = append(AlleleNames, paste(mydata$Genotype..Experimental.[mydata$Subset.ID==j][1]))                       
                       N = append(N, paste(sum(mydata$Ne.UsedinAnalysis[mydata$Subset.ID==j])))
                       
                       IntraAlleleI2 = append(IntraAlleleI2, paste(summary(meta)$I2 ))
                       ES = append(ES, paste(summary(meta)$b))
                       
                       AlleleES = append(AlleleES, summary(meta)$b)
                       AlleleSE = append(AlleleSE, summary(meta)$se)
                       
                       IntraAlleleMAD = append(IntraAlleleMAD, CalculateMAD(mydata$DeltaPI.[mydata$Subset.ID==j]))
                       AlleleMAD = append(AlleleMAD, CalculateMAD(mydata$DeltaPI.[mydata$Subset.ID==j]))
                     }
                     
                     InterMETA<-rma(yi=AlleleES, sei=AlleleSE)
                     InterAlleleI2 = append(InterAlleleI2, paste(summary(InterMETA)$I2 ))
                     
                     InterAlleleMAD = append(InterAlleleMAD, CalculateMAD(AlleleMAD))
                     GeneName = append(GeneName, i)
                   }
                   detach(mydata)             
                               
}
d1 = data.frame(AlleleNames, IntraAlleleI2, IntraAlleleMAD)  #InterSubgroupTable
d2 = data.frame(GeneName, InterAlleleI2, OverAllI2, InterAlleleMAD, OverAllMAD) #IntraSubgroupTable and overallHeterogeneity
write.csv(d1, "C:/Users/tumkayat/Desktop/IntraAllele_I2_MAD.csv")
write.csv(d2, "C:/Users/tumkayat/Desktop/InterAllele_OverAll_I2_MAD.csv")
