library(car)
library(calibrate)
library(MASS)
library(plotrix)
library(scales)
library(ggplot2)

shadowtext <- function(x, y=NULL, labels, col='white', bg='black',
                       theta= seq(pi/4, 2*pi, length.out=8), r=0.1, ... ) {
  
  xy <- xy.coords(x,y)
  xo <- r*strwidth('A')
  yo <- r*strheight('A')
  
  for (i in theta) {
    text( xy$x + cos(i)*xo, xy$y + sin(i)*yo, labels, col=bg, ... )
  }
  text(xy$x, xy$y, labels, col=col, ... )
}

mydata<-read.csv("C:/Users/tumkayat/Desktop/Systematic Review Project/AfterEmbaseReview/Figures/Figure5/HeterogeneityTable.csv",header=TRUE)
detach(mydata)
attach(mydata)
str(mydata)

##Seperated by replication status
es<-mydata$ABS_ES
het<-mydata$I.2...
moes<-mydata$MOE[mydata$ColCode == 'gold']
lab<-mydata$Gene.Name
N<-mydata$N
colors<-mydata$ColCode

par(mar = c(5,8,3,8))


#### Figure I2 vs ES ################################################################################

plot(es,het,xlab="PI score change (%)",ylab="Heterogeneity (I2%)",xlim=c(0,100),ylim=c(0,100),cex = mydata$Size,bg=alpha(paste(colors),0.7),pch = 21)
text(es,het,labels=lab,pos=3,cex=.5,srt= 45)
shadowtext(es,het,labels=lab,cex= .5, col=paste(mydata$ColCode) , r=0.05)

abline(lm(het~es),col="black",lty=2)
cor(es,het)
summary(lm(het~es))
plot(lm(het~es))

plot(es,N,xlab="Effect Size (Delta PI) [%]",ylab="Sample Size (N)",xlim=c(0,100),bg=alpha(paste(mydata$ColCode),0.7),col="black",pch = 21)
text(es,N,labels=lab,pos=2,cex=.5)
abline(lm(N~es),col="black",lty=2)
cor(N,es)
summary(lm(N~es))
plot(lm(N~es))

plot(N,het,xlab="Sample Size (N)",ylab="Heterogeneity [%]",bg=alpha(paste(mydata$ColCode),0.7),col="black",pch = 21)
text(N,het,labels=lab,pos=2,cex=.5)
abline(lm(het~N),col="black",lty=2)
cor(het,N)
summary(lm(het~N))
plot(lm(N~es))


#### Figure MOEs vs I2 ################################################################################

plot(moes,het,xlab="MOEs",ylab="Heterogeneity [%]",xlim=c(0,50),ylim=c(0,100),cex = mydata$Size,bg=alpha(paste(colors),0.7),pch = 21)
text(moes,het,labels=lab,pos=4,cex=.5,srt= 90)
shadowtext(es,het,labels=lab,cex= .5, col=paste(mydata$ColCode) , r=0.05)

abline(lm(het~moes),col="black",lty=2)
cor(het,moes)
summary(lm(het~moes))
plot(lm(het~moes))

plot(moes,N,xlab="Effect Size (Delta PI) [%]",ylab="Sample Size (N)",xlim=c(0,100),bg=alpha(paste(mydata$ColCode),0.7),col="black",pch = 21)
text(moes,N,labels=lab,pos=2,cex=.5)
abline(lm(N~moes),col="black",lty=2)
cor(N,moes)
summary(lm(N~moes))
plot(lm(N~moes))

plot(N,het,xlab="Sample Size (N)",ylab="Heterogeneity [%]",bg=alpha(paste(mydata$ColCode),0.7),col="black",pch = 21)
text(N,het,labels=lab,pos=2,cex=.5)
abline(lm(het~N),col="black",lty=2)
cor(het,N)
summary(lm(het~N))
plot(lm(N~es))


### Figure MADMAP#################

mydata<-read.csv("C:/Users/tumkayat/Desktop/Systematic Review Project/AllStudyAfterTheUpdate/MADValues_alleles.csv",header=TRUE)
str(mydata)
es<-mydata$ABS_ES
MA<-mydata$MAD
lab<-mydata$Allele

par(las=2)
par(mar=c(5,10,0,3))
plot(es,MA,xlab="Effect Size(Delta PI) [%]",ylab="Mean Absolute Difference (MAD)",ylim=c(0,45),xlim=c(0,100),cex = mydata$Size,bg=alpha(paste(mydata$ColCode),0.7),col="black",pch = 21)
shadowtext(es,MA,labels=lab,cex= .5, col=paste(mydata$ColCode) , r=0.05)

text(es,MA,labels=lab,pos=2,cex=.5)
abline(lm(MA~es),col="black",lty=2)
cor(MA,es)
summary(lm(MA~es))

### Percantage PI Change vs Hedges'g #####################################
mydata<-read.csv("C:/Users/tumkayat/Desktop/Systematic Review Project/AllStudyAfterTheUpdate/HedgesgvsPercantagePIChange.csv",header=TRUE)
Hedges<-mydata$SMD.Hedge.s.g.
PPC<-mydata$Effect.Size..deltaPI.
lab<-mydata$Gene.Name

plot(Hedges,PPC, xlab="Hedge's g",ylab="Percentage PI Change (PPC)",bg=alpha(paste(mydata$Diomand.Status),0.7),col="black",pch = 21)
text(Hedges,PPC,labels=lab,pos=2,cex=.5)

abline(lm(PPC~Hedges),col="black",lty=2)

cor(Hedges,PPC)
model<-lm(PPC~Hedges)
summary(model)

ndf = data.frame(Hedges=-1.5)
predict(model,ndf,interval = "confidence")

save(model, file = "C:/Users/tumkayat/Desktop/Systematic Review Project/AllStudyAfterTheUpdate/Figures/Figure8/model.rda")
x<-load("C:/Users/tumkayat/Desktop/Systematic Review Project/AllStudyAfterTheUpdate/Figures/Figure8/model.rda")
