library(ggplot2)

mydata<-read.csv("C:/Users/tumkayat/Desktop/Systematic Review Project/AfterEmbaseReview/Figures/Figure5/HeterogeneityTable.csv",header=TRUE)
detach(mydata)
attach(mydata)
str(mydata)

I2<-mydata$I.2...
MAD<-mydata$MAD
category<-mydata$ColCode
label<-mydata$Gene.Name

p<-ggplot(mydata,aes(factor(category,c("gold",'grey','brown')),I2,label=label))
      
p+geom_point(position='jitter') + theme_bw() + geom_boxplot(mapping =aes(factor(category,c("gold",'grey','brown'))), color=c('gold','grey','brown'), fill = 'white', width = 0.2,lwd=0.7,  alpha=0, outlier.shape = NA) + geom_text(check_overlap=TRUE)

stat_summary(fun.data= 'median_hilow',pch=18,lwd=1,color=c('gold','grey','brown')) 

###Two Sample t-test#############################################
bronze<-mydata$I.2...[mydata$ColCode=='brown']
silver<-mydata$I.2...[mydata$ColCode=='grey']
gold<-mydata$I.2...[mydata$ColCode=='gold']

summary(gold)
summary(silver)
summary(bronze)

t.test(silver,gold,var.equal=TRUE)
wilcox.test(bronze,silver)
