/* Generated By:JavaCC: Do not edit this line. Parser.java */
package fed.parser;

import java.io.StringReader;

@SuppressWarnings({"unused", "serial"})
public class Parser implements ParserConstants {
    /** Constructor with String for a single statement */
    public Parser (String statement) {
        this(new StringReader(statement.endsWith(";") ? statement : statement + ";"));
    }

    /** Validate a script file or a single statement */
    public boolean isValid () throws ParseException, TokenMgrError {
        return validate();
    }

  final public boolean validate() throws ParseException {
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case R_SELECT:
      case R_UPDATE:
      case R_CREATE:
      case R_DROP:
      case R_INSERT:
      case R_DELETE:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case R_CREATE:
      case R_DROP:
        ProcessDDLStatement();
        break;
      case R_UPDATE:
      case R_INSERT:
      case R_DELETE:
        ProcessDMLStatement();
        break;
      case R_SELECT:
        ProcessQLStatement();
        break;
      default:
        jj_la1[1] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }

    }
    Transaction();
      {if (true) return true;}
    throw new Error("Missing return statement in function");
  }

/********************************/
/********* QL queries **********/
/********************************/
  final public SQLStatement ProcessQLStatement() throws ParseException {
    SQLStatement qlQuery;
    Token queryType;
    queryType = jj_consume_token(R_SELECT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case Q_COUNT:
      qlQuery = countAllTable();
      break;
    default:
      jj_la1[2] = jj_gen;
      if (jj_2_1(3)) {
        qlQuery = aggregateFuncWithGroupby();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case O_ASTERISK:
        case Q_ATTRIBUTE:
          qlQuery = selectWithJoins();
          break;
        default:
          jj_la1[3] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
            qlQuery.setStatementType(queryType.kind);
        {if (true) return qlQuery;}
    throw new Error("Missing return statement in function");
  }

/* select with and withuot joins */
  final public SQLStatement selectWithJoins() throws ParseException {
    Token T;
    SQLStatement qlQuery = new SQLStatement();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case Q_ATTRIBUTE:
      getListOfAttributes();
      break;
    case O_ASTERISK:
      jj_consume_token(O_ASTERISK);
      break;
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(K_FROM);
    if (jj_2_2(2)) {
      jj_consume_token(S_IDENTIFIER);
      jj_consume_token(O_COMMA);
      jj_consume_token(S_IDENTIFIER);
    } else if (jj_2_3(2)) {
      jj_consume_token(S_IDENTIFIER);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_WHERE:
      whereWithJoin();
      break;
    default:
      jj_la1[5] = jj_gen;
      ;
    }
    jj_consume_token(O_TERMINATOR);
        {if (true) return qlQuery;}
    throw new Error("Missing return statement in function");
  }

  final public void whereWithJoin() throws ParseException {
    jj_consume_token(R_WHERE);
    if (jj_2_4(4)) {
      singleJoinCondition();
    } else if (jj_2_5(3)) {
      nonJoinCondition();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void singleJoinCondition() throws ParseException {
    jj_consume_token(O_OPENPAREN);
    jj_consume_token(Q_ATTRIBUTE);
    ComparisonOperators();
    jj_consume_token(Q_ATTRIBUTE);
    jj_consume_token(O_CLOSEPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_AND:
      jj_consume_token(R_AND);
      nonJoinCondition();
      break;
    default:
      jj_la1[6] = jj_gen;
      ;
    }
  }

  final public void nonJoinCondition() throws ParseException {
    jj_consume_token(O_OPENPAREN);
    jj_consume_token(Q_ATTRIBUTE);
    ComparisonOperators();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_STRING:
      jj_consume_token(QUOTED_STRING);
      break;
    case FLOAT:
      jj_consume_token(FLOAT);
      break;
    case INTEGER:
      jj_consume_token(INTEGER);
      break;
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(O_CLOSEPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_AND:
    case R_OR:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case R_AND:
        jj_consume_token(R_AND);
        break;
      case R_OR:
        jj_consume_token(R_OR);
        break;
      default:
        jj_la1[8] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      nonJoinCondition();
      break;
    default:
      jj_la1[9] = jj_gen;
      ;
    }
  }

  final public void withOrWithoutHaving() throws ParseException {
    jj_consume_token(R_GROUP);
    jj_consume_token(R_BY);
    jj_consume_token(Q_ATTRIBUTE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_HAVING:
      jj_consume_token(R_HAVING);
      jj_consume_token(R_COUNT);
      jj_consume_token(O_OPENPAREN);
      jj_consume_token(O_ASTERISK);
      jj_consume_token(O_CLOSEPAREN);
      ComparisonOperators();
      jj_consume_token(INTEGER);
      break;
    default:
      jj_la1[10] = jj_gen;
      ;
    }
  }

/* COUNT TABLE */
  final public SQLStatement countAllTable() throws ParseException {
    Token T;
    SQLStatement qlQuery;
    jj_consume_token(Q_COUNT);
    jj_consume_token(K_FROM);
    T = jj_consume_token(S_IDENTIFIER);
              qlQuery = new SQLStatement();
              qlQuery.setTableName(T.image);
    jj_consume_token(O_TERMINATOR);
        {if (true) return qlQuery;}
    throw new Error("Missing return statement in function");
  }

/* AGGREGATE FUNCTION WITH GROUP BY */
  final public SQLStatement aggregateFuncWithGroupby() throws ParseException {
    Token T;
    SQLStatement qlQuery;
    jj_consume_token(Q_ATTRIBUTE);
    jj_consume_token(O_COMMA);
    getAggregateFunction();
    jj_consume_token(K_FROM);
    T = jj_consume_token(S_IDENTIFIER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_WHERE:
      whereWithJoin();
      break;
    default:
      jj_la1[11] = jj_gen;
      ;
    }
    withOrWithoutHaving();
              qlQuery = new SQLStatement();
              qlQuery.setTableName(T.image);
    jj_consume_token(O_TERMINATOR);
        {if (true) return qlQuery;}
    throw new Error("Missing return statement in function");
  }

  final public void getListOfAttributes() throws ParseException {
    jj_consume_token(Q_ATTRIBUTE);
    if (jj_2_6(2)) {
      jj_consume_token(O_COMMA);
      getListOfAttributes();
    } else {
      ;
    }
  }

  final public void getAggregateFunction() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case Q_COUNT:
      jj_consume_token(Q_COUNT);
      break;
    case Q_SUM:
      jj_consume_token(Q_SUM);
      break;
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/********************************/
/********* DML queries **********/
/********************************/
  final public SQLStatement ProcessDMLStatement() throws ParseException {
    SQLStatement dmlQuery;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_INSERT:
      dmlQuery = insert();
      break;
    case R_DELETE:
      dmlQuery = deleteTuple();
      break;
    case R_UPDATE:
      dmlQuery = updateTuple();
      break;
    default:
      jj_la1[13] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
     {if (true) return dmlQuery;}
    throw new Error("Missing return statement in function");
  }

/* UPDATE TUPLE */
  final public SQLStatement updateTuple() throws ParseException {
    Token T;
    Token queryType;
    SQLStatement dmlQuery;
    queryType = jj_consume_token(R_UPDATE);
    T = jj_consume_token(S_IDENTIFIER);
    jj_consume_token(R_SET);
    ColumnSetter();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_WHERE:
      jj_consume_token(R_WHERE);
      ColumnComparison();
      break;
    default:
      jj_la1[14] = jj_gen;
      ;
    }
              dmlQuery = new SQLStatement();
              dmlQuery.setTableName(T.image);
              dmlQuery.setStatementType(queryType.kind);
    jj_consume_token(O_TERMINATOR);
        {if (true) return dmlQuery;}
    throw new Error("Missing return statement in function");
  }

  final public void ColumnSetter() throws ParseException {
    jj_consume_token(S_IDENTIFIER);
    jj_consume_token(O_EQUAL);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_STRING:
      jj_consume_token(QUOTED_STRING);
      break;
    case FLOAT:
      jj_consume_token(FLOAT);
      break;
    case INTEGER:
      jj_consume_token(INTEGER);
      break;
    case R_NULL:
      jj_consume_token(R_NULL);
      break;
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_COMMA:
      jj_consume_token(O_COMMA);
      ColumnSetter();
      break;
    default:
      jj_la1[16] = jj_gen;
      ;
    }
  }

/* INSERT TABLE */
  final public SQLStatement insert() throws ParseException {
    Token T;
    Token queryType;
    SQLStatement dmlQuery;
    queryType = jj_consume_token(R_INSERT);
    T = jj_consume_token(S_IDENTIFIER);
    jj_consume_token(R_VALUES);
    jj_consume_token(O_OPENPAREN);
    InsertValueExpressions();
    jj_consume_token(O_CLOSEPAREN);
              dmlQuery = new SQLStatement();
              dmlQuery.setTableName(T.image);
              dmlQuery.setStatementType(queryType.kind);
    jj_consume_token(O_TERMINATOR);
        {if (true) return dmlQuery;}
    throw new Error("Missing return statement in function");
  }

  final public void InsertValueExpressions() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_STRING:
      jj_consume_token(QUOTED_STRING);
      break;
    case FLOAT:
      jj_consume_token(FLOAT);
      break;
    case INTEGER:
      jj_consume_token(INTEGER);
      break;
    case R_NULL:
      jj_consume_token(R_NULL);
      break;
    default:
      jj_la1[17] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_COMMA:
      jj_consume_token(O_COMMA);
      InsertValueExpressions();
      break;
    default:
      jj_la1[18] = jj_gen;
      ;
    }
  }

/* DELETE TUPLE */
  final public SQLStatement deleteTuple() throws ParseException {
    Token T;
    Token queryType;
    SQLStatement dmlQuery;
    queryType = jj_consume_token(R_DELETE);
    T = jj_consume_token(S_IDENTIFIER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_WHERE:
      jj_consume_token(R_WHERE);
      ColumnComparison();
      break;
    default:
      jj_la1[19] = jj_gen;
      ;
    }
              dmlQuery = new SQLStatement();
              dmlQuery.setTableName(T.image);
              dmlQuery.setStatementType(queryType.kind);
    jj_consume_token(O_TERMINATOR);
        {if (true) return dmlQuery;}
    throw new Error("Missing return statement in function");
  }

  final public void ColumnComparison() throws ParseException {
    jj_consume_token(S_IDENTIFIER);
    ComparisonOperators();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_STRING:
      jj_consume_token(QUOTED_STRING);
      break;
    case FLOAT:
      jj_consume_token(FLOAT);
      break;
    case INTEGER:
      jj_consume_token(INTEGER);
      break;
    default:
      jj_la1[20] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_AND:
    case R_OR:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case R_AND:
        jj_consume_token(R_AND);
        break;
      case R_OR:
        jj_consume_token(R_OR);
        break;
      default:
        jj_la1[21] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      ColumnComparison();
      break;
    default:
      jj_la1[22] = jj_gen;
      ;
    }
  }

  final public void ComparisonOperators() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_EQUAL:
      jj_consume_token(O_EQUAL);
      break;
    case O_GREATER:
      jj_consume_token(O_GREATER);
      break;
    case O_GREATEREQUAL:
      jj_consume_token(O_GREATEREQUAL);
      break;
    case O_LESS:
      jj_consume_token(O_LESS);
      break;
    case O_LESSEQUAL:
      jj_consume_token(O_LESSEQUAL);
      break;
    case O_NOTEQUAL2:
      jj_consume_token(O_NOTEQUAL2);
      break;
    case O_NOTEQUAL:
      jj_consume_token(O_NOTEQUAL);
      break;
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

//commit && rollback.
  final public void Transaction() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_COMMIT:
      jj_consume_token(K_COMMIT);
      jj_consume_token(O_TERMINATOR);
      break;
    case K_ROLLBACK:
      jj_consume_token(K_ROLLBACK);
      jj_consume_token(O_TERMINATOR);
      break;
    case 0:
      jj_consume_token(0);
      break;
    default:
      jj_la1[24] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/* DDL Statements */
  final public SQLStatement ProcessDDLStatement() throws ParseException {
    SQLStatement ddlQuery;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_CREATE:
      ddlQuery = create();
      break;
    case R_DROP:
      ddlQuery = drop();
      break;
    default:
      jj_la1[25] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
     {if (true) return ddlQuery;}
    throw new Error("Missing return statement in function");
  }

/* DROP TABLE */
  final public SQLStatement drop() throws ParseException {
    Token T;
    Token queryType;
    SQLStatement ddlQuery;
    queryType = jj_consume_token(R_DROP);
    T = jj_consume_token(S_IDENTIFIER);
              ddlQuery = new SQLStatement();
              ddlQuery.setTableName(T.image);
              ddlQuery.setStatementType(queryType.kind);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_CASCADE:
      jj_consume_token(R_CASCADE);
      jj_consume_token(R_CONSTRAINTS);
      break;
    default:
      jj_la1[26] = jj_gen;
      ;
    }
    jj_consume_token(O_TERMINATOR);
        {if (true) return ddlQuery;}
    throw new Error("Missing return statement in function");
  }

/* CREATE TABLE */
  final public SQLStatement create() throws ParseException {
    Token T;
    Token queryType;
    SQLStatement ddlQuery;
    queryType = jj_consume_token(R_CREATE);
    T = jj_consume_token(S_IDENTIFIER);
          ddlQuery = new SQLStatement ();
          ddlQuery.setTableName(T.image);
          ddlQuery.setStatementType(queryType.kind);
    jj_consume_token(O_OPENPAREN);
    ColumnsAndConstraints();
    jj_consume_token(O_CLOSEPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_HORIZONTAL:
      processHorizontal();
      break;
    default:
      jj_la1[27] = jj_gen;
      ;
    }
    jj_consume_token(O_TERMINATOR);
        /*ddlQuery.setAttributes(attributes);*/
        {if (true) return ddlQuery;}
    throw new Error("Missing return statement in function");
  }

  final public void processHorizontal() throws ParseException {
    jj_consume_token(R_HORIZONTAL);
    jj_consume_token(O_OPENPAREN);
    jj_consume_token(S_IDENTIFIER);
    jj_consume_token(O_OPENPAREN);
    PartioningLimits();
    jj_consume_token(O_CLOSEPAREN);
    jj_consume_token(O_CLOSEPAREN);
  }

  final public void PartioningLimits() throws ParseException {
    label_2:
    while (true) {
      jj_consume_token(INTEGER);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER:
        ;
        break;
      default:
        jj_la1[28] = jj_gen;
        break label_2;
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_COMMA:
      jj_consume_token(O_COMMA);
      jj_consume_token(INTEGER);
      break;
    default:
      jj_la1[29] = jj_gen;
      ;
    }
  }

  final public void ColumnsAndConstraints() throws ParseException {
    label_3:
    while (true) {
      Columns();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S_IDENTIFIER:
        ;
        break;
      default:
        jj_la1[30] = jj_gen;
        break label_3;
      }
    }
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case O_COMMA:
        ;
        break;
      default:
        jj_la1[31] = jj_gen;
        break label_4;
      }
      jj_consume_token(O_COMMA);
      Constraints();
    }

  }

  final public void Columns() throws ParseException {
   Token TName;
   Token TType;
    TName = jj_consume_token(S_IDENTIFIER);
    //name of the column
        TType = ColType();
    if (jj_2_7(2)) {
      jj_consume_token(O_COMMA);
      Columns();
    } else {
      ;
    }


  }

  final public Token ColType() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_INTEGER:
      jj_consume_token(R_INTEGER);
      break;
    case R_VARCHAR:
      jj_consume_token(R_VARCHAR);
      jj_consume_token(O_OPENPAREN);
      jj_consume_token(INTEGER);
      jj_consume_token(O_CLOSEPAREN);
      break;
    default:
      jj_la1[32] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
     {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

  final public void Constraints() throws ParseException {
    jj_consume_token(R_CONSTRAINT);
    ConstraintType();
    if (jj_2_8(2)) {
      jj_consume_token(O_COMMA);
      Constraints();
    } else {
      ;
    }
  }

  final public void ConstraintType() throws ParseException {
    jj_consume_token(S_IDENTIFIER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_CHECK:
      CustomCheckConstraitns();
      break;
    case R_UNIQUE:
    case R_PRIMARY:
      PrimaryOrUnique();
      break;
    case R_FOREIGN:
      ForeignKey();
      break;
    default:
      jj_la1[33] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void ForeignKey() throws ParseException {
    jj_consume_token(R_FOREIGN);
    jj_consume_token(O_OPENPAREN);
    jj_consume_token(S_IDENTIFIER);
    jj_consume_token(O_CLOSEPAREN);
    jj_consume_token(R_REFERENCES);
    jj_consume_token(S_IDENTIFIER);
    jj_consume_token(O_OPENPAREN);
    jj_consume_token(S_IDENTIFIER);
    jj_consume_token(O_CLOSEPAREN);
  }

  final public void PrimaryOrUnique() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_PRIMARY:
      jj_consume_token(R_PRIMARY);
      break;
    case R_UNIQUE:
      jj_consume_token(R_UNIQUE);
      break;
    default:
      jj_la1[34] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(O_OPENPAREN);
    jj_consume_token(S_IDENTIFIER);
    jj_consume_token(O_CLOSEPAREN);
  }

  final public void CustomCheckConstraitns() throws ParseException {
    jj_consume_token(R_CHECK);
    jj_consume_token(O_OPENPAREN);
    if (jj_2_9(2)) {
      jj_consume_token(S_IDENTIFIER);
      jj_consume_token(R_IS);
      jj_consume_token(R_NOT);
      jj_consume_token(R_NULL);
    } else if (jj_2_10(2)) {
      jj_consume_token(S_IDENTIFIER);
      ComparisonOperators();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S_IDENTIFIER:
        jj_consume_token(S_IDENTIFIER);
        break;
      case QUOTED_STRING:
        jj_consume_token(QUOTED_STRING);
        break;
      case FLOAT:
        jj_consume_token(FLOAT);
        break;
      case INTEGER:
        jj_consume_token(INTEGER);
        break;
      default:
        jj_la1[35] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else if (jj_2_11(2)) {
      jj_consume_token(S_IDENTIFIER);
      jj_consume_token(R_BETWEEN);
      jj_consume_token(INTEGER);
      jj_consume_token(R_AND);
      jj_consume_token(INTEGER);
    } else if (jj_2_12(2)) {
      jj_consume_token(S_IDENTIFIER);
      jj_consume_token(R_IN);
      jj_consume_token(O_OPENPAREN);
      SingleQuoteStrings();
      jj_consume_token(O_CLOSEPAREN);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(O_CLOSEPAREN);
  }

  final public void SingleQuoteStrings() throws ParseException {
    jj_consume_token(QUOTED_STRING);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_COMMA:
      jj_consume_token(O_COMMA);
      SingleQuoteStrings();
      break;
    default:
      jj_la1[36] = jj_gen;
      ;
    }
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_3R_5() {
    if (jj_scan_token(Q_ATTRIBUTE)) return true;
    if (jj_scan_token(O_COMMA)) return true;
    if (jj_3R_12()) return true;
    return false;
  }

  private boolean jj_3_2() {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    if (jj_scan_token(O_COMMA)) return true;
    return false;
  }

  private boolean jj_3_6() {
    if (jj_scan_token(O_COMMA)) return true;
    if (jj_3R_8()) return true;
    return false;
  }

  private boolean jj_3R_11() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_12() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(74)) {
    jj_scanpos = xsp;
    if (jj_scan_token(75)) return true;
    }
    return false;
  }

  private boolean jj_3_8() {
    if (jj_scan_token(O_COMMA)) return true;
    if (jj_3R_10()) return true;
    return false;
  }

  private boolean jj_3_12() {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    if (jj_scan_token(R_IN)) return true;
    return false;
  }

  private boolean jj_3_11() {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    if (jj_scan_token(R_BETWEEN)) return true;
    return false;
  }

  private boolean jj_3_9() {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    if (jj_scan_token(R_IS)) return true;
    return false;
  }

  private boolean jj_3_10() {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    if (jj_3R_11()) return true;
    return false;
  }

  private boolean jj_3R_10() {
    if (jj_scan_token(R_CONSTRAINT)) return true;
    return false;
  }

  private boolean jj_3R_8() {
    if (jj_scan_token(Q_ATTRIBUTE)) return true;
    return false;
  }

  private boolean jj_3_4() {
    if (jj_3R_6()) return true;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_5()) return true;
    return false;
  }

  private boolean jj_3R_6() {
    if (jj_scan_token(O_OPENPAREN)) return true;
    if (jj_scan_token(Q_ATTRIBUTE)) return true;
    if (jj_3R_11()) return true;
    if (jj_scan_token(Q_ATTRIBUTE)) return true;
    return false;
  }

  private boolean jj_3_7() {
    if (jj_scan_token(O_COMMA)) return true;
    if (jj_3R_9()) return true;
    return false;
  }

  private boolean jj_3R_7() {
    if (jj_scan_token(O_OPENPAREN)) return true;
    if (jj_scan_token(Q_ATTRIBUTE)) return true;
    if (jj_3R_11()) return true;
    return false;
  }

  private boolean jj_3_5() {
    if (jj_3R_7()) return true;
    return false;
  }

  private boolean jj_3_3() {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_9() {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public ParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[37];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x0,0x0,0x0,0x100,0x100,0x0,0x0,0x1800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1800000,0x800,0x1800000,0x800,0x0,0x1800000,0x0,0x0,0x6f8000,0x1,0x0,0x0,0x0,0x1000000,0x800,0x0,0x800,0x0,0x0,0x0,0x1800000,0x800,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x1e140000,0x1e140000,0x0,0x0,0x0,0x400000,0x8,0x0,0x10008,0x10008,0x400,0x400000,0x0,0x18100000,0x400000,0x8000,0x0,0x8000,0x0,0x400000,0x0,0x10008,0x10008,0x0,0x6,0x6000000,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x60080000,0x20080000,0x0,0x0,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x400,0x200,0x200,0x0,0x0,0x8000,0x0,0x0,0x0,0x0,0xc00,0x0,0x0,0x8000,0x0,0x8000,0x0,0x0,0x8000,0x0,0x0,0x0,0x0,0x0,0x100,0x2,0x0,0x0,0x1000,0x0,0x1,0x20,0x0,0x9000,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[12];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public Parser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public Parser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new ParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 37; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 37; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public Parser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new ParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 37; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 37; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public Parser(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 37; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 37; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[81];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 37; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 81; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 12; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
