set echo on;

alter session set nls_language = english;
alter session set nls_date_format = 'DD-MON-YYYY';
alter session set nls_date_language = english;



/* SELECT PARTIAL TABLES BY NULL VALUES IN JOIN ATTRIBUTE */
SELECT FLUGLINIE.FLC, FLUGLINIE.NAME, FLUGHAFEN.FHC, FLUGHAFEN.NAME
FROM FLUGLINIE, FLUGHAFEN
WHERE (FLUGLINIE.HUB = FLUGHAFEN.FHC);


/* SELECT ONE CONJUNCTIVE RESTRICTION */
SELECT FLUG.FLC, FLUG.FLNR, FLUGLINIE.NAME
FROM FLUG, FLUGLINIE
WHERE (FLUG.FLC = FLUGLINIE.FLC)
AND (FLUG.NACH = 'LHR');


/* SELECT ONE CONJUNCTIVE RESTRICTION */
SELECT PASSAGIER.NAME, PASSAGIER.VORNAME, BUCHUNG.BNR, BUCHUNG.FLC, BUCHUNG.FLNR
FROM PASSAGIER, BUCHUNG
WHERE (PASSAGIER.PNR = BUCHUNG.PNR)
AND (PASSAGIER.PNR <= 4);


/* SELECT ONE CONJUNCTIVE RESTRICTION ON ONE TABLE */
SELECT BUCHUNG.BNR, BUCHUNG.PNR, BUCHUNG.FLC, BUCHUNG.FLNR, BUCHUNG.FLNR, BUCHUNG.PREIS
FROM PASSAGIER, BUCHUNG
WHERE (BUCHUNG.PNR = PASSAGIER.PNR) AND (PASSAGIER.PNR = 3);


/* SELECT TWO CONJUNCTIVE RESTRICTIONS ON ONE TABLE */
SELECT PASSAGIER.PNR, PASSAGIER.NAME, BUCHUNG.BNR, BUCHUNG.VON, BUCHUNG.NACH
FROM PASSAGIER, BUCHUNG
WHERE (PASSAGIER.PNR = BUCHUNG.PNR)
AND (BUCHUNG.BNR <= 200) AND (BUCHUNG.NACH = 'LIM');


/* SELECT TWO CONJUNCTIVE RESTRICTIONS ON ONE TABLE */
SELECT PASSAGIER.NAME, PASSAGIER.VORNAME, BUCHUNG.BNR, BUCHUNG.FLC, BUCHUNG.FLNR
FROM PASSAGIER, BUCHUNG
WHERE (PASSAGIER.PNR = BUCHUNG.PNR)
AND (BUCHUNG.BNR <= 1300) AND (BUCHUNG.NACH = 'LIM');


/* SELECT TWO CONJUNCTIVE RESTRICTIONS ONE PER TABLE */
SELECT PASSAGIER.NAME, PASSAGIER.VORNAME, BUCHUNG.BNR, BUCHUNG.FLC, BUCHUNG.FLNR
FROM PASSAGIER, BUCHUNG
WHERE (PASSAGIER.PNR = BUCHUNG.PNR)
AND (BUCHUNG.BNR <= 1200) AND (PASSAGIER.LAND = 'RSA');



rollback;

