/*set echo on;

alter session set nls_language = english;
alter session set nls_date_format = 'DD-MON-YYYY';
alter session set nls_date_language = english;
*/

/* [[SELECT WHOLE TABLES]] */
SELECT FLUGLINIE.FLC, FLUGLINIE.NAME, FLUGHAFEN.FHC, FLUGHAFEN.STADT
FROM FLUGLINIE, FLUGHAFEN
WHERE (FLUGLINIE.HUB = FLUGHAFEN.FHC);


/* [[SELECT ONE CONJUNCTIVE RESTRICTION]] */
SELECT FLUG.FNR, FLUG.FLC, FLUG.FLNR, FLUGLINIE.NAME, FLUG.VON, FLUG.NACH
FROM FLUG, FLUGLINIE
WHERE (FLUG.FLC = FLUGLINIE.FLC)
AND (FLUG.NACH = 'LAX');


/* [[SELECT TWO CONJUNCTIVE RESTRICTIONS ON ONE TABLE]] */
SELECT FLUG.FNR, FLUG.FLC, FLUG.FLNR, FLUGLINIE.NAME, FLUG.VON, FLUG.NACH
FROM FLUG, FLUGLINIE
WHERE (FLUG.FLC = FLUGLINIE.FLC)
AND (FLUG.NACH = 'CDG') AND (FLUG.VON = 'FRA');


/* [[SELECT TWO CONJUNCTIVE RESTRICTIONS ONE PER TABLE]] */
SELECT FLUG.FNR, FLUG.FLC, FLUG.FLNR, FLUGLINIE.NAME, FLUG.VON, FLUG.NACH
FROM FLUG, FLUGLINIE
WHERE (FLUG.FLC = FLUGLINIE.FLC)
AND (FLUG.NACH = 'CDG') AND (FLUGLINIE.LAND = 'D  ');


/* [[SELECT ONE DISJUNCTIVE RESTRICTION ON ONE TABLE]] */
SELECT BUCHUNG.BNR, BUCHUNG.PNR, BUCHUNG.FLC, BUCHUNG.FLNR, BUCHUNG.FLNR, BUCHUNG.PREIS
FROM PASSAGIER, BUCHUNG
WHERE (BUCHUNG.PNR = PASSAGIER.PNR)
AND (PASSAGIER.PNR < 3) OR (PASSAGIER.PNR > 10000);


/* [[SELECT TWO CONJUNCTIVE RESTRICTIONS ON TWO TABLES]] */
SELECT BUCHUNG.BNR, BUCHUNG.PNR, BUCHUNG.FLC, BUCHUNG.FLNR, BUCHUNG.FLNR, BUCHUNG.PREIS
FROM PASSAGIER, BUCHUNG
WHERE (BUCHUNG.PNR = PASSAGIER.PNR)
AND (PASSAGIER.PNR < 8) AND (BUCHUNG.PREIS < 700);


rollback;
