% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spe_to_seurat.R
\name{spe_to_seurat}
\alias{spe_to_seurat}
\title{Convert a \code{SpatialExperiment} object to a \code{Seurat} object}
\usage{
spe_to_seurat(
  spe,
  spatial_cols = c(tissue = "in_tissue", row = "array_row", col = "array_col", imagerow =
    "pxl_row_in_fullres", imagecol = "pxl_col_in_fullres"),
  verbose = TRUE
)
}
\arguments{
\item{spe}{A
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class} with
\code{colData()} or \code{spatialCoords()}
columns given by \code{spatial_cols}. This does not have to be a stitched
\code{spe} object as this function should work with any type of \code{spe} objects.}

\item{spatial_cols}{A \code{character(5)} named vector mapping which \code{colData(spe)}
or \code{spatialCoords(spe)} columns contain the \code{tissue}, \code{row}, \code{col},
\code{imagerow}, and \code{imagecol} information expected by Seurat.}

\item{verbose}{A \code{logical(1)} vector. If \code{TRUE}, print status update
about the conversion process. This information can be useful for debugging.}
}
\value{
A \code{Seurat} object.
}
\description{
Given a \link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class}
object, first \code{as.Seurat()} is run, which operates on
\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment-class}
objects. The remaining components (images, spatial coordinates) are added
manually. The actual appearance of images are buggy for now.
}
\details{
Note that only the \code{lowres} images from \code{imgData(spe)} will be used.
}
\examples{
## Download some example data
spe <- spatialLIBD::fetch_data(type = "spatialDLPFC_Visium_example_subset")

## Make the column names unique
colnames(spe) <- spatialLIBD::add_key(spe)$key

## Convert from a SpatialExperiment to a Seurat object
seur <- spe_to_seurat(spe)
seur

## Example with an stitched SPE object
spe_stitched <- spatialLIBD::fetch_data(type = "visiumStitched_brain_spe")
seur_stitched <- spe_to_seurat(spe_stitched)

## Let's look at our resulting Seurat object
seur_stitched
}
\author{
Nicholas J. Eagles
}
