% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_fiji_coords.R
\name{prep_fiji_coords}
\alias{prep_fiji_coords}
\title{Apply transform info from Fiji XML output}
\usage{
prep_fiji_coords(sample_info, out_dir)
}
\arguments{
\item{sample_info}{A \code{data.frame()} with columns \code{capture_area},
\code{group}, \code{fiji_xml_path}, \code{fiji_image_path},
\code{spaceranger_dir}, \code{intra_group_scalar}, and
\code{group_hires_scalef}. The last two are made by \code{rescale_fiji_inputs()}.}

\item{out_dir}{A \code{character(1)} vector giving a path to a directory to
place the output pixel coordinates CSVs. Provided the parent directory
exists, \code{out_dir} will be created if necessary.}
}
\value{
This function returns a \code{character()} with the file paths to the
\code{tissue_positions.csv} files it created.
}
\description{
Given a \code{data.frame()} of sample information (\code{sample_info}) with
columns \code{capture_area}, \code{group}, and \code{fiji_xml_path},
expected to have one unique path to Fiji XML output per group, read in
the pixel coordinates from each capture area's \code{tissue_positions.csv}
file from SpaceRanger, and transform using the rotation matrix specified
by Fiji \url{https://imagej.net/software/fiji/}.
Write one new \code{tissue_positions.csv} file per group.
}
\examples{
#    Define sample information for the example human brain data
sample_info <- dplyr::tibble(
    group = "Br2719",
    capture_area = c("V13B23-283_A1", "V13B23-283_C1", "V13B23-283_D1")
)
#   Add 'spaceranger_dir' column
sr_dir <- tempdir()
temp <- unzip(
    spatialLIBD::fetch_data("visiumStitched_brain_spaceranger"),
    exdir = sr_dir
)
sample_info$spaceranger_dir <- file.path(
    sr_dir, sample_info$capture_area, "outs", "spatial"
)

#   Add Fiji-output-related columns
fiji_dir <- tempdir()
temp <- unzip(
    spatialLIBD::fetch_data("visiumStitched_brain_Fiji_out"),
    exdir = fiji_dir
)
sample_info$fiji_xml_path <- temp[grep("xml$", temp)]
sample_info$fiji_image_path <- temp[grep("png$", temp)]

## Re-size images and add more information to the sample_info
sample_info <- rescale_fiji_inputs(sample_info, out_dir = tempdir())

spe_input_dir <- tempdir()
out_file <- prep_fiji_coords(sample_info, out_dir = spe_input_dir)
out_file

#    A file of spatial coordinates for the stitched Br2719 was produced
readr::read_csv(out_file)
}
\author{
Nicholas J. Eagles
}
\concept{functions for parsing Fiji outputs}
