# Getting help with `visiumStitched`

Thank you for using `visiumStitched`!
Before filing an issue, there are few things you should know to make the process
as smooth as possible for both parties.

## Make a reprex

Start by making a minimally **repr**oducible **ex**ample, also known as a
'reprex'. You may use the [`reprex`](https://reprex.tidyverse.org/) R package to
create one, though it is not necessary but it does help. It will make all of
your R-question-asking endeavors easier. Learning
[how to use it](https://reprex.tidyverse.org/articles/learn-reprex.html) takes
about 5 to 10 minutes.

For more tips on how to make a minimally **repr**oducible **ex**ample, see this
[StackOverflow link](https://stackoverflow.com/questions/5963269/how-to-make-a-great-r-reproducible-example).

## Where to post it?

The [Bioconductor help](http://bioconductor.org/help/) web page gives an
overview of places that may help answer your question.

* Bioconductor software related questions, such as bug reports and feature
  requests, should be addressed in the appropriate `Bioconductor/visiumStitched`
  GitHub repository. Follow our bug report and feature request templates on
  GitHub. If the package does not have a GitHub repository, see the next bullet
  point.

* Bioconductor software usage questions should be addressed in the
  [Bioconductor Support Website](https://support.bioconductor.org/). Make sure
  to use the
  [appropriate package tag](https://support.bioconductor.org/tag/visiumStitched),
  otherwise the package authors will not get a notification.
  
* General R questions can be posed at StackOverflow or at the
  [RStudio Community](https://community.rstudio.com/) website especially if they
  pertain to the `tidyverse` or the RStudio GUI or related products.

## Issues or Feature Requests

Before opening a new issue or feature request, be sure to
[search issues and pull requests](https://github.com/LieberInstitute/visiumStitched/issues)
to ensure that one does not already exist or has been implemented in the
development version.

**Note**. You can remove the `is:open` search term in the issues page to search
through open and closed issues. See
[this link to learn more](https://help.github.com/articles/searching-issues-and-pull-requests/)
about modifying the search.

## What happens next?

Our Bioconductor maintainers are limited in resources but they do strive to be
as responsive as possible.

Please do not forget to tag the appropriate maintainer in the issue with their
GitHub username (e.g., @username).

In order to make it easy as possible for Bioconductor core developers to
remediate the issue. Provide an accurate, brief, and reproducible report
as outlined in the issue templates.

Thank you for trusting Bioconductor.
