# Copyright (c) 2007 The Regents of The University of Michigan
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met: redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer;
# redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution;
# neither the name of the copyright holders nor the names of its
# contributors may be used to endorse or promote products derived from
# this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# Authors: Ali Saidi

import m5
from m5.objects import *
m5.util.addToPath('../configs/')
from common import FSConfig

try:
    system = FSConfig.makeSparcSystem('atomic')
except IOError as e:
    skip_test(reason=str(e))

system.voltage_domain = VoltageDomain()
system.clk_domain = SrcClockDomain(clock = '1GHz',
                                   voltage_domain = system.voltage_domain)
system.cpu_clk_domain = SrcClockDomain(clock = '1GHz',
                                       voltage_domain = system.voltage_domain)
cpu = AtomicSimpleCPU(cpu_id=0, clk_domain = system.cpu_clk_domain)
system.cpu = cpu
# create the interrupt controller
cpu.createInterruptController()
cpu.connectAllPorts(system.membus)

# create the memory controllers and connect them, stick with
# the physmem name to avoid bumping all the reference stats
system.physmem = [SimpleMemory(range = r)
                  for r in system.mem_ranges]
for i in xrange(len(system.physmem)):
    system.physmem[i].port = system.membus.master

root = Root(full_system=True, system=system)

m5.ticks.setGlobalFrequency('2GHz')
