# Copyright (c) 2008 The Regents of The University of Michigan
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met: redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer;
# redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution;
# neither the name of the copyright holders nor the names of its
# contributors may be used to endorse or promote products derived from
# this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# Authors: Gabe Black

from m5.params import *
from m5.SimObject import SimObject

# A generic pin to drive an interrupt signal generated by a device.
class X86IntSourcePin(SimObject):
    type = 'X86IntSourcePin'
    cxx_class = 'X86ISA::IntSourcePin'
    cxx_header = "dev/x86/intdev.hh"

# A generic pin to receive an interrupt signal generated by another device.
class X86IntSinkPin(SimObject):
    type = 'X86IntSinkPin'
    cxx_class = 'X86ISA::IntSinkPin'
    cxx_header = "dev/x86/intdev.hh"

    device = Param.SimObject("Device this pin belongs to")
    number = Param.Int("The pin number on the device")

# An interrupt line which is driven by a source pin and drives a sink pin.
class X86IntLine(SimObject):
    type = 'X86IntLine'
    cxx_class = 'X86ISA::IntLine'
    cxx_header = "dev/x86/intdev.hh"

    source = Param.X86IntSourcePin("Pin driving this line")
    sink = Param.X86IntSinkPin("Pin driven by this line")
